#ifndef NUMBER_H
#define NUMBER_H

#include "Python.h"

#if defined(_WIN32) || defined(__WIN32__)
#  ifdef __MINGW32__
#    include <math.h>
#  else
#    include <float.h>
#    define isnan(x) _isnan(x)
#    define finite(x) _finite(x)
#    define isinf(x) (finite(x) || isnan(x)) ? 0 : (x > 0) ? 1 : -1
#  endif
#elif defined(__sun) || defined(__sgi) || defined(__svr4__) || defined(__osf__)
#  include <ieeefp.h>
#  define isinf(x) (finite(x) || isnan(x)) ? 0 : (x > 0) ? 1 : -1
#endif

#define PyNumber_Finite(x) ((PyFloat_Check(x) && finite(PyFloat_AS_DOUBLE(x))) \
			    || PyLong_Check(x) || PyInt_Check(x))

#define PyNumber_IsNaN(x) (PyFloat_Check(x) && isnan(PyFloat_AS_DOUBLE(x)))

#define PyNumber_IsInf(x) (PyFloat_Check(x) && isinf(PyFloat_AS_DOUBLE(x)))

#endif /* NUMBER_H */
