########################################################################
#
# File Name:            _4odb.py
#
# Documentation:        http://docs.4suite.org/4ODS/_4odb.py.html
#
"""
Command-line invokation of the 4XSLT processor
WWW: http://4suite.org/4ODS        e-mail: support@4suite.org

Copyright (c) 1999 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import re, string, os, sys, getopt, cStringIO, traceback
from Ft.Ods import __version__

__doc__ = """4Ods Command line application."""

import create
import clean
import clear
import destroy
import dig
import grant
import metadig
import odmsdump
import odmsload
import init
import register

g_commands = [
    create,
    destroy,
    dig,
    clean,
    clear,
    grant,
    metadig,
    odmsdump,
    odmsload,
    init,
    register,
    ]



from Ft.Lib.CommandLine import Options, CommandLineApp, Arguments, Command
from Ft.Lib.CommandLine.CommandLineApp import CommandLineApp
class OdsCommandLineApp(CommandLineApp):

    def __init__(self):
        options = [Options.Option('a',
                                  'adapter=',
                                  'use the specified adapter'),
                   ]
        CommandLineApp.__init__(self,
                                '4odb',
                                '4ODS version %s' % __version__,
                                __doc__,
                                map(lambda x:x.Register(),g_commands),
                                options = Options.Options(options),
                                )

