########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Rdf/Parsers/Versa/MessageSource.py,v 1.5 2004/01/26 07:40:18 jkloth Exp $
"""
Versa error codes and messages

Copyright 2003 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft import TranslateMessage as _
from Ft.Rdf.Parsers.Versa import RuntimeException, CompiletimeException

COMPILETIME = {
    CompiletimeException.INTERNAL: _('There is an internal bug in 4Suite/Versa. '
        'Please make a post to the 4Suite mailing list to report this error '
        'message to the developers. Include platform details and info about '
        'how to reproduce the error. Info about the mailing list is at '
        'http://lists.fourthought.com/mailman/listinfo/4suite. '
        'The error code to report is: %s'),
    CompiletimeException.SYNTAX: _('Versa parse error at line %d, column %d: %s'),
    CompiletimeException.PROCESSING: _('Error evaluating Versa expression.'),
    #CompiletimeException.: _(''),
    }

RUNTIME = {
    RuntimeException.INTERNAL: _('There is an internal bug in 4Suite/Versa. '
        'Please make a post to the 4Suite mailing list to report this error '
        'message to the developers. Include platform details and info about '
        'how to reproduce the error. Info about the mailing list is at '
        'http://lists.fourthought.com/mailman/listinfo/4suite. '
        'The error code to report is: %s'),
    RuntimeException.UNDEFINED_VARIABLE: _('Variable undefined: ("%s", "%s").'),
    RuntimeException.UNDEFINED_PREFIX: _('Undefined namespace prefix: "%s".'),
    RuntimeException.WRONG_ARGUMENTS: _('Error in arguments to %s: %s'),
    RuntimeException.NO_CONTEXT: _("There is no context currently defined. "
                                   "You may have used \".\" where you meant \"'.'\""),
    #RuntimeException.: _(''),
    }

