########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Create/Alias.py,v 1.4 2004/09/23 20:53:28 mbrown Exp $
"""
Implementation of '4ss create alias' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command creates a new Alias resource for an \
existing resource in a 4Suite repository. If necessary, you will be \
prompted first for credentials and access info to connect to the \
repository. \
Prior to 4Suite 1.0b1, this command was known as '4ss add alias'."""


from Ft.Server.Client.Commands import CommandUtil


def Run(options, args):
    repo = CommandUtil.GetRepository(options, '4ss.create.alias')
    if repo is not None:
        commit = False
        try:
            res = repo.fetchResource(args['sourcePath'])
            res.addAlias(args['alias'])
            commit = True
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass

    return


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('alias',
                          """Create a new Alias for an existing resource in a repository""",
                          '/path/to/docAlias.rdf /path/to/actualDoc.rdf',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('alias',
                                                                  "The full repository path of the new alias.",
                                                                  str),
                                       Arguments.RequiredArgument('sourcePath',
                                                                  "The path to the resource being aliased.",
                                                                  str),
                                       ],

                          fileName = __file__,
                          )
    return cmd

