########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Fetch/Resource.py,v 1.11 2004/09/23 20:53:29 mbrown Exp $
"""
Implementation of '4ss fetch resource' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command prints a summary of the metadata for a \
resource in a 4Suite repository. Metadata includes the resource type, \
creation date, last modified date, Internet Media Type, size, owner, \
and ACL. If necessary, you will be prompted first for credentials and \
access info to connect to the repository."""

from Ft.Server.Client.Commands import CommandUtil


def Run(options, args):
    repo = CommandUtil.GetRepository(options, '4ss.fetch.resource')
    if repo is not None:
        try:
            ri = repo.fetchResource(args['path'])
            ri.pprint()
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('resource',
                          'Print general info about a resource in a repository',
                          '/ftss/data/identity.xslt',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('path',
                                                                  'the path of the resource',
                                                                  str),
                                       ],

                          fileName = __file__,
                          )
    return cmd
