########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Fetch/UserData.py,v 1.9 2004/09/23 20:53:29 mbrown Exp $
"""
Implementation of '4ss fetch userdata' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command lists the custom name-value data pairs \
associated with a User resource in a 4Suite repository. If \
necessary, you will be prompted first for credentials and access info \
to connect to the repository."""

import sys

from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import ResourceTypes


def Run(options, args):
    repo = CommandUtil.GetRepository(options, '4ss.fetch.userdata')
    if repo is not None:
        name = args['userName']
        try:
            user = repo.fetchUserOrGroupByName(name)
            if user is not None:
                if user.isResourceType(ResourceTypes.ResourceType.USER):
                    if args['key']:
                        userData = {}
                        for key in args['key']:
                            userData[key] = user.get(key)
                    else:
                        userData = user.getUserData()

                    names = userData.keys()
                    names.sort()
                    CommandUtil.WritePreamble("User: %s" % args['userName'])
                    for name in names:
                        print "%s: %s" % (name,userData[name])
                else:
                    #FIXME: use FtServerClientException?
                    sys.stderr.write("%s is a Group, not a User.\n" % name)
                    sys.stderr.flush()

            else:
                #FIXME: use FtServerClientException?
                sys.stderr.write("User %s does not exist.\n" % name)
                sys.stderr.flush()
        finally:
            try:
                repo.txRollback()
            except:
                pass

    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('userdata',
                          'List custom data associated with a User in a repository',
                          'root',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('userName',
                                                                  'the name of the User',
                                                                  str),
                                       Arguments.ZeroOrMoreArgument('key',
                                                                    'the key (name part) of a name-value pair; if none are given, all data will be listed',
                                                                    str),
                                       ],
                          fileName = __file__,
                          )
    return cmd
