########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Install.py,v 1.26 2005/02/27 04:17:30 jkloth Exp $
"""
Implementation of '4ss install' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command reads a 4Suite repository application's \
setup XML file from the local filesystem and uses it to install, \
update or remove the application in a repository. If necessary, you \
will be prompted first for credentials and access info to connect to \
the repository."""

import os

from Ft import GetConfigVar
from Ft.Lib import Uri
from Ft.Server.Client import FtServerClientException
from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common.Install import InstallUtil


def Run(options,args):
    basePath = options.get('base','/')
    if options.has_key('demo'):
        #Get the Demo Directory
        file = os.path.join(GetConfigVar('DATADIR'), 'Demos', 'setup.xml')
        if not options.has_key('base'):
            basePath = '/ftss/'
    elif options.has_key('dashboard'):
        #Get a Console file
        file = os.path.join(GetConfigVar('DATADIR'), 'Dashboard', 'setup.xml')
        if not options.has_key('base'):
            basePath = '/ftss/'

    elif not args.has_key('setup'):
        sys.stderr.write("You must specify either --demo or a setup file\n")
        sys.stderr.flush()
    else:
        file = args['setup']

    quiet = options.get('quiet')

    fd = open(file)
    pl = InstallUtil.Deserialize(fd, Uri.OsPathToUri(file))
    fd.close()

    repo = CommandUtil.GetRepository(options, '4ss.install')
    if repo is not None:
        commit = False
        try:
            pl.install(repo, basePath, quiet, checkAcl=not(options.has_key("no-acl")))
            commit = True
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass

    return


def GetAvailableProducts(filename):
    print "GetAvailableProducts:", filename
    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('install',
                          'Install, update, or remove a repository application',
                          'GuestBook',
                          __doc__,
                          function = Run,
                          options=Options.Options([Options.Option(None,
                                                                  'demo',
                                                                  'install the 4Suite repository demo applications'),
                                                   Options.Option(None,
                                                                  'dashboard',
                                                                  'install the 4Suite repository Dashboard applicaiton'),
                                                   Options.Option('D',
                                                                  'delete',
                                                                  'delete an installed repository application'),
                                                   Options.Option('b',
                                                                  'base=',
                                                                  'base path (in the repo) where the application should be installed'),
                                                   Options.Option('q',
                                                                  'quiet',
                                                                  "don't display what is happening"),
                                                   Options.Option(None,
                                                                  'no-acl',
                                                                  "don't sync ACL (install faster)"),
                                           ]),

                          arguments = [Arguments.OptionalArgument('setup',
                                                                  'the location of the setup XML file on the local filesystem; if not given, then you must provide the --demo flag',
                                                                  str),
                                       ],
                          fileName = __file__,
                          )
    return cmd
