import XmlDocumentClient, GroupableObjectMixin

from Ft.Server.Common import ResourceTypes, Schema
from Ft.Server.FtRpc import Commands

class GroupClient(XmlDocumentClient.XmlDocumentClient,GroupableObjectMixin.GroupableObjectMixin):
    """
    Contains implementation for a group resource which is a set of specified users
    """

    def addMember(self,user):
        """
        Add a member to this group
        """
        return Commands.RemoteMethodCommand(
            'addMember', self._path,
            ((None, user.getAbsolutePath()),)
            ).send(self._connection).results

    def getMembers(self):
        """
        Get a list of all the users that are members of this group
        """
        res = []
        for path in self.getMemberPaths():
            res.append(self.getParent().fetchResource(path))
        return res

    def getMemberPaths(self):
        """
        Get a list of names of all users that are members of this group
        """
        return Commands.RemoteMethodCommand(
            'getMemberPaths', self._path,
            ()
            ).send(self._connection).results

    def removeMember(self,user):
        """
        Remove a user from this group
        """
        return Commands.RemoteMethodCommand(
            'removeMember', self._path,
            ((None, user.getAbsolutePath()),)
            ).send(self._connection).results

    def getUsername(self):
        """
        Get the user name of this group
        """
        return Commands.RemoteMethodCommand(
            'getUsername', self._path,
            ()
            ).send(self._connection).results

