<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
	<!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
	<!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
	<!ENTITY f "http://xmlns.4suite.org/ext">
	<!ENTITY fres "http://xmlns.4suite.org/reserved">
	<!ENTITY dc "http://purl.org/dc/elements/1.1/">
	<!ENTITY fschema "http://schemas.4suite.org/4ss">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fcore="http://xmlns.4suite.org/4ss/score" xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" xmlns:fhttp="http://xmlns.4suite.org/4ss/http" xmlns:exslt="http://exslt.org/common" xmlns:exslt-set="http://exslt.org/sets" xmlns:exslt-math="http://exslt.org/math" xmlns:exslt-functions="http://exslt.org/functions" xmlns:exslt-date-time="http://exslt.org/dates-and-times" xmlns:dc="&dc;" xmlns:fres="&fres;" xmlns:rdf="&rdf;" xmlns:f="&f;" xmlns:fschema="http://schemas.4suite.org/4ss" extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">
	<!--
File:  index.xslt

Description:

    This is the main entry point into the Dask board.


WWW: http://4suite.org        e-mail: support@4suite.org

Copyright 2001-2002 Fourthought Inc, USA.
See  http://4suite.org/COPYRIGHT  for license and copyright information

  -->
	<xsl:template name="server-manager">
		<input type="hidden" name="action" value="changeServer"/>
		<input type="hidden" name="serverPath" value="{$resourcePath}"/>
		<table class="normal" cellpadding="4" cellspacing="1">
			<tr>
				<td colspan="2">
					<span class="blackTitle">Editing Server</span>
				</td>
			</tr>
			<tr>
				<td colspan="2" align="middle">
					<hr/>
				</td>
			</tr>
			<tr>
				<th align="right" class="grayBar">Description</th>
				<td>
					<textarea name="description">
						<xsl:value-of select="/fres:Server/dc:Description"/>
					</textarea>
				</td>
			</tr>
			<tr>
				<th align="right" class="grayBar">Running?</th>
				<td>
					<input type="checkbox" name="running" value="yes">
						<xsl:if test='/fres:Server/fres:Status/@running = "1"'>
							<xsl:attribute name="checked">yes</xsl:attribute>
						</xsl:if>
					</input>
				</td>
			</tr>
			<tr>
				<th align="right" class="grayBar" width="30%">Module</th>
				<td width="70%">
					<input type="text" name="module" value="{/fres:Server/fres:Module}"/>
				</td>
			</tr>
			<tr>
				<th align="right" class="grayBar" width="30%">Handler</th>
				<td width="70%">
					<input type="text" name="handler" value="{/fres:Server/fres:Handler}"/>
				</td>
			</tr>
			<tr>
				<th align="right" class="grayBar" width="30%">Port</th>
				<td width="70%">
					<input type="text" name="port" value="{/fres:Server/fres:Port}"/>
				</td>
			</tr>
			<tr>
				<th align="right" class="grayBar" width="30%">Server Admin</th>
				<td width="70%">
					<input type="text" name="serverAdmin" value="{/fres:Server/fres:ServerAdmin}"/>
				</td>
			</tr>
			<tr>
				<th align="right" class="grayBar" width="30%">Server Name</th>
				<td width="70%">
					<input type="text" name="serverName" value="{/fres:Server/fres:ServerName}"/>
				</td>
			</tr>
			<tr>
				<th align="right" class="grayBar" width="30%">Log Level</th>
				<td width="70%">
					<input type="text" name="logLevel" value="{/fres:Server/fres:LogLevel}"/>
				</td>
			</tr>
			<!--
			<tr>
				<td colspan="2" align="middle">
					<hr/>
				</td>
			</tr>
			<tr>
				<th colspan="2" align="middle">Default Stylesheets for Resource Types</th>
			</tr>
			<tr>
				<th align="middle">Types</th>
				<th align="middle">Stylesheet</th>
			</tr>
			<xsl:for-each select="/fres:Server/fres:DefaultXslt">
				<tr>
					<th align="right" class="grayBar">
						<xsl:value-of select='substring-after(@type,"#")'/>s</th>
					<td>
						<input type="text" size="40" name="{@type}defaultXslt" value="{.}"/>
					</td>
				</tr>
			</xsl:for-each> -->
			<tr>
				<td colspan="2" align="middle">
					<input type="submit" value="Change {$resourcePath}"/>
				</td>
			</tr>
		</table>
	</xsl:template>
</xsl:stylesheet>
