########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Xslt/__init__.py,v 1.9 2004/12/24 22:02:35 mbrown Exp $
"""
XSLT extension elements and functions supporting the 4SS repository API

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

#Must come first because of circular import
import Container, DocumentDefinition, GroupableObject, Group, Http, RawFile, Model, Repository, ResourceMetaData, Server, UriReferenceFile, User, XmlDocument, XmlRpcClient, XPathDocumentDefinition

mods = [Container,
        DocumentDefinition,
        GroupableObject,
        Group,
        Http,
        RawFile,
        Model,
        Repository,
        ResourceMetaData,
        Server,
        UriReferenceFile,
        User,
        XmlDocument,
        XPathDocumentDefinition,
        XmlRpcClient,
        ]

import Ns

ExtNamespaces = {
    Ns.SCORE_NS : 'fcore',
    Ns.HTTP_NS : 'fhttp',
    Ns.RDF_NS : 'frdf',
    Ns.IMAP_NS : 'fimap',
    Ns.UTIL_NS : 'futil',
    }

ExtFunctions = {}
ExtElements = {}

for mod in mods:
    ExtFunctions.update(getattr(mod,'ExtFunctions'))
    ExtElements.update(getattr(mod,'ExtElements'))

del mod
