<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  extension-element-prefixes="fhttp"
  version="1.0">

  <xsl:variable name="rh-raw">
    <fhttp:request-headers/>
  </xsl:variable>
  <xsl:variable name="rh" select="exslt:node-set($rh-raw)"/>

  <xsl:template name="get-user-agent-type">
    <xsl:variable name="user-agent-string"
      select="normalize-space($rh/Header[Name = 'user-agent']/Value)"/>
    <xsl:choose>
      <xsl:when test="contains($user-agent-string,'MSIE 5')">
        <xsl:text>IE5</xsl:text>
      </xsl:when>
      <xsl:when test="contains($user-agent-string,'MSIE 4')">
        <xsl:text>IE4</xsl:text>
      </xsl:when>
      <xsl:when test="not(contains($user-agent-string,'MSIE')) and
                      starts-with($user-agent-string,'Mozilla/4')">
        <xsl:text>NS4</xsl:text>
      </xsl:when>
      <xsl:otherwise>
        <xsl:message>
          Unknown User Agent: <xsl:value-of
          select="$user-agent-string"/>
        </xsl:message>
        <xsl:text>X</xsl:text>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
