<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY nbsp "&#160;">
  <!ENTITY bbschema "http://uche.ogbuji.net/example/buyerbase/schema#">
  <!ENTITY bb "http://uche.ogbuji.net/example/buyerbase">
  <!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
  <!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
  <!ENTITY f "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
  <!ENTITY dc "http://purl.org/dc/elements/1.1/">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:frdf="http://xmlns.4suite.org/4ss/rdf"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-set="http://exslt.org/sets"
  xmlns:exslt-math="http://exslt.org/math"
  xmlns:exslt-functions="http://exslt.org/functions"
  xmlns:exslt-date-time="http://exslt.org/dates-and-times"
  xmlns:dc="&dc;"
  xmlns:fres="&fres;"
  xmlns:bbschema="&bbschema;"
  xmlns:bb="&bb;"
  xmlns:rdf="&rdf;"
  xmlns:f="&f;"
  extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time"
  exclude-result-prefixes="f frdf fhttp fcore fres exslt exslt-set exslt-math exslt-functions exslt-date-time dc bb rdf bbschema">


  <!--
File:  new-purchase.xslt

Description:

    This stylesheet generates a "shopping cart" page for a customer,
    with a form that allows items to be added to a new purchase. The
    form data will be processed by submit-cart.xslt when adding an
    item to the cart, or by submit-purchase.xslt when saving /
    "checking out".

    This stylesheet expects to be applied to a customer XML document.
    It uses the customer data to construct a Versa query that gets the
    purchase data from the RDF model.

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
  -->

  <xsl:include href="menu-includes.xslt"/>

  <xsl:param name='fres:absolute-path'/>

  <xsl:template match="/">
    <xsl:choose>
      <xsl:when test="not(fcore:has-session())">
        <fhttp:response-uri uri="/buyerbase/?xslt=home.xslt"/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="menus">
          <xsl:with-param name="include-javascript" select="true()"/>
          <xsl:with-param name="pageTitle" select="'Buyer Base - New Purchase'"/>
        </xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- body content -->
  <xsl:template name="body">
    <table width="695">
      <tr>
        <td colspan="2">
          <p class="blackTitle">
            <a href="/buyerbase/?xslt=index.xslt">
              <font color="#000000">View Customer Index</font>
            </a>
            <xsl:text>&nbsp;|&nbsp;</xsl:text>
            <a href="{$fres:uri-path}?xslt=../customer.xslt">
              <font color="#000000">View Customer File</font>
            </a>
            <xsl:text>&nbsp;|&nbsp;</xsl:text>
            <a href="{$fres:uri-path}?xslt=../purchase-summary.xslt">
              <font color="#000000">View Purchases</font>
            </a>
            <xsl:text>&nbsp;|&nbsp;</xsl:text>
            <a href="/buyerbase/?xslt=logout.xslt">
              <font color="#000000">Logout</font>
            </a>
          </p>
        </td>
      </tr>
      <xsl:call-template name="display-customer"/>
      <xsl:call-template name="add-item"/>
      <xsl:call-template name="current-order"/>
      <tr>
        <td colspan='2'>
          <br/>
          <form name="cart" method="post" action="{$fres:uri-path}?xslt=../submit-purchase.xslt">
            <input type="hidden" id="actionToDo" name="actionToDo" value="submit"/>
            <input name="submit-order" class="button" type="submit" tabindex="18" value="Save / Checkout" style="width: 130"/>
          </form>
        </td>
      </tr>
    </table>
  </xsl:template>

  <xsl:template name="display-customer">
    <tr class="cellBlue">
      <td class="menucell" colspan="2" align="left"><div class="menu">Customer</div></td>
    </tr>
    <tr>
      <td><div class="normal">Name: <xsl:value-of select='bb:customer/bb:fullname'/></div></td>
      <td><div class="normal">Work Phone: <xsl:value-of select='bb:customer/bb:phone[@desc="work"]'/></div></td>
    </tr>
    <tr>
      <td colspan="2">&nbsp;</td>
    </tr>
  </xsl:template>

  <xsl:template name="add-item">
    <tr class="cellBlue">
      <td colspan="2" align="left" class="menucell"><div class="menu">Add Item</div></td>
    </tr>
    <tr>
      <td colspan="2">
        <form name="main" method="post" action="{$fres:uri-path}?xslt=../submit-cart.xslt">
          <input type="hidden" id="actionToDo" name="actionToDo" value="add"/>
          <table border="0">
            <tr>
              <td align="right">
                <div class="normal">Product:&nbsp;</div>
              </td>
              <td align="right">
                <div class="normal">
                  <select size="1" name="prod-id" class="drop-down">
                    <xsl:apply-templates select="frdf:complete(frdf:any(),'&rdf;type','&bbschema;Product')" mode="products">
                      <xsl:sort select="Subject"/>
                    </xsl:apply-templates>
                  </select>
                </div>
              </td>
            </tr>
            <tr>
              <td align="right">
                <div class="normal">Quantity:&nbsp;</div>
              </td>
              <td>
                <input name="qty" class="textBox" type="text" tabindex="8" size="25" style="width: 64; height: 22"/>
              </td>
            </tr>
            <tr>
              <td>
                <input name="add-item" onclick="return validateQty()" class="button" type="button" tabindex="18" value="Add" style="width: 90; height: 22"/>
              </td>
              <td>
                <input name="reset" onclick="document.main.actionToDo.value = 'reset'" class="button" type="submit" tabindex="20" value="Reset Cart" style="width: 90"/>
              </td>
            </tr>
          </table>
        </form>
      </td>
    </tr>
  </xsl:template>

  <xsl:template match="Statement" mode="products">
    <!-- the current node is just one statement about the product; we need all statements about it -->
    <xsl:variable name="product-stmt" select="frdf:complete(Subject,frdf:any(),frdf:any())"/>
    <xsl:variable name="label" select="$product-stmt[Predicate='&rdfs;label']/Object"/>
    <xsl:variable name="units" select="$product-stmt[Predicate='&bbschema;units']/Object"/>
    <xsl:variable name="id" select="substring-after(Subject, '#')"/>
    <option value="{Subject}">
      <xsl:value-of select="$id"/>: <xsl:value-of select="$label"/> [<xsl:value-of select="$units"/>]
    </option>
  </xsl:template>

  <xsl:template name="current-order">
    <tr class="cellBlue">
      <td class="menucell" colspan="2" align="left"><div class="menu">Shopping Cart</div></td>
    </tr>
    <tr>
      <td colspan="2" valign="top">
        <table border="1" width="675" cellpadding="2" bgcolor="#FFFFFF" bordercolorlight="#C0C0C0" class="normal">
          <tr class="cellGray">
            <td class="th" align="center" width="80">No.</td>
            <td class="th" align="center" width="220">Product</td>
            <td class="th" align="center" width="100">Quantity</td>
            <td class="th" align="center" width="125">Unit Price</td>
            <td class="th" align="center" width="110">Total Price</td>
          </tr>
          <xsl:variable name='cur' select='fcore:session-data("CART")'/>
          <xsl:variable name="products-in-cart" select="$cur/bb:pending/bb:order[@cust-id = $fres:absolute-path]"/>
          <xsl:choose>
            <xsl:when test='$products-in-cart'>
              <xsl:variable name="currencySymbol" select="'$'"/>
              <xsl:for-each select='$products-in-cart'>
                <!-- from the RDF model, get the label, units, and price for the current product -->
                <xsl:variable name="query">
                    distribute(
                      @'<xsl:value-of select="@prod-id"/>',
                      '.-rdfs:label->*',
                      '.-bbschema:units->*',
                      '.-bbschema:price->*')
                </xsl:variable>
                <xsl:variable name="product-info" select="frdf:versa-query($query)"/>
                <xsl:variable name="product-name" select="$product-info/List/List/List[1]/*[1]"/>
                <xsl:variable name="units" select="$product-info/List/List/List[2]/*[1]"/>
                <xsl:variable name="unit-price" select="$product-info/List/List/List[3]/*[1]"/>
                <tr>
                  <td align="center">
                    <!-- Product Number -->
                    <xsl:value-of select='substring-after(@prod-id,"#")'/>
                  </td>
                  <td align="left">
                    <!-- Product Name-->
                    <xsl:value-of select='string($product-name)'/>
                  </td>
                  <td align="center">
                    <!-- Quantity -->
                    <xsl:value-of select='concat(@qty," ",$units)'/>
                  </td>
                  <td align="right">
                    <!-- Unit Price-->
                    <xsl:value-of select="$currencySymbol"/>
                    <xsl:value-of select="format-number($unit-price,'#,##0.00')"/>
                    <xsl:value-of select="'&nbsp;'"/>
                  </td>
                  <td align="right">
                    <!-- Total-->
                    <xsl:value-of select="$currencySymbol"/>
                    <xsl:value-of select="format-number($unit-price * @qty,'#,##0.00')"/>
                    <xsl:value-of select="'&nbsp;'"/>
                  </td>
                </tr>
              </xsl:for-each>
              <!-- grand total calculation -->
              <xsl:variable name="subtotals-rtf">
                <xsl:for-each select='$products-in-cart'>
                  <!-- from the RDF model, get the price for the current product -->
                  <xsl:variable name="product-info" select="frdf:complete(@prod-id,'&bbschema;price',frdf:any())"/>
                  <!-- frdf:complete returns a node-set (unordered) of 0 or more Statement elements like this one:
                    <Statement>
                      <Subject>/ftss/demos/buyerbase/products.rdf#al1156</Subject>
                      <Predicate>http://uche.ogbuji.net/example/buyerbase/schema#price</Predicate>
                      <Object>6</Object>
                    </Statement>
                  -->
                  <val>
                    <xsl:value-of select="$product-info/Object * @qty"/>
                  </val>
                </xsl:for-each>
              </xsl:variable>
              <xsl:variable name="grand-total" select="sum(exslt:node-set($subtotals-rtf)/val)"/>
              <tr>
                <td colspan="4" align="right" class="cellGray">
                  <b>Grand Total&nbsp;</b>
                </td>
                <td align="right" class="th">
                  <b>
                    <xsl:value-of select="$currencySymbol"/>
                    <xsl:value-of select="format-number($grand-total,'#,##0.00')"/>
                    <xsl:value-of select="'&nbsp;'"/>
                  </b>
                </td>
              </tr>
            </xsl:when>
            <xsl:otherwise>
              <tr>
                <td colspan='5' align='center'>
                  <b>
                    <font color='#000000'>No Items in Cart</font>
                  </b>
                </td>
              </tr>
            </xsl:otherwise>
          </xsl:choose>
        </table>
      </td>
    </tr>
  </xsl:template>

</xsl:stylesheet>
