<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    This stylesheet processes a set of change elements in order to
      1. produce a set of XUpdate instructions, and
      2. determine where to redirect to.

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:import href='decorated-xml.xslt'/>

  <xsl:include href='move-computer.xsl'/>
  <xsl:include href='reset-stack.xsl'/>
  <xsl:include href='count-hand.xsl'/>
  <xsl:include href='globals.xsl'/>


  <xsl:template name='process-next-step'>
    <xsl:param name='current-changes'/>
    <xsl:param name='options' select='0'/>

    <!--
      This template will recursively call the next step until the
      resulting RTF does not contain a CONTINUE element
    -->

    <xsl:variable name='next-changes'>
      <xsl:call-template name='next-step'>
        <xsl:with-param name='current-changes' select='$current-changes'/>
        <xsl:with-param name='options' select='$options'/>
      </xsl:call-template>
    </xsl:variable>

    <xsl:choose>
      <xsl:when test='exslt:node-set($next-changes)/Changes/CONTINUE'>
        <!-- Recurse -->
        <xsl:call-template name='process-next-step'>
          <xsl:with-param name='current-changes' select='$next-changes'/>
          <xsl:with-param name='options' select='exslt:node-set($next-changes)/Changes/CONTINUE/@options'/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>

        <xsl:choose>
          <xsl:when test='$debug="debug"'>
            <xsl:variable name='temp'>
              <Root>
                The Original Changes:
                <xsl:copy-of select='exslt:node-set($next-changes)/Changes'/>
                The changes translated to XUpdate
                <xsl:apply-templates select='exslt:node-set($next-changes)/Changes' mode='xupdate'/>
              </Root>
            </xsl:variable>
            <xsl:for-each select='exslt:node-set($temp)'>
              <xsl:call-template name='decorate-xml'/>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <fcore:x-update>
              <xsl:apply-templates select='exslt:node-set($next-changes)/Changes' mode='xupdate'/>
            </fcore:x-update>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <xsl:template name='next-step'>
    <xsl:param name='current-changes'/>
    <xsl:param name='options' select='0'/>
    <xsl:param name='test' select='0'/>  <!-- set to one to not do the actual redirect -->

    <!--
       This template will look at the current state of the gane,
       plus the current step of changes, and determine where the user should go next.
       Four possible end poins include
         * later-draw.xsl if we are drawing again
         * play-human.xsl if it next turn is needed
         * end-game.xsl if the game is over.
         * Show score if we are between hands

       This template should not be invoked inside of the xupdate RTF, it will copy it and create a new one

       options allow for special processing information
       1 or 2.  Just finished counting this players hand one, looking to count could be game over
       0.  Nothing special
       -1 or 2. Just finished counting the other players hand, look at the count game could be over (or go to show-score)
    -->

    <Changes>

      <!-- Copy the current change -->
      <xsl:for-each select='exslt:node-set($current-changes)/Changes/node()[local-name() != "CONTINUE"]'>
        <xsl:copy-of select='.'/>
      </xsl:for-each>

      <!-- Get the latest state changes -->
      <xsl:variable name='player-one-additional-score'>
        <xsl:choose>
          <xsl:when test='exslt:node-set($current-changes)/Changes/AwardPoints[@player = 1]'>
            <xsl:apply-templates select='exslt:node-set($current-changes)/Changes/AwardPoints[@player = 1][1]' mode='count-points'/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name='player-one-current-score' select='sum(key("players",1)/scores/score) + number($player-one-additional-score)'/>

      <xsl:variable name='player-two-additional-score'>
        <xsl:choose>
          <xsl:when test='exslt:node-set($current-changes)/Changes/AwardPoints[@player = 2]'>
            <xsl:apply-templates select='exslt:node-set($current-changes)/Changes/AwardPoints[@player = 2][1]' mode='count-points'/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name='player-two-current-score' select='sum(key("players",2)/scores/score) + number($player-two-additional-score)'/>

      <xsl:variable name='player-one-cards-played'>
        <xsl:choose>
          <xsl:when test='exslt:node-set($current-changes)/Changes/Play[@player = 1]'>
            <xsl:apply-templates select='exslt:node-set($current-changes)/Changes/Play[@player = 1][1]' mode='count-plays'/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name='player-two-cards-played'>
        <xsl:choose>
          <xsl:when test ='exslt:node-set($current-changes)/Changes/Play[@player = 2]'>
            <xsl:apply-templates select='exslt:node-set($current-changes)/Changes/Play[@player = 2][1]' mode='count-plays'/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name='new-count'>
        <xsl:choose>
          <xsl:when test ='exslt:node-set($current-changes)/Changes/ResetStack'>
            <xsl:value-of select='-1*$initial-count + sum(exslt:node-set($current-changes)/Changes/ResetStack/following-sibling::Play/Card/@point)'/>  <!-- Just used to offset initial count -->
          </xsl:when>
          <xsl:when test ='exslt:node-set($current-changes)/Changes/Play'>
            <xsl:value-of select='sum(exslt:node-set($current-changes)/Changes/Play/Card/@point)'/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name='cur-count' select='$initial-count + number($new-count)'/>

      <xsl:variable name='cur-player'>
        <xsl:choose>
          <xsl:when test ='exslt:node-set($current-changes)/Changes/ChangePlayer'>
            <xsl:value-of select='exslt:node-set($current-changes)/Changes/ChangePlayer[last()]/@player'/>
          </xsl:when>
          <xsl:otherwise><xsl:value-of select='$initial-player'/></xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name='cur-dealer'>
        <xsl:choose>
          <xsl:when test ='exslt:node-set($current-changes)/Changes/ChangeDealer'>
            <xsl:value-of select='exslt:node-set($current-changes)/Changes/ChangeDealer[last()]/@player'/>
          </xsl:when>
          <xsl:otherwise><xsl:value-of select='$initial-dealer'/></xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:variable name='player-one-go' select='((number(key("players",1)/in-go)
                                                   or count(exslt:node-set($current-changes)/Changes/SetGo[@player = 1])
                                                   ) and not(exslt:node-set($current-changes)/Changes/ResetStack)
                                                 ) or (count(key("players",1)/playing-cards/Card) - $player-one-cards-played = 0)'/>

      <xsl:variable name='player-two-go' select='((number(key("players",2)/in-go)
                                                  or count(exslt:node-set($current-changes)/Changes/SetGo[@player = 2])
                                                  ) and not(exslt:node-set($current-changes)/Changes/ResetStack)
                                                 ) or (count(key("players",2)/playing-cards/Card) - $player-two-cards-played = 0)'/>



      <!-- Print some of our state into the resulting document -->
      <xsl:if test='$debug="debug"'>
        <xsl:comment>
        player-one-additional-score: <xsl:value-of select='$player-one-additional-score'/>,
        player-two-additional-score: <xsl:value-of select='$player-two-additional-score'/>,
        player-one-current-score: <xsl:value-of select='$player-one-current-score'/>,
        player-two-current-score: <xsl:value-of select='$player-two-current-score'/>,
        player-one-cards-played: <xsl:value-of select='$player-one-cards-played'/>,
        player-two-cards-player: <xsl:value-of select='$player-two-cards-played'/>,
        new-count: <xsl:value-of select='$new-count'/>,
        cur-count: <xsl:value-of select='$cur-count'/>,
        cur-player: <xsl:value-of select='$cur-player'/>,
        cur-dealer: <xsl:value-of select='$cur-dealer'/>,
        player-one-go: <xsl:value-of select='boolean($player-one-go)'/>,
        player-two-go: <xsl:value-of select='boolean($player-two-go)'/>,
        </xsl:comment>
      </xsl:if>

      <!-- Now, our logic -->

      <xsl:choose>
        <!-- Look for game over first -->
        <xsl:when test='$player-one-current-score > 120'>
          <xsl:call-template name='log-message'>
            <xsl:with-param name='message' select='"WINNER!!"'/>
            <xsl:with-param name='player' select='1'/>
          </xsl:call-template>
          <xsl:if test='not($debug="debug")'>
            <fhttp:response-uri uri="{$fres:uri-path}?xslt=../end-game.xsl"/>
          </xsl:if>
        </xsl:when>
        <xsl:when test='$player-two-current-score > 120'>
          <xsl:call-template name='log-message'>
            <xsl:with-param name='message' select='"WINNER!!"'/>
            <xsl:with-param name='player' select='2'/>
          </xsl:call-template>
          <xsl:if test='not($debug="debug")'>
            <fhttp:response-uri uri="{$fres:uri-path}?xslt=../end-game.xsl"/>
          </xsl:if>
        </xsl:when>

        <xsl:when test='$options = 1 or $options = 2'>
          <!--
            first time through the count.  If we made it this far, then we are OK still (no end game)
            Count the other players (the dealers) hand.
          -->
          <xsl:call-template name='count-dealer'>
            <xsl:with-param name='cur-dealer' select='number($cur-dealer)'/>
          </xsl:call-template>

          <CONTINUE options='{-1 * number($cur-dealer)}'/>

        </xsl:when>
        <xsl:when test='$options = -1 or $options = -2'>
          <!--
            Just finished counting the dealer, show the score, this will evenutall get back to redealing
          -->
          <xsl:if test='not($debug="debug")'>
            <fhttp:response-uri uri="{$fres:uri-path}?xslt=../show-score.xsl"/>
          </xsl:if>
        </xsl:when>
        <!--
          Next, see if we need to redeal the cards, to initiate this, we count the current hand.
        -->
        <xsl:when test='count(/cribbage/game-info/all-played/Card) + number($player-one-cards-played) + number($player-two-cards-played) = 8'>

          <!--
            Award points for the last cards played, this is determined by the player of the last played tag
          -->
          <xsl:call-template name='award-points'>
            <xsl:with-param name='player' select='number(exslt:node-set($current-changes)/Changes/Play[last()]/@player)'/>
            <xsl:with-param name='amount' select='1'/>
            <xsl:with-param name='message' select='"Last Card for 1"'/>
          </xsl:call-template>

          <!-- Count the cards this will eventually come back in to show the score-->
          <xsl:call-template name='log-message'>
            <xsl:with-param name='message' select='"Last card has been played, your deal"'/>
            <xsl:with-param name='player' select='number($cur-dealer = 1) + 1'/>
          </xsl:call-template>
          <xsl:if test='$debug="debug"'>
            <xsl:comment>
              Changing state to count-non-dealer:
              Current All-played: <xsl:value-of select='count(/cribbage/game-info/all-played/Card)'/>
            </xsl:comment>
          </xsl:if>
          <xsl:call-template name='count-non-dealer'>
            <xsl:with-param name='cur-dealer' select='$cur-dealer'/>
          </xsl:call-template>
          <CONTINUE options='{number($cur-dealer = 1) + 1}'/>
        </xsl:when>

        <xsl:when test='number($cur-count) = 31'>
          <!-- Log what we are doing -->
          <xsl:call-template name='log-message'>
            <xsl:with-param name='message' select='"31 has been reached, restart playing stack"'/>
          </xsl:call-template>

          <!-- Reset the stack and swap players -->
          <xsl:call-template name='reset-stack'/>

          <CONTINUE options='0'/>
        </xsl:when>
        <xsl:when test='boolean($player-one-go) and boolean($player-two-go)'>
          <!-- Log what we are doing -->
          <xsl:if test='$debug="debug"'>
            <xsl:comment>
              Both players in GO, reset the stack
            </xsl:comment>
          </xsl:if>
          <!-- Give the points to the last GO -->
          <!--
            It is possible that there is no SetGo on the stack.  This is the case when the computer played a GO
            last turn, and the human went into go because they ran out of cards In which case set player to 2
          -->
          <xsl:variable name='go-player'>
            <xsl:choose>
              <xsl:when test='count(exslt:node-set($current-changes)/Changes/SetGo)'>
                <xsl:value-of select='number(exslt:node-set($current-changes)/Changes/SetGo[last()]/@player)'/>
              </xsl:when>
              <xsl:otherwise>
                2
              </xsl:otherwise>
            </xsl:choose>
          </xsl:variable>
          <xsl:call-template name='award-points'>
            <xsl:with-param name='player' select='number($go-player)'/>
            <xsl:with-param name='amount' select='1'/>
            <xsl:with-param name='message' select='"Go for 1"'/>
          </xsl:call-template>


          <xsl:call-template name='log-message'>
            <xsl:with-param name='message' select='"Both player go, restart playing stack"'/>
          </xsl:call-template>

          <!-- Reset the stack.  Players should have already been swapped and points awarded -->
          <xsl:call-template name='reset-stack'/>

          <CONTINUE options='0'/>
        </xsl:when>
        <xsl:when test='$cur-player = 2 and not(boolean($player-two-go))'>
          <xsl:call-template name='log-message'>
            <xsl:with-param name='message' select='"Your turn"'/>
            <xsl:with-param name='player' select='2'/>
          </xsl:call-template>
          <xsl:if test='not($debug="debug")'>
            <fhttp:response-uri uri="{$fres:uri-path}?xslt=../play-human.xsl"/>
          </xsl:if>
        </xsl:when>
        <xsl:when test='$cur-player = 1 or boolean($player-two-go)'>
          <xsl:if test='$debug="debug"'>
            <xsl:comment>
              cur-player is one, move computer
            </xsl:comment>
          </xsl:if>
          <xsl:call-template name='move-computer'>
            <xsl:with-param name='human-in-go' select='$player-two-go'/>
            <xsl:with-param name='cur-count' select='number($cur-count)'/>
            <xsl:with-param name='played'>
              <played>
                <xsl:choose>
                  <xsl:when test='not(exslt:node-set($current-changes)/Changes/ResetStack)'>
                    <xsl:copy-of select='/cribbage/game-info/cur-played/Card'/>
                    <xsl:copy-of select='exslt:node-set($current-changes)/Changes/Play/Card'/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:copy-of select='exslt:node-set($current-changes)/Changes/ResetStack/following-sibling::Play/Card'/>
                  </xsl:otherwise>
                </xsl:choose>
              </played>
            </xsl:with-param>
            <xsl:with-param name='discarded'>
              <discarded>
                <xsl:choose>
                  <xsl:when test='not(exslt:node-set($current-changes)/Changes/ResetStack)'>
                    <xsl:copy-of select='exslt:node-set($current-changes)/Changes/Discard/Card'/>
                  </xsl:when>
                  <xsl:otherwise>
                    <xsl:copy-of select='exslt:node-set($current-changes)/Changes/ResetStack/preceding-sibling::Play/Card'/>
                  </xsl:otherwise>
                </xsl:choose>
             </discarded>
            </xsl:with-param>
          </xsl:call-template>
          <CONTINUE options='0'/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test='$debug="debug"'>
            <xsl:comment>
              In an unknown place
            </xsl:comment>
          </xsl:if>
          <!--<fhttp:response-uri uri="{$fres:uri-path}?xslt=../../loritaire/decorated-xml.xslt"/>-->
        </xsl:otherwise>
      </xsl:choose>
    </Changes>

  </xsl:template>

  <xsl:template match='AwardPoints' mode='count-points'>
    <xsl:param name='other' select='0'/>
    <xsl:choose>
      <xsl:when test='following-sibling::AwardPoints[@player = current()/@player]'>
        <xsl:apply-templates select='following-sibling::AwardPoints[@player = current()/@player][1]' mode='count-points'>
          <xsl:with-param name='other' select='$other + number(@amount)'/>
        </xsl:apply-templates>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select='$other + number(@amount)'/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template match='Play' mode='count-plays'>
    <xsl:param name='other' select='0'/>
    <xsl:choose>
      <xsl:when test='following-sibling::Play[@player = current()/@player]'>
        <xsl:apply-templates select='following-sibling::Play[@player = current()/@player][1]' mode='count-plays'>
          <xsl:with-param name='other' select='$other + 1'/>
        </xsl:apply-templates>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select='$other + 1'/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!--
    This set of templates will change the internal change log into XUPdate
  -->
  <xsl:template match='Changes' mode='xupdate'>
    <xupdate:modifications version="1.0">
      <xsl:apply-templates select='*' mode='xupdate'/>

      <xsl:if test='not($debug="debug")'>

        <!-- Lastly, add in what we have done -->
        <xupdate:remove select='/cribbage/changes'/>
        <xupdate:append select='/cribbage'>
          <changes>
            <xsl:copy-of select='*|comment()'/>
          </changes>
        </xupdate:append>
      </xsl:if>
    </xupdate:modifications>
  </xsl:template>

  <xsl:template match='Discard' mode='xupdate'>
    <xupdate:append select='/cribbage/crib-info'>
      <xsl:copy-of select='Card'/></xupdate:append>
      <xupdate:remove select='/cribbage/player-info/player[@ID="{@player}"]/playing-cards/Card[@short-name = "{Card/@short-name}"]'/>
      <xupdate:remove select='/cribbage/player-info/player[@ID="{@player}"]/cards/Card[@short-name = "{Card/@short-name}"]'/>

  </xsl:template>

  <xsl:template match='AwardPoints' mode='xupdate'>
    <xupdate:append select='/cribbage/player-info/player[@ID = {number(@player)}]/scores'><score><xsl:value-of select='number(@amount)'/></score></xupdate:append>
  </xsl:template>


  <xsl:template match='Log' mode='xupdate'>
    <xupdate:append select='/cribbage/cur-log'>
      <log-entry>
        <xsl:choose>
          <xsl:when test='@player'>
            <!-- NOTE: We are in an RTF here so we cannot use the key, use the variable
                 -->

            <xsl:value-of select='concat(exslt:node-set($players)/players/player[position() = number(current()/@player)]/name,": ",string(.))'/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select='string(.)'/>
          </xsl:otherwise>
        </xsl:choose>
      </log-entry>
    </xupdate:append>
  </xsl:template>


  <xsl:template match='Play' mode='xupdate'>

    <xupdate:append select='/cribbage/player-info/player[@ID = {@player}]/played-cards'>
      <xsl:copy-of select='Card'/>
    </xupdate:append>

    <xupdate:append select='/cribbage/game-info/cur-played'>
      <xsl:copy-of select='Card'/>
    </xupdate:append>

    <xupdate:append select='/cribbage/game-info/all-played'>
      <xsl:copy-of select='Card'/>
    </xupdate:append>

    <xupdate:remove select='/cribbage/player-info/player[@ID = {@player}]/playing-cards/Card[@short-name = "{Card/@short-name}"]'/>

    <xupdate:append select='/cribbage/game-info/cur-count'>
      <score><xsl:value-of select='Card/@point'/></score>
    </xupdate:append>
  </xsl:template>


  <xsl:template match='ChangePlayer' mode='xupdate'>
    <xupdate:remove select='/cribbage/game-info/cur-player'/>
    <xupdate:append select='/cribbage/game-info'>
      <cur-player IDREF='{@player}'/>
    </xupdate:append>
  </xsl:template>

  <xsl:template match='SetGo' mode='xupdate'>
    <xupdate:update select='/cribbage/player-info/player[{@player}]/in-go'>1</xupdate:update>
  </xsl:template>

  <xsl:template match='ResetStack' mode='xupdate'>
    <!--
      reset the state of the game for a new stack (same hand) and redirect to the proper player
        1.  Reset current count
        2.  Reset go information
        3.  Reset players played cards
        4.  Reset the games played cards
    -->
    <xupdate:update select='/cribbage/game-info/cur-count'><score>0</score></xupdate:update>
    <xupdate:update select='/cribbage/player-info/player[@ID=1]/in-go'>0</xupdate:update>
    <xupdate:update select='/cribbage/player-info/player[@ID=2]/in-go'>0</xupdate:update>
    <xupdate:remove select='/cribbage/player-info/player[@ID = 1]/played-cards'/>
    <xupdate:append select='/cribbage/player-info/player[@ID = 1]'><played-cards/></xupdate:append>
    <xupdate:remove select='/cribbage/player-info/player[@ID = 2]/played-cards'/>
    <xupdate:append select='/cribbage/player-info/player[@ID = 2]'><played-cards/></xupdate:append>
    <xupdate:remove select='/cribbage/game-info/cur-played'/>
    <xupdate:append select='/cribbage/game-info'><cur-played/></xupdate:append>

  </xsl:template>


  <!--
    Some debugging templates
  -->
  <xsl:template match='Changes' mode='serialize'>
    **Start Change Set**
    <xsl:apply-templates mode='serialize' select='*|comment()'/>
    **End Change Set**
  </xsl:template>

  <xsl:template match='Log' mode='serialize'>
    <xsl:text>Log: </xsl:text>
    <xsl:value-of select='string(.)'/>
    <xsl:text> for </xsl:text>
    <xsl:value-of select='@player'/>,

  </xsl:template>

  <xsl:template match='Discard' mode='serialize'>
    <xsl:text>Discard: </xsl:text>
    <xsl:value-of select='Card/@formal-name'/>
    <xsl:text> for </xsl:text>
    <xsl:value-of select='@player'/>,

  </xsl:template>

  <xsl:template match='SetGo' mode='serialize'>
    <xsl:text>Go for: </xsl:text>
    <xsl:value-of select='@player'/>,

  </xsl:template>


  <xsl:template match='ChangePlayer' mode='serialize'>
    <xsl:text>Change Player to: </xsl:text>
    <xsl:value-of select='@player'/>,

  </xsl:template>

  <xsl:template match='Play' mode='serialize'>
    <xsl:text>Play: </xsl:text>
    <xsl:value-of select='Card/@formal-name'/>
    <xsl:text> for </xsl:text>
    <xsl:value-of select='@player'/>,

  </xsl:template>

  <xsl:template match='AwardPoints' mode='serialize'>
    <xsl:text>Awards: </xsl:text>
    <xsl:value-of select='@amount'/>
    <xsl:text> to </xsl:text>
    <xsl:value-of select='@player'/>,

  </xsl:template>

  <xsl:template match='comment()' mode='serialize'>
    <xsl:comment>
      !!!NESTED COMMENT START!!!
      <xsl:value-of select='.'/>
      !!NESTED COMMENT END!!
    </xsl:comment>

  </xsl:template>

  <xsl:template match='ResetStack' mode='serialize'>
    Reset Stack!!
  </xsl:template>

  <xsl:template match='*' mode='serialize'>
    <xsl:text>Unknown: </xsl:text>
    <xsl:value-of select='local-name()'/>
  </xsl:template>

</xsl:stylesheet>
