<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <!--
       This file is included by the calendar stylesheets. It
       should be edited to reflect the local holidays at
       your site.
  -->
  <xsl:output method="html"/>

  <xsl:template name="whichHoliday">
    <xsl:param name="date"/>
    <xsl:param name="day_of_week"/>
    <xsl:choose>
      <xsl:when test="$month=1 and $date=1">
        <xsl:text>New Year's Day</xsl:text>
      </xsl:when>
      <xsl:when test="$month=2 and $date=14">
        <xsl:text>Valentine's Day</xsl:text>
      </xsl:when>
      <xsl:when test="$month=3 and $date=17">
        <xsl:text>St. Patrick's Day</xsl:text>
      </xsl:when>
      <!-- Easter should be in here somewhere, but it needs
           a pretty complex algorithm -->
      <xsl:when test="$month=5 and $day_of_week=1
                      and $date &gt;= 25 and $date &lt;= 31">
        <xsl:text>Memorial Day</xsl:text>
      </xsl:when>
      <xsl:when test="$month=7 and $date=4">
        <xsl:text>Independence Day</xsl:text>
      </xsl:when>
      <xsl:when test="$month=9 and $day_of_week=1
                      and $date &gt;=1 and $date &lt;=7">
        <xsl:text>Labor Day</xsl:text>
      </xsl:when>
      <xsl:when test="$month=11 and $day_of_week=4
                      and $date &gt;=23 and $date &lt;= 29">
        <xsl:text>Thanksgiving</xsl:text>
      </xsl:when>
      <xsl:when test="$month=12 and $date=25">
        <xsl:text>Christmas</xsl:text>
      </xsl:when>
      <xsl:otherwise/>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>
