#Jeff Young has probs with 4RDF & extract container

from Ft.Lib.Uri import OsPathToUri
from Ft.Rdf import Util


INPUT = """\
<?xml version='1.0' encoding='UTF-8'?>
<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>
  <rdf:Seq>
    <rdf:li>b1</rdf:li>
    <rdf:li>b2</rdf:li>
    <rdf:li>b3</rdf:li>
  </rdf:Seq>
</rdf:RDF>
"""

def Test(tester):
    tester.startTest("Container Extraction")
    RDF_BASE = 'http://www.w3.org/1999/02/22-rdf-syntax-ns#'
    scope = OsPathToUri(__file__, attemptAbsolute=True)
    scope += '-INTERNAL-XML-STRING'
    m, db = Util.DeserializeFromString(INPUT, scope=scope)
    statements = m.complete(None, None, RDF_BASE + 'Seq')
    seqID = statements [0].subject
    seq = m.extractContainer(seqID)
    tester.compare([u'b1', u'b2', u'b3'], seq)
    tester.testDone()
    return

if __name__ == '__main__':
    Test()


