import os, tempfile

from Ft.Lib.CommandLine import CommandLineTestUtil
from Ft.Lib.Uri import OsPathToUri
from Ft.Server.Client import Core
from Server.Client.Core import test_helper

import test_prime

FIRST_DOCUMENT = '/' + test_prime.BASE_CONTAINER + '/doc1'
FIRST_DOCUMENT_ALIAS = '/' + test_prime.BASE_CONTAINER + '/doca1'
SECOND_DOCUMENT = '/' + test_prime.BASE_CONTAINER + '/doc2'


def val1(tester):
    repo = test_helper.GetRepo(tester)
    try:
        if not repo.hasResource(FIRST_DOCUMENT):
            return 0
        tester.compare(DOC2,repo.fetchResource(FIRST_DOCUMENT).getContent())
        return 1

    finally:
        repo.txRollback()

def val2(tester):
    repo = test_helper.GetRepo(tester)
    try:
        if not repo.hasResource(SECOND_DOCUMENT):
            return 0
        tester.compare(DOC2,repo.fetchResource(SECOND_DOCUMENT).getContent())
        return 1
    finally:
        repo.txRollback()

def val3(tester):
    repo = test_helper.GetRepo(tester)
    try:
        if not repo.hasResource(FIRST_DOCUMENT):
            return 0
        tester.compare(DOC3,repo.fetchResource(FIRST_DOCUMENT).getContent())
        return 1

    finally:
        repo.txRollback()


def Init(repo):
    if repo.hasResource(FIRST_DOCUMENT):
        repo.deleteResource(FIRST_DOCUMENT)
    if repo.hasResource(FIRST_DOCUMENT_ALIAS):
        repo.deleteResource(FIRST_DOCUMENT_ALIAS,traverseAliases = 0)

    rf = repo.createDocument(FIRST_DOCUMENT,DOC1)
    rf.addAlias(FIRST_DOCUMENT_ALIAS)

    if repo.hasResource(SECOND_DOCUMENT):
        repo.deleteResource(SECOND_DOCUMENT)
    repo.createDocument(SECOND_DOCUMENT,DOC1)



def Test(tester):


    test_prime.InitRepo(tester,Init,['4ss','update','document'])

    baseConfig = {'host':tester.test_data['ftrpc-host'],
                  'port':tester.test_data['ftrpc-port'],
                  'username':tester.test_data['userName'],
                  'password':tester.test_data['password'],
                  }

    tempFiles = []
    #Create a container from file
    fileName = tempfile.mktemp()
    f = open(fileName,'w')
    f.write(DOC2)
    f.close()
    fileNameUri = OsPathToUri(fileName)

    fileName2 = tempfile.mktemp()
    f = open(fileName2,'w')
    f.write(DOC3)
    f.close()
    fileNameUri2 = OsPathToUri(fileName2)

    tempFiles.append(fileName)
    tempFiles.append(fileName2)

    try:
        tr1 = CommandLineTestUtil.TestRun('Basic Update',
                                          baseConfig,
                                          [FIRST_DOCUMENT,fileNameUri],
                                          validationFunc = val1)

        #Update a raw file from stdin
        tr2 = CommandLineTestUtil.TestRun('STDIN Update',
                                          baseConfig,
                                          [SECOND_DOCUMENT,'-'],
                                          validationFunc = val2,
                                          input=DOC2)

        #Update a DOC that does not exist
        uri = test_prime.BASE_CONTAINER + '/foo'
        tr3 = CommandLineTestUtil.TestRun('Update Error',
                                          baseConfig,
                                          [uri,fileNameUri],
                                          expected_3%uri)

        tr4 = CommandLineTestUtil.TestRun('Alias Update',
                                          baseConfig,
                                          [FIRST_DOCUMENT_ALIAS,fileNameUri2],
                                          validationFunc = val3)


        t = CommandLineTestUtil.Test('4ss update document',[tr1,tr2,tr3,tr4])

        return t.test(tester)
    finally:
        for f in tempFiles:
            os.unlink(f)

import test_create_document
DOC1 = test_create_document.DOC1

DOC2 = """<newdummy/>"""

DOC3 = """<anotherdummy/>"""

expected_3 = "Path /%s is unknown\n"

