

from Ft.Server.Common import AclConstants, ResourceTypes
import test_helper

def init(tester):
    tester.startTest("Init")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    repo.createContainer("/test",1)
    repo.txCommit()
    tester.testDone()
    


def test_acl_interfaces(tester):

    tester.startTest("ACL Interfaces")
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource("/test")
    tester.compare(test.getParent().getAcl(AclConstants.READ_ACCESS),test.getAcl(AclConstants.READ_ACCESS))
    tester.compare(test.getParent().getAcl(AclConstants.WRITE_ACCESS),test.getAcl(AclConstants.WRITE_ACCESS))
    repo.txRollback()
    tester.testDone()


def test_change_owner(tester):

    tester.startTest("Change Ownership")

    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('test')
    owner = test.getOwner()
    tester.compare(repo.getUserName(),owner.getName())

    suGroup = repo.fetchUserOrGroupByName(AclConstants.SUPER_USER_GROUP_NAME)
    test.setOwner(suGroup)
    tester.compare(test.getOwner().getName(),AclConstants.SUPER_USER_GROUP_NAME)
    repo.txCommit()
    
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource('test')
    tester.compare(test.getOwner().getName(),AclConstants.SUPER_USER_GROUP_NAME)

    repo.txRollback()

    tester.testDone()


def Test(tester):

    init(tester)
    test_acl_interfaces(tester)
    test_change_owner(tester)




