

from Ft.Server.Server import FtServerServerException, Error

from Ft.Server.Common import ResourceTypes, Schema, ValidationInfo

import test_helper
from Rdf import RdfHelper

from Ft.Rdf import Statement

def test_create(tester):


    tester.startTest("Create RDF Document")

    #Create XML Document
    repo = test_helper.GetRepo(tester)
    test = repo.fetchResource("/test")

    doc = test.createDocument('doc1',RDF1,forcedType=ResourceTypes.ResourceType.RDF_DOCUMENT)

    res =  repo.getModel().complete(None,None,None,scope = doc.getAbsolutePathAsUri())
    actual = RdfHelper.make_tuple(res, '')
    tester.compare(expected1, actual, func=RdfHelper.compare_tuple)

    doc.getContent()

    res =  doc.complete()
    actual = RdfHelper.make_tuple(res, '')
    tester.compare(expected1, actual, func=RdfHelper.compare_tuple)

    repo.txCommit()
    tester.testDone()
    return




def test_modify(tester):

    tester.startTest("RDF Document Modification")

    repo = test_helper.GetRepo(tester)
    doc = repo.fetchResource("/test/doc1")

    repo.getModel().add([Statement.Statement('a',
                                             'b',
                                             'c',
                                             scope = '/test/doc1')
                       ])
    doc.getContent()
    

    
    res =  doc.complete()
    actual = RdfHelper.make_tuple(res, '')
    tester.compare(expected2, actual, func=RdfHelper.compare_tuple)

    repo.txCommit()
    
    tester.testDone()


def test_delete(tester):

    tester.startTest("Delete RDF Document")
    repo = test_helper.GetRepo(tester)
    doc = repo.fetchResource("/test/doc1")
    test = doc.getParent()
    doc.delete()

    res =  repo.getModel().complete(None,None,None,scope = '/test/doc1')
    tester.compare(0,len(res))
    repo.txCommit()
    tester.testDone()


def cleanup(tester):
    tester.startTest("Clean Up")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    repo.createContainer("/test",1)
    repo.txCommit()
    tester.testDone()




def Test(tester):

    cleanup(tester)
    test_create(tester)
    test_modify(tester)
    test_delete(tester)



RDF1 = """<rdf:RDF
    xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'
    xmlns:dc='http://purl.org/dc/elements/1.1/'>
    <rdf:Description about='http://www.dlib.org'>
      <dc:title>D-Lib Program - Research in Digital Libraries</dc:title>
      <dc:date>1995-01-07</dc:date>
      <dc:type>World Wide Web Home Page</dc:type>
    </rdf:Description>
  </rdf:RDF>
"""



import sys
if sys.hexversion < 0x2000000:
    addSlash = lambda x:x+'/'
else:
    addSlash = lambda x:x

expected1 = [(addSlash('http://www.dlib.org'),
              'http://purl.org/dc/elements/1.1/title',
              'D-Lib Program - Research in Digital Libraries',
              '',
              'ftss:///test/doc1'),
             (addSlash('http://www.dlib.org'),
              'http://purl.org/dc/elements/1.1/date',
              '1995-01-07',
              '',
              'ftss:///test/doc1'),
             (addSlash('http://www.dlib.org'),
              'http://purl.org/dc/elements/1.1/type',
              'World Wide Web Home Page',
              '',
              'ftss:///test/doc1'),
             ]

expected2 = expected1[:]
expected2.append(('a',
                  'b',
                  'c',
                  '',
                  'ftss:///test/doc1'))
