########################################################################
# $Header: /var/local/cvsroot/4Suite/test/Xml/Xslt/Exslt/test_math.py,v 1.2 2005/02/14 21:45:02 jkloth Exp $
"""Tests for EXSLT Math"""

from Xml.Xslt import test_harness

SOURCE = """<?xml version='1.0'?>
<x:items xmlns:x='http://uche.ogbuji.net/dummy'>
  <x:spam>2</x:spam>
  <x:eggs>12.0</x:eggs>
  <x:bread>100</x:bread>
</x:items>
"""

TESTS = []

# math:max()
def test_Max(tester):
    sty = """\
<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:math="http://exslt.org/math"
  xmlns:common="http://exslt.org/common"
  xmlns:x="http://uche.ogbuji.net/dummy"
  version="1.0"
>

  <xsl:output method="text"/>

  <x:spam>2</x:spam>
  <x:eggs>12.0</x:eggs>
  <x:bread>100</x:bread>

  <xsl:variable name='self' select='document("")/*'/>

  <xsl:template match="/">
    <xsl:variable name='result' select='math:max($self/x:*)'/>
    <xsl:value-of select='common:object-type($result)'/>
    <xsl:text> </xsl:text>
    <xsl:value-of select='$result'/>
  </xsl:template>

</xsl:stylesheet>
"""
    source = test_harness.FileInfo(string=SOURCE)
    sheet = test_harness.FileInfo(string=sty)
    expected = "number 100"
    test_harness.XsltTest(tester, source, [sheet], expected,
                          title='math:max()')
    return
TESTS.append(test_Max)


# math:min()
def test_Min(tester):
    sty = """\
<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:math="http://exslt.org/math"
  xmlns:common="http://exslt.org/common"
  xmlns:x="http://uche.ogbuji.net/dummy"
  version="1.0"
>

  <xsl:output method="text"/>

  <x:spam>2</x:spam>
  <x:eggs>12.0</x:eggs>
  <x:bread>100</x:bread>

  <xsl:variable name='self' select='document("")/*'/>

  <xsl:template match="/">
    <xsl:variable name='result' select='math:min($self/x:*)'/>
    <xsl:value-of select='common:object-type($result)'/>
    <xsl:text> </xsl:text>
    <xsl:value-of select='$result'/>
  </xsl:template>

</xsl:stylesheet>
"""
    source = test_harness.FileInfo(string=SOURCE)
    sheet = test_harness.FileInfo(string=sty)
    expected = "number 2"
    test_harness.XsltTest(tester, source, [sheet], expected,
                          title='math:min()')
    return
TESTS.append(test_Min)


# math:highest()
def test_Highest(tester):
    sty = """\
<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:math="http://exslt.org/math"
  xmlns:common="http://exslt.org/common"
  xmlns:x="http://uche.ogbuji.net/dummy"
  version="1.0"
>

  <xsl:output method="text"/>

  <x:spam>2</x:spam>
  <x:bread>100</x:bread>
  <x:eggs>12.0</x:eggs>

  <xsl:variable name='self' select='document("")/*'/>

  <xsl:template match="/">
    <xsl:variable name='result' select='math:highest($self/x:*)'/>
    <xsl:value-of select='name($result)'/>
  </xsl:template>

</xsl:stylesheet>
"""
    source = test_harness.FileInfo(string=SOURCE)
    sheet = test_harness.FileInfo(string=sty)
    expected = "x:bread"
    test_harness.XsltTest(tester, source, [sheet], expected,
                          title='math:highest()')
    return
TESTS.append(test_Highest)


# math:lowest()
def test_Lowest(tester):
    sty = """\
<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:math="http://exslt.org/math"
  xmlns:common="http://exslt.org/common"
  xmlns:x="http://uche.ogbuji.net/dummy"
  version="1.0"
>

  <xsl:output method="text"/>

  <x:spam>2</x:spam>
  <x:bread>100</x:bread>
  <x:eggs>12.0</x:eggs>

  <xsl:variable name='self' select='document("")/*'/>

  <xsl:template match="/">
    <xsl:variable name='result' select='math:lowest($self/x:*)'/>
    <xsl:value-of select='name($result)'/>
  </xsl:template>

</xsl:stylesheet>
"""
    source = test_harness.FileInfo(string=SOURCE)
    sheet = test_harness.FileInfo(string=sty)
    expected = "x:spam"
    test_harness.XsltTest(tester, source, [sheet], expected,
                          title='math:lowest()')
    return
TESTS.append(test_Lowest)

def NotTested(tester, title):
    tester.startTest(title)
    tester.warning('Not tested')
    tester.testDone()
    return

for title in ('abs',
              'acos',
              'asin',
              'atan',
              'atan2',
              'constant',
              'cos',
              'exp',
              'log',
              'power',
              'random',
              'sin',
              'sqrt',
              'tan'):
    TESTS.append(lambda tester, title='math:%s()'%title:
                 NotTested(tester, title))

def Test(tester):
    tester.startGroup('Math')
    for test in TESTS:
        test(tester)
    tester.groupDone()
    return
