#!/usr/bin/env python

"""Setup script for the adns module distribution."""

import os, sys
from distutils.core import setup
from distutils.extension import Extension

YES = 1
NO = 0

# You probably don't have to do anything past this point. If you
# do, please mail me the configuration for your platform. Don't
# forget to include the value of sys.platform and os.name.

include_dirs = []
library_dirs = []
runtime_library_dirs = []
extra_objects = []

if sys.platform == "linux-i386": # Red Hat
    libraries = ["adns"]
elif os.name == "posix": # most Linux/UNIX platforms
    libraries = ["adns"]
else:
    raise "UnknownPlatform", "sys.platform=%s, os.name=%s" % \
          (sys.platform, os.name)
    
long_description = \
"""adns-python is a Python module that interfaces to the adns asynchronous
resolver library.

http://www.gnu.org/software/adns/
"""
setup (# Distribution meta-data
        name = "adns-python",
        version = "1.0.0",
        description = "An interface to GNU adns",
        author = "Andy Dustman",
        author_email = "andy@dustman.net",
        url = "http://dustman.net/andy/python/adns-python",
	long_description=long_description,

        # Description of the modules and packages in the distribution

        py_modules = ["rblcheck", "hostmx", "ADNS"],

        ext_modules = [Extension(
                name='adns',
                sources=['adnsmodule.c'],
                include_dirs=include_dirs,
                library_dirs=library_dirs,
		runtime_library_dirs=runtime_library_dirs,
                libraries=libraries,
		extra_objects=extra_objects,
                )],
)
