/****************************************************************************
** $Id: rs_actionselect.h,v 1.5 2003/11/26 18:14:32 andrew Exp $
**
** Copyright (C) 2001-2003 RibbonSoft. All rights reserved.
**
** This file is part of the qcadlib Library project.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid qcadlib Professional Edition licenses may use 
** this file in accordance with the qcadlib Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.ribbonsoft.com for further details.
**
** Contact info@ribbonsoft.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef RS_ACTIONSELECT_H
#define RS_ACTIONSELECT_H

#include "rs_actioninterface.h"


/**
 * This action class can handle user events to select entities.
 *
 * @author Andrew Mustun
 */
class RS_ActionSelect : public RS_ActionInterface {
	Q_OBJECT
public:
    RS_ActionSelect(RS_EntityContainer& container,
                    RS_GraphicView& graphicView,
                    RS2::ActionType nextAction);
    ~RS_ActionSelect() {}

    void init(int status);
    //virtual void keyPressEvent(RS_KeyEvent* e);
    void mouseReleaseEvent(RS_MouseEvent* e);
    void updateToolBar();

private:
    RS2::ActionType nextAction;
};

#endif
