/* Copyright (C) 2003 Nikos Chantziaras.
 *
 * This file is part of the QTads program.  This program is free
 * software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

#include "config.h"

#include "qtadsstatusline.h"

#include <qlabel.h>


QTadsStatusLine::QTadsStatusLine( QWidget* parent, const char* name, WFlags f )
: QHBox(parent, name, f), fLeft(new QLabel(this, "statusline left")),
  fRight(new QLabel(this, "statusline right"))
{
	QHBox::setFocusPolicy(QWidget::NoFocus);
	QHBox::setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
	QHBox::setMargin(1);
	QHBox::setSpacing(10);
	this->fLeft->setIndent(5);
	this->fRight->setIndent(5);
	this->fLeft->setTextFormat(Qt::PlainText);
	this->fLeft->setAlignment(Qt::AlignLeft | Qt::WordBreak);
	this->fRight->setTextFormat(Qt::PlainText);
	this->fRight->setAlignment(Qt::AlignRight | Qt::WordBreak);
	QHBox::setStretchFactor(this->fLeft, 1);
	QHBox::setStretchFactor(this->fRight, 1);
}


void
QTadsStatusLine::leftText( const QString& text )
{
	this->fLeftText = text;
	this->fLeft->setText(text);
	// Make each part's size depend on the width of the text it's
	// holding.
	this->setStretchFactor(this->fLeft, QFontMetrics(this->fLeft->font()).width(text));
}


void
QTadsStatusLine::rightText( const QString& text )
{
	this->fRightText = text;
	this->fRight->setText(text);
	this->setStretchFactor(this->fRight, QFontMetrics(this->fRight->font()).width(text));
}
