/* A Bison parser, made by GNU Bison 1.875d.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003, 2004 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse spice_parse
#define yylex   spice_lex
#define yyerror spice_error
#define yylval  spice_lval
#define yychar  spice_char
#define yydebug spice_debug
#define yynerrs spice_nerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     TitleLine = 258,
     InvalidCharacter = 259,
     End = 260,
     Eol = 261,
     Identifier = 262,
     Digits = 263,
     Floats = 264,
     Nodes = 265,
     Options = 266,
     Function = 267,
     SUBCKT_Action = 268,
     ENDS_Action = 269,
     AC_Action = 270,
     OP_Action = 271,
     I_Source = 272,
     SAVE_Action = 273,
     RLC_Device = 274,
     L_Device = 275,
     K_Device = 276,
     IV_Source = 277,
     GE_Source = 278,
     FH_Source = 279,
     V_Source = 280,
     Diode_Device = 281,
     Bipolar_Device = 282,
     JFET_Device = 283,
     MOSFET_Device = 284,
     MESFET_Device = 285,
     MODEL_Action = 286,
     MODEL_Spec = 287,
     TRAN_Action = 288,
     PLOT_Action = 289,
     VoltFunc = 290,
     CurrFunc = 291,
     DC_Action = 292,
     PRINT_Action = 293,
     OPTIONS_Action = 294,
     WIDTH_Action = 295,
     NOISE_Action = 296,
     PZ_Action = 297,
     CurVol = 298,
     PoleZero = 299,
     ALL_Special = 300,
     X_Device = 301,
     O_Device = 302,
     ModelProps = 303,
     OFF_Special = 304,
     IC_Special = 305,
     SIM_Type = 306,
     TEMP_Special = 307,
     MOS_Special = 308,
     B_Source = 309,
     DISTO_Action = 310,
     INCLUDE_Action = 311,
     File = 312,
     BranchFunc = 313,
     NODESET_Action = 314,
     T_Device = 315,
     U_Device = 316,
     S_Device = 317,
     W_Device = 318,
     ON_Special = 319,
     TF_Action = 320,
     SENS_Action = 321,
     FOUR_Action = 322,
     OpFunc = 323
   };
#endif
#define TitleLine 258
#define InvalidCharacter 259
#define End 260
#define Eol 261
#define Identifier 262
#define Digits 263
#define Floats 264
#define Nodes 265
#define Options 266
#define Function 267
#define SUBCKT_Action 268
#define ENDS_Action 269
#define AC_Action 270
#define OP_Action 271
#define I_Source 272
#define SAVE_Action 273
#define RLC_Device 274
#define L_Device 275
#define K_Device 276
#define IV_Source 277
#define GE_Source 278
#define FH_Source 279
#define V_Source 280
#define Diode_Device 281
#define Bipolar_Device 282
#define JFET_Device 283
#define MOSFET_Device 284
#define MESFET_Device 285
#define MODEL_Action 286
#define MODEL_Spec 287
#define TRAN_Action 288
#define PLOT_Action 289
#define VoltFunc 290
#define CurrFunc 291
#define DC_Action 292
#define PRINT_Action 293
#define OPTIONS_Action 294
#define WIDTH_Action 295
#define NOISE_Action 296
#define PZ_Action 297
#define CurVol 298
#define PoleZero 299
#define ALL_Special 300
#define X_Device 301
#define O_Device 302
#define ModelProps 303
#define OFF_Special 304
#define IC_Special 305
#define SIM_Type 306
#define TEMP_Special 307
#define MOS_Special 308
#define B_Source 309
#define DISTO_Action 310
#define INCLUDE_Action 311
#define File 312
#define BranchFunc 313
#define NODESET_Action 314
#define T_Device 315
#define U_Device 316
#define S_Device 317
#define W_Device 318
#define ON_Special 319
#define TF_Action 320
#define SENS_Action 321
#define FOUR_Action 322
#define OpFunc 323




/* Copy the first part of user declarations.  */
#line 3 "parse_spice.y"

/*
 * parse_spice.y - parser for a Spice netlist
 *
 * Copyright (C) 2004 Stefan Jahn <stefan@lkcc.org>
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this package; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.  
 *
 * $Id: parse_spice.y,v 1.8 2004/11/24 19:16:05 raimi Exp $
 *
 */

#if HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define YYERROR_VERBOSE 42
#define YYDEBUG 1
#define YYMAXDEPTH 1000000

#include "check_spice.h"

// Converts the given string into upper case.
static char * spice_toupper (char * str) {
  for (unsigned int i = 0; i < strlen (str); i++) str[i] = toupper (str[i]);
  return str;
}

// Creates a device instance.
static struct definition_t * spice_create_device (char * instance) {
  struct definition_t * def = create_definition ();
  def->action = PROP_COMPONENT;
  def->instance = spice_toupper (instance);
  def->type = (char *) calloc (2, 1);
  def->type[0] = def->instance[0];
  def->line = spice_lineno;
  return def;
}

// Creates an action instance.
static struct definition_t * spice_create_action (char * type,
						  char * instance) {
  struct definition_t * def = create_definition ();
  def->action = PROP_ACTION;
  def->instance = spice_toupper (instance);
  def->type = spice_toupper (type);
  def->line = spice_lineno;
  return def;
}

// Create a string value.
static struct value_t * spice_create_str_value (char * value, int hint) {
  struct value_t * val = create_value ();
  val->ident = spice_toupper (value);
  val->hint |= hint;
  return val;
}

// Create a real value.
static struct value_t * spice_create_val_value (char * value, int hint) {
  struct value_t * val = create_value ();
  val->ident = value;
  val->value = strtod (value, NULL);
  val->hint |= hint;
  return val;
}

// Create a key/value pair.
static struct value_t * spice_create_par_value (char * key, char * value) {
  struct value_t * val = spice_create_str_value (key, HINT_PAIR);
  val->unit = value;
  return val;
}

// Append a string value to the definition.
static void spice_append_str_value (struct definition_t * def,
				    char * value, int hint) {
  struct value_t * val = spice_create_str_value (value, hint);
  def->values = netlist_append_values (def->values, val);
}

// Append a string value to the given values.
static struct value_t * spice_append_str_values (struct value_t * values,
						 char * value, int hint) {
  struct value_t * val = spice_create_str_value (value, hint);
  return netlist_append_values (values, val);
}

// Append a real value to the definition.
static void spice_append_val_value (struct definition_t * def,
				    char * value, int hint) {
  struct value_t * val = spice_create_val_value (value, hint);
  def->values = netlist_append_values (def->values, val);
}

// Append a real value to the given values.
static struct value_t * spice_append_val_values (struct value_t * values,
						 char * value, int hint) {
  struct value_t * val = spice_create_val_value (value, hint);
  return netlist_append_values (values, val);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 140 "parse_spice.y"
typedef union YYSTYPE {
  char * ident;
  char * str;
  double d;
  struct definition_t * definition;
  struct definition_t * subcircuit;
  struct value_t * value;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 352 "parse_spice.cpp"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 364 "parse_spice.cpp"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short int yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short int) + sizeof (YYSTYPE))			\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short int yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  109
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   665

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  69
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  37
/* YYNRULES -- Number of rules. */
#define YYNRULES  129
/* YYNRULES -- Number of states. */
#define YYNSTATES  319

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   323

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short int yyprhs[] =
{
       0,     0,     3,     6,    10,    12,    15,    16,    19,    21,
      23,    25,    32,    39,    45,    51,    58,    66,    73,    79,
      85,    92,    99,   107,   115,   122,   126,   131,   135,   138,
     142,   147,   152,   156,   161,   165,   169,   175,   184,   188,
     197,   205,   213,   221,   229,   238,   241,   244,   247,   250,
     253,   256,   260,   264,   268,   271,   275,   280,   286,   289,
     291,   294,   298,   300,   302,   305,   307,   309,   310,   313,
     317,   320,   324,   325,   327,   329,   330,   333,   336,   337,
     340,   344,   345,   348,   352,   353,   358,   359,   363,   366,
     369,   372,   373,   377,   380,   383,   386,   390,   391,   395,
     399,   402,   405,   408,   410,   412,   417,   419,   421,   423,
     425,   427,   428,   432,   433,   436,   437,   440,   443,   444,
     447,   451,   456,   457,   460,   462,   465,   469,   471,   473
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      70,     0,    -1,    71,     5,    -1,     3,    71,     5,    -1,
      71,    -1,     3,    71,    -1,    -1,    72,    71,    -1,   100,
      -1,    73,    -1,     6,    -1,    19,    94,    94,    93,    95,
       6,    -1,    19,    94,    94,    91,    95,     6,    -1,    21,
      20,    20,    93,     6,    -1,    22,    94,    94,    99,     6,
      -1,    22,    94,    94,    93,    99,     6,    -1,    23,    94,
      94,    94,    94,    93,     6,    -1,    24,    94,    94,    25,
      93,     6,    -1,    31,    91,    32,    86,     6,    -1,    26,
      94,    94,    91,    88,    -1,    28,    94,    94,    94,    91,
      89,    -1,    27,    94,    94,    94,    91,    89,    -1,    27,
      94,    94,    94,    94,    91,    89,    -1,    29,    94,    94,
      94,    94,    91,    90,    -1,    30,    94,    94,    94,    91,
      89,    -1,    33,    96,     6,    -1,    34,    51,    82,     6,
      -1,    15,    98,     6,    -1,    37,     6,    -1,    37,    92,
       6,    -1,    37,    92,    92,     6,    -1,    38,    51,    84,
       6,    -1,    38,    84,     6,    -1,    38,    51,    45,     6,
      -1,    39,    85,     6,    -1,    40,    95,     6,    -1,    41,
      79,    80,    98,     6,    -1,    42,    94,    94,    94,    94,
      43,    44,     6,    -1,    46,    97,     6,    -1,    62,    94,
      94,    94,    94,    91,    83,     6,    -1,    63,    94,    94,
      25,    91,    83,     6,    -1,    47,    94,    94,    94,    94,
      91,     6,    -1,    61,    94,    94,    94,    91,    95,     6,
      -1,    60,    94,    94,    94,    94,    95,     6,    -1,    60,
      94,    94,    94,    94,    95,    77,     6,    -1,    16,     6,
      -1,    18,     6,    -1,    66,     6,    -1,    65,     6,    -1,
      67,     6,    -1,    54,     6,    -1,    55,    98,     6,    -1,
      56,    57,     6,    -1,    59,    87,     6,    -1,    50,    93,
      -1,    50,    93,    93,    -1,    50,    93,    93,    93,    -1,
      50,    93,    93,    93,    93,    -1,    93,    93,    -1,    94,
      -1,    35,    94,    -1,    35,    94,    94,    -1,    17,    -1,
      25,    -1,    36,    25,    -1,    58,    -1,    68,    -1,    -1,
      79,    82,    -1,    79,    78,    82,    -1,    81,    82,    -1,
      81,    78,    82,    -1,    -1,    64,    -1,    49,    -1,    -1,
      79,    82,    -1,    81,    82,    -1,    -1,    11,    85,    -1,
       7,    93,    85,    -1,    -1,    48,    86,    -1,     7,    93,
      86,    -1,    -1,    35,    94,    93,    87,    -1,    -1,    52,
      93,    88,    -1,    93,    88,    -1,    49,    88,    -1,    74,
      88,    -1,    -1,    52,    93,    89,    -1,    93,    89,    -1,
      49,    89,    -1,    75,    89,    -1,    53,    93,    89,    -1,
      -1,    52,    93,    90,    -1,    53,    93,    90,    -1,    93,
      90,    -1,    49,    90,    -1,    76,    90,    -1,     7,    -1,
      32,    -1,    80,    93,    93,    93,    -1,     8,    -1,     9,
      -1,     8,    -1,    10,    -1,     7,    -1,    -1,     7,    93,
      95,    -1,    -1,    93,    96,    -1,    -1,    94,    97,    -1,
      12,    96,    -1,    -1,    98,    99,    -1,   101,   102,   104,
      -1,    13,   103,    97,     6,    -1,    -1,   105,   102,    -1,
       7,    -1,    14,     6,    -1,    14,   103,     6,    -1,    73,
      -1,   100,    -1,     6,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short int yyrline[] =
{
       0,   174,   174,   176,   179,   182,   188,   189,   193,   198,
     203,   207,   215,   223,   230,   237,   245,   254,   262,   269,
     276,   285,   294,   304,   314,   322,   327,   333,   338,   342,
     347,   352,   358,   363,   369,   374,   379,   386,   396,   402,
     412,   421,   430,   439,   448,   458,   462,   466,   470,   474,
     478,   482,   487,   495,   503,   511,   519,   529,   540,   548,
     554,   560,   570,   570,   573,   579,   585,   593,   594,   597,
     601,   604,   610,   611,   614,   619,   620,   623,   628,   629,
     633,   639,   640,   644,   650,   651,   660,   661,   665,   669,
     673,   678,   679,   683,   687,   691,   694,   700,   701,   705,
     709,   713,   717,   722,   722,   725,   735,   735,   737,   737,
     737,   739,   740,   746,   747,   753,   754,   761,   768,   769,
     775,   783,   789,   790,   801,   804,   805,   809,   813,   814
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "TitleLine", "InvalidCharacter", "End",
  "Eol", "Identifier", "Digits", "Floats", "Nodes", "Options", "Function",
  "SUBCKT_Action", "ENDS_Action", "AC_Action", "OP_Action", "I_Source",
  "SAVE_Action", "RLC_Device", "L_Device", "K_Device", "IV_Source",
  "GE_Source", "FH_Source", "V_Source", "Diode_Device", "Bipolar_Device",
  "JFET_Device", "MOSFET_Device", "MESFET_Device", "MODEL_Action",
  "MODEL_Spec", "TRAN_Action", "PLOT_Action", "VoltFunc", "CurrFunc",
  "DC_Action", "PRINT_Action", "OPTIONS_Action", "WIDTH_Action",
  "NOISE_Action", "PZ_Action", "CurVol", "PoleZero", "ALL_Special",
  "X_Device", "O_Device", "ModelProps", "OFF_Special", "IC_Special",
  "SIM_Type", "TEMP_Special", "MOS_Special", "B_Source", "DISTO_Action",
  "INCLUDE_Action", "File", "BranchFunc", "NODESET_Action", "T_Device",
  "U_Device", "S_Device", "W_Device", "ON_Special", "TF_Action",
  "SENS_Action", "FOUR_Action", "OpFunc", "$accept", "Input", "InputList",
  "InputLine", "DefinitionLine", "IC_Condition_1", "IC_Condition_2",
  "IC_Condition_3", "IC_Condition_4", "Output_Range", "VOLTAGE_Output",
  "IV_Reference", "CURRENT_Output", "PLOT_List", "SWITCH_State",
  "PRINT_List", "OPTIONS_List", "MODEL_List", "NODESET_List",
  "DEVICE_List_1", "DEVICE_List_2", "DEVICE_List_3", "MODEL_Ident",
  "DC_List", "Value", "Node", "PairList", "ValueList", "NodeList", "Expr",
  "ExprList", "Subcircuit", "BeginSub", "SubBody", "SubCkt_Ident",
  "EndSub", "SubBodyLine", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short int yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    69,    70,    70,    70,    70,    71,    71,    72,    72,
      72,    73,    73,    73,    73,    73,    73,    73,    73,    73,
      73,    73,    73,    73,    73,    73,    73,    73,    73,    73,
      73,    73,    73,    73,    73,    73,    73,    73,    73,    73,
      73,    73,    73,    73,    73,    73,    73,    73,    73,    73,
      73,    73,    73,    73,    74,    75,    76,    77,    78,    79,
      79,    79,    80,    80,    81,    81,    81,    82,    82,    82,
      82,    82,    83,    83,    83,    84,    84,    84,    85,    85,
      85,    86,    86,    86,    87,    87,    88,    88,    88,    88,
      88,    89,    89,    89,    89,    89,    89,    90,    90,    90,
      90,    90,    90,    91,    91,    92,    93,    93,    94,    94,
      94,    95,    95,    96,    96,    97,    97,    98,    99,    99,
     100,   101,   102,   102,   103,   104,   104,   105,   105,   105
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     2,     3,     1,     2,     0,     2,     1,     1,
       1,     6,     6,     5,     5,     6,     7,     6,     5,     5,
       6,     6,     7,     7,     6,     3,     4,     3,     2,     3,
       4,     4,     3,     4,     3,     3,     5,     8,     3,     8,
       7,     7,     7,     7,     8,     2,     2,     2,     2,     2,
       2,     3,     3,     3,     2,     3,     4,     5,     2,     1,
       2,     3,     1,     1,     2,     1,     1,     0,     2,     3,
       2,     3,     0,     1,     1,     0,     2,     2,     0,     2,
       3,     0,     2,     3,     0,     4,     0,     3,     2,     2,
       2,     0,     3,     2,     2,     2,     3,     0,     3,     3,
       2,     2,     2,     1,     1,     4,     1,     1,     1,     1,
       1,     0,     3,     0,     2,     0,     2,     2,     0,     2,
       3,     4,     0,     2,     1,     2,     3,     1,     1,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
       6,     6,    10,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   113,     0,
       0,    75,    78,   111,     0,     0,   115,     0,     0,     0,
       0,    84,     0,     0,     0,     0,     0,     0,     0,     0,
       4,     6,     9,     8,   122,     5,   124,   115,   113,     0,
      45,    46,   110,   108,   109,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   103,   104,     0,   106,   107,
     113,     0,    67,    28,    62,    63,     0,     0,     0,     0,
      75,    65,    66,    67,    67,     0,    59,     0,    78,     0,
       0,     0,     0,     0,   115,     0,     0,    50,     0,     0,
       0,     0,     0,     0,     0,     0,    48,    47,    49,     1,
       2,     7,   129,   127,   128,     0,   122,     3,     0,   117,
      27,     0,     0,   118,     0,     0,     0,     0,     0,     0,
       0,    81,   114,    25,    67,    67,     0,     0,    29,     0,
      60,    64,     0,     0,    76,    77,    32,    78,    79,    34,
     111,    35,     0,     0,   116,    38,     0,    51,    52,     0,
      53,     0,     0,     0,     0,     0,   120,   123,   121,   111,
     111,     0,   118,   118,     0,     0,     0,    86,     0,     0,
       0,     0,     0,    81,     0,   108,    67,    68,     0,    67,
      70,    26,     0,    30,    61,    33,    31,    80,   112,     0,
       0,     0,    84,     0,     0,     0,     0,   125,     0,     0,
       0,    13,     0,   119,    14,     0,     0,    86,     0,     0,
      86,    19,    86,   103,    91,     0,    91,     0,    91,    81,
      82,    18,    69,    58,    71,   105,    36,     0,     0,    85,
     111,   111,     0,    72,   126,    12,    11,    15,     0,    17,
      89,    54,    86,    90,    88,    91,     0,     0,     0,    91,
      21,    91,    91,    20,    97,    24,    83,     0,     0,     0,
       0,    72,    74,    73,     0,    16,    87,    94,     0,    91,
      91,    95,    93,    22,    97,     0,     0,     0,    97,    23,
      97,     0,    41,    43,     0,     0,    42,     0,    40,    55,
      92,    96,   101,     0,    97,    97,   102,   100,    37,     0,
      44,    39,     0,    98,    99,     0,    56,     0,    57
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short int yydefgoto[] =
{
      -1,    39,    40,    41,    42,   220,   259,   288,   295,   186,
     134,    76,   135,   136,   274,    85,    89,   184,   101,   221,
     260,   289,    67,    77,   261,    86,    91,    71,    95,   173,
     174,    43,    44,   115,    47,   166,   116
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -198
static const short int yypact[] =
{
     482,   540,  -198,    26,    23,    60,    72,   138,    76,   138,
     138,   138,   138,   138,   138,   138,   138,    11,    86,    -5,
     115,    29,    31,    99,    40,   138,   138,   138,   109,    23,
      90,   108,   138,   138,   138,   138,   149,   157,   159,   172,
     168,   540,  -198,  -198,   598,   171,  -198,   138,    86,   176,
    -198,  -198,  -198,  -198,  -198,   138,   165,   138,   138,   138,
     138,   138,   138,   138,   138,  -198,  -198,   154,  -198,  -198,
      86,   182,   126,  -198,  -198,  -198,    86,   162,   138,   164,
       9,  -198,  -198,   126,   126,   184,  -198,    86,    31,   185,
      86,   186,    93,   138,   138,   187,   138,  -198,   192,   197,
     138,   200,   138,   138,   138,   138,  -198,  -198,  -198,  -198,
    -198,  -198,  -198,  -198,  -198,   193,   598,  -198,   202,  -198,
    -198,    82,    86,    20,   138,   188,    11,   138,   138,   138,
     138,     3,  -198,  -198,    92,    92,   203,    86,  -198,   204,
     138,  -198,   205,   206,  -198,  -198,  -198,    31,  -198,  -198,
      99,  -198,    23,   138,  -198,  -198,   138,  -198,  -198,    86,
    -198,   138,   138,   138,   189,   116,  -198,  -198,  -198,    99,
      99,   209,    23,    23,   210,   138,    86,   117,   173,    11,
     138,    11,    86,     3,   211,   121,   126,  -198,    86,   126,
    -198,  -198,    86,  -198,  -198,  -198,  -198,  -198,  -198,   212,
     138,   138,   108,   138,    11,   138,    11,  -198,   213,   214,
     215,  -198,   216,  -198,  -198,    86,   217,   117,    86,    86,
     117,  -198,   117,    17,    32,    11,    32,    11,    32,     3,
    -198,  -198,  -198,  -198,  -198,  -198,  -198,   181,    11,  -198,
      99,    99,    11,    34,  -198,  -198,  -198,  -198,   219,  -198,
    -198,  -198,   117,  -198,  -198,    32,    86,    86,    86,    32,
    -198,    32,    32,  -198,   104,  -198,  -198,   183,   220,    21,
     222,    34,  -198,  -198,   223,  -198,  -198,  -198,    86,    32,
      32,  -198,  -198,  -198,   104,    86,    86,    86,   104,  -198,
     104,   224,  -198,  -198,    86,   225,  -198,   226,  -198,  -198,
    -198,  -198,  -198,    86,   104,   104,  -198,  -198,  -198,    86,
    -198,  -198,    86,  -198,  -198,    86,  -198,    86,  -198
};

/* YYPGOTO[NTERM-NUM].  */
static const short int yypgoto[] =
{
    -198,  -198,    33,  -198,   -40,  -198,  -198,  -198,  -198,    98,
     -12,   143,   -10,   -78,   -35,   161,   -74,  -170,    35,  -197,
     -84,  -153,  -118,   166,   -18,   291,  -148,   -17,   -32,    -3,
     -34,   -37,  -198,   128,    77,  -198,  -198
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -111
static const short int yytable[] =
{
      70,    49,   198,   169,   113,   144,   145,   114,   177,    83,
     182,    84,    92,   230,   148,   118,    52,    53,    65,    54,
     250,   209,   210,   253,  -110,   254,    98,   293,    68,    69,
      70,   119,    48,    46,    45,    48,    52,    53,    87,    54,
      68,    69,    88,    66,    78,    79,    72,    52,    53,  -110,
      54,   183,    70,   132,   142,   276,   187,   190,   137,   266,
     224,   226,   154,   228,    78,    79,    50,    81,    83,   147,
      84,   294,   150,   197,   111,    78,   113,    82,    51,   114,
      80,   255,   256,   272,   257,   258,   241,    81,   243,    65,
      68,    69,   269,   270,    68,    69,    56,    82,   273,    52,
     185,    69,    54,   170,   171,   172,    90,   262,   232,   264,
      74,   234,    68,    69,    66,    97,   188,   188,    75,   192,
     268,    73,   207,    46,   271,    68,    69,    78,    79,  -106,
    -106,   302,    74,    52,    53,   306,    54,   307,   212,   213,
      75,   202,   263,   100,   265,    52,    53,    99,    54,   199,
      81,   313,   314,   284,   285,   106,   286,   287,   216,   222,
      82,    78,    79,   107,   229,   108,   217,   218,   138,   219,
     233,   277,   109,   110,   235,   281,   117,   282,   283,    74,
     223,    53,   120,    54,    81,   122,   131,    75,   133,   141,
     146,   149,   151,   155,    82,   300,   301,   248,   157,   222,
     251,   252,   222,   158,   222,    66,   160,   165,   168,   191,
     193,   195,   196,   176,   206,   211,   214,   231,   236,   244,
     245,   246,   247,   249,   267,   275,   292,   291,   296,   298,
     308,   310,   311,   189,   222,   152,   297,   239,   278,   279,
     280,   143,   208,   139,   167,     0,   290,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     299,     0,     0,     0,     0,     0,   290,   303,   304,   305,
     290,     0,   290,     0,     0,     0,   309,     0,     0,     0,
       0,     0,     0,     0,     0,   312,   290,   290,     0,     0,
       0,   315,     0,     0,   316,     0,     0,   317,    55,   318,
      57,    58,    59,    60,    61,    62,    63,    64,     0,     0,
       0,     0,     0,     0,     0,     0,    93,    94,    96,     0,
       0,     0,     0,   102,   103,   104,   105,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    94,     0,
       0,     0,     0,     0,     0,     0,   121,     0,   123,   124,
     125,   126,   127,   128,   129,   130,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   140,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   153,    94,     0,   156,     0,     0,
       0,   159,     0,   161,   162,   163,   164,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   175,     0,     0,   178,   179,
     180,   181,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   194,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   200,     0,     0,   201,     0,     0,
       0,     0,   203,   204,   205,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   215,     0,     0,   225,
       0,   227,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     1,     0,     0,     2,     0,
       0,   237,   238,     0,   240,     3,   242,     4,     5,     0,
       6,     7,     0,     8,     9,    10,    11,     0,    12,    13,
      14,    15,    16,    17,     0,    18,    19,     0,     0,    20,
      21,    22,    23,    24,    25,     0,     0,     0,    26,    27,
       0,     0,     0,     0,     0,     0,    28,    29,    30,     0,
       0,    31,    32,    33,    34,    35,     2,    36,    37,    38,
       0,     0,     0,     3,     0,     4,     5,     0,     6,     7,
       0,     8,     9,    10,    11,     0,    12,    13,    14,    15,
      16,    17,     0,    18,    19,     0,     0,    20,    21,    22,
      23,    24,    25,     0,     0,     0,    26,    27,     0,     0,
       0,     0,     0,     0,    28,    29,    30,     0,     0,    31,
      32,    33,    34,    35,   112,    36,    37,    38,     0,     0,
       0,     3,     0,     4,     5,     0,     6,     7,     0,     8,
       9,    10,    11,     0,    12,    13,    14,    15,    16,    17,
       0,    18,    19,     0,     0,    20,    21,    22,    23,    24,
      25,     0,     0,     0,    26,    27,     0,     0,     0,     0,
       0,     0,    28,    29,    30,     0,     0,    31,    32,    33,
      34,    35,     0,    36,    37,    38
};

static const short int yycheck[] =
{
      18,     4,   150,   121,    44,    83,    84,    44,   126,    21,
       7,    21,    24,   183,    88,    47,     7,     8,     7,    10,
     217,   169,   170,   220,     7,   222,    29,     6,     8,     9,
      48,    48,    12,     7,     1,    12,     7,     8,     7,    10,
       8,     9,    11,    32,    35,    36,    51,     7,     8,    32,
      10,    48,    70,    70,    45,   252,   134,   135,    76,   229,
     178,   179,    94,   181,    35,    36,     6,    58,    80,    87,
      80,    50,    90,   147,    41,    35,   116,    68,     6,   116,
      51,    49,    50,    49,    52,    53,   204,    58,   206,     7,
       8,     9,   240,   241,     8,     9,    20,    68,    64,     7,
       8,     9,    10,   121,   122,   123,     7,   225,   186,   227,
      17,   189,     8,     9,    32,     6,   134,   135,    25,   137,
     238,     6,     6,     7,   242,     8,     9,    35,    36,     8,
       9,   284,    17,     7,     8,   288,    10,   290,   172,   173,
      25,   159,   226,    35,   228,     7,     8,    57,    10,   152,
      58,   304,   305,    49,    50,     6,    52,    53,   176,   177,
      68,    35,    36,     6,   182,     6,    49,    50,     6,    52,
     188,   255,     0,     5,   192,   259,     5,   261,   262,    17,
       7,     8,     6,    10,    58,    20,    32,    25,     6,    25,
       6,     6,     6,     6,    68,   279,   280,   215,     6,   217,
     218,   219,   220,     6,   222,    32,     6,    14,     6,     6,
       6,     6,     6,    25,    25,     6,     6,     6,     6,     6,
       6,     6,     6,     6,    43,     6,     6,    44,     6,     6,
       6,     6,     6,   135,   252,    92,   271,   202,   256,   257,
     258,    80,   165,    77,   116,    -1,   264,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     278,    -1,    -1,    -1,    -1,    -1,   284,   285,   286,   287,
     288,    -1,   290,    -1,    -1,    -1,   294,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   303,   304,   305,    -1,    -1,
      -1,   309,    -1,    -1,   312,    -1,    -1,   315,     7,   317,
       9,    10,    11,    12,    13,    14,    15,    16,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    25,    26,    27,    -1,
      -1,    -1,    -1,    32,    33,    34,    35,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    47,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    55,    -1,    57,    58,
      59,    60,    61,    62,    63,    64,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    78,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    93,    94,    -1,    96,    -1,    -1,
      -1,   100,    -1,   102,   103,   104,   105,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,   124,    -1,    -1,   127,   128,
     129,   130,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,   140,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,   153,    -1,    -1,   156,    -1,    -1,
      -1,    -1,   161,   162,   163,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,   175,    -1,    -1,   178,
      -1,   180,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    -1,    -1,     6,    -1,
      -1,   200,   201,    -1,   203,    13,   205,    15,    16,    -1,
      18,    19,    -1,    21,    22,    23,    24,    -1,    26,    27,
      28,    29,    30,    31,    -1,    33,    34,    -1,    -1,    37,
      38,    39,    40,    41,    42,    -1,    -1,    -1,    46,    47,
      -1,    -1,    -1,    -1,    -1,    -1,    54,    55,    56,    -1,
      -1,    59,    60,    61,    62,    63,     6,    65,    66,    67,
      -1,    -1,    -1,    13,    -1,    15,    16,    -1,    18,    19,
      -1,    21,    22,    23,    24,    -1,    26,    27,    28,    29,
      30,    31,    -1,    33,    34,    -1,    -1,    37,    38,    39,
      40,    41,    42,    -1,    -1,    -1,    46,    47,    -1,    -1,
      -1,    -1,    -1,    -1,    54,    55,    56,    -1,    -1,    59,
      60,    61,    62,    63,     6,    65,    66,    67,    -1,    -1,
      -1,    13,    -1,    15,    16,    -1,    18,    19,    -1,    21,
      22,    23,    24,    -1,    26,    27,    28,    29,    30,    31,
      -1,    33,    34,    -1,    -1,    37,    38,    39,    40,    41,
      42,    -1,    -1,    -1,    46,    47,    -1,    -1,    -1,    -1,
      -1,    -1,    54,    55,    56,    -1,    -1,    59,    60,    61,
      62,    63,    -1,    65,    66,    67
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,     3,     6,    13,    15,    16,    18,    19,    21,    22,
      23,    24,    26,    27,    28,    29,    30,    31,    33,    34,
      37,    38,    39,    40,    41,    42,    46,    47,    54,    55,
      56,    59,    60,    61,    62,    63,    65,    66,    67,    70,
      71,    72,    73,   100,   101,    71,     7,   103,    12,    98,
       6,     6,     7,     8,    10,    94,    20,    94,    94,    94,
      94,    94,    94,    94,    94,     7,    32,    91,     8,     9,
      93,    96,    51,     6,    17,    25,    80,    92,    35,    36,
      51,    58,    68,    79,    81,    84,    94,     7,    11,    85,
       7,    95,    79,    94,    94,    97,    94,     6,    98,    57,
      35,    87,    94,    94,    94,    94,     6,     6,     6,     0,
       5,    71,     6,    73,   100,   102,   105,     5,    97,    96,
       6,    94,    20,    94,    94,    94,    94,    94,    94,    94,
      94,    32,    96,     6,    79,    81,    82,    93,     6,    92,
      94,    25,    45,    84,    82,    82,     6,    93,    85,     6,
      93,     6,    80,    94,    97,     6,    94,     6,     6,    94,
       6,    94,    94,    94,    94,    14,   104,   102,     6,    91,
      93,    93,    93,    98,    99,    94,    25,    91,    94,    94,
      94,    94,     7,    48,    86,     8,    78,    82,    93,    78,
      82,     6,    93,     6,    94,     6,     6,    85,    95,    98,
      94,    94,    93,    94,    94,    94,    25,     6,   103,    95,
      95,     6,    99,    99,     6,    94,    93,    49,    50,    52,
      74,    88,    93,     7,    91,    94,    91,    94,    91,    93,
      86,     6,    82,    93,    82,    93,     6,    94,    94,    87,
      94,    91,    94,    91,     6,     6,     6,     6,    93,     6,
      88,    93,    93,    88,    88,    49,    50,    52,    53,    75,
      89,    93,    91,    89,    91,    89,    86,    43,    91,    95,
      95,    91,    49,    64,    83,     6,    88,    89,    93,    93,
      93,    89,    89,    89,    49,    50,    52,    53,    76,    90,
      93,    44,     6,     6,    50,    77,     6,    83,     6,    93,
      89,    89,    90,    93,    93,    93,    90,    90,     6,    93,
       6,     6,    93,    90,    90,    93,    93,    93,    93
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short int *bottom, short int *top)
#else
static void
yy_stack_print (bottom, top)
    short int *bottom;
    short int *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short int yyssa[YYINITDEPTH];
  short int *yyss = yyssa;
  register short int *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;


  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short int *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short int *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 174 "parse_spice.y"
    {
  }
    break;

  case 3:
#line 176 "parse_spice.y"
    {
    spice_title = yyvsp[-2].str;
  }
    break;

  case 4:
#line 179 "parse_spice.y"
    {
    fprintf (stderr, "spice notice, no .END directive found, continuing\n");
  }
    break;

  case 5:
#line 182 "parse_spice.y"
    {
    spice_title = yyvsp[-1].str;
    fprintf (stderr, "spice notice, no .END directive found, continuing\n");
  }
    break;

  case 8:
#line 193 "parse_spice.y"
    {
    /* chain definition root */
    yyvsp[0].definition->next = definition_root;
    definition_root = yyvsp[0].definition;
  }
    break;

  case 9:
#line 198 "parse_spice.y"
    {
    /* chain definition root */
    yyvsp[0].definition->next = definition_root;
    definition_root = yyvsp[0].definition;
  }
    break;

  case 10:
#line 203 "parse_spice.y"
    { /* nothing to do here */ }
    break;

  case 11:
#line 207 "parse_spice.y"
    {
    /* R, L and C definitions */
    yyval.definition = spice_create_device (yyvsp[-5].ident);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_val_value (yyval.definition, yyvsp[-2].ident, HINT_NUMBER);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 12:
#line 215 "parse_spice.y"
    {
    /* R, L and C definitions specified by a Model */
    yyval.definition = spice_create_device (yyvsp[-5].ident);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_val_value (yyval.definition, yyvsp[-2].ident, HINT_NUMBER);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 13:
#line 223 "parse_spice.y"
    {
    /* Mutual inductors */
    yyval.definition = spice_create_device (yyvsp[-4].ident);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NAME);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME);
    spice_append_val_value (yyval.definition, yyvsp[-1].ident, HINT_NUMBER);
  }
    break;

  case 14:
#line 230 "parse_spice.y"
    {
    /* independent current/voltage sources */
    yyval.definition = spice_create_device (yyvsp[-4].ident);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NODE);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 15:
#line 237 "parse_spice.y"
    {
    /* independent current/voltage sources given the value */
    yyval.definition = spice_create_device (yyvsp[-5].ident);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_val_value (yyval.definition, yyvsp[-2].ident, HINT_NUMBER);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 16:
#line 245 "parse_spice.y"
    {
    /* voltage controlled sources */
    yyval.definition = spice_create_device (yyvsp[-6].ident);
    spice_append_str_value (yyval.definition, yyvsp[-5].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NODE);
    spice_append_val_value (yyval.definition, yyvsp[-1].ident, HINT_NUMBER);
  }
    break;

  case 17:
#line 254 "parse_spice.y"
    {
    /* voltage controlled sources */
    yyval.definition = spice_create_device (yyvsp[-5].ident);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME);
    spice_append_val_value (yyval.definition, yyvsp[-1].ident, HINT_NUMBER);
  }
    break;

  case 18:
#line 262 "parse_spice.y"
    {
    /* device specification */
    yyval.definition = spice_create_action (yyvsp[-4].ident, yyvsp[-3].ident);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME | HINT_MSTART);
    spice_add_last_hint (yyvsp[-1].value, HINT_MSTOP);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 19:
#line 269 "parse_spice.y"
    {
    /* diode */
    yyval.definition = spice_create_device (yyvsp[-4].ident);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-1].ident, HINT_NAME);
  }
    break;

  case 20:
#line 276 "parse_spice.y"
    {
    /* JFET */
    yyval.definition = spice_create_device (yyvsp[-5].ident);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-1].ident, HINT_NAME);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[0].value);
  }
    break;

  case 21:
#line 285 "parse_spice.y"
    {
    /* 3 node BJT */
    yyval.definition = spice_create_device (yyvsp[-5].ident);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-1].ident, HINT_NAME);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[0].value);
  }
    break;

  case 22:
#line 294 "parse_spice.y"
    {
    /* 4 node BJT */
    yyval.definition = spice_create_device (yyvsp[-6].ident);
    spice_append_str_value (yyval.definition, yyvsp[-5].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-1].ident, HINT_NAME);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[0].value);
  }
    break;

  case 23:
#line 304 "parse_spice.y"
    {
    /* MOS */
    yyval.definition = spice_create_device (yyvsp[-6].ident);
    spice_append_str_value (yyval.definition, yyvsp[-5].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-1].ident, HINT_NAME);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[0].value);
  }
    break;

  case 24:
#line 314 "parse_spice.y"
    {
    /* MES */
    yyval.definition = spice_create_device (yyvsp[-5].ident);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-1].ident, HINT_NAME);
  }
    break;

  case 25:
#line 322 "parse_spice.y"
    {
    /* transient analysis */
    yyval.definition = spice_create_action (yyvsp[-2].ident, strdup (yyvsp[-2].ident));
    yyval.definition->values = yyvsp[-1].value;
  }
    break;

  case 26:
#line 327 "parse_spice.y"
    {
    /* plotting */
    yyval.definition = spice_create_action (yyvsp[-3].ident, strdup (yyvsp[-3].ident));
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 27:
#line 333 "parse_spice.y"
    {
    /* AC analysis */
    yyval.definition = spice_create_action (yyvsp[-2].ident, strdup (yyvsp[-2].ident));
    yyval.definition->values = yyvsp[-1].value;
  }
    break;

  case 28:
#line 338 "parse_spice.y"
    {
    /* single DC analysis */
    yyval.definition = spice_create_action (yyvsp[-1].ident, strdup (yyvsp[-1].ident));
  }
    break;

  case 29:
#line 342 "parse_spice.y"
    {
    /* DC analysis first order */
    yyval.definition = spice_create_action (yyvsp[-2].ident, strdup (yyvsp[-2].ident));
    yyval.definition->values = yyvsp[-1].value;
  }
    break;

  case 30:
#line 347 "parse_spice.y"
    {
    /* DC analysis second order */
    yyval.definition = spice_create_action (yyvsp[-3].ident, strdup (yyvsp[-3].ident));
    yyval.definition->values = netlist_append_values (yyvsp[-2].value, yyvsp[-1].value);
  }
    break;

  case 31:
#line 352 "parse_spice.y"
    {
    /* printing specifying the analysis type */
    yyval.definition = spice_create_action (yyvsp[-3].ident, strdup (yyvsp[-3].ident));
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 32:
#line 358 "parse_spice.y"
    {
    /* printing */
    yyval.definition = spice_create_action (yyvsp[-2].ident, strdup (yyvsp[-2].ident));
    yyval.definition->values = yyvsp[-1].value;
  }
    break;

  case 33:
#line 363 "parse_spice.y"
    {
    /* printing */
    yyval.definition = spice_create_action (yyvsp[-3].ident, strdup (yyvsp[-3].ident));
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME);
    spice_append_str_value (yyval.definition, yyvsp[-1].ident, HINT_NAME);
  }
    break;

  case 34:
#line 369 "parse_spice.y"
    {
    /* general analysis options */
    yyval.definition = spice_create_action (yyvsp[-2].ident, strdup (yyvsp[-2].ident));
    yyval.definition->values = yyvsp[-1].value;
  }
    break;

  case 35:
#line 374 "parse_spice.y"
    {
    /* TODO: default width of ??? */
    yyval.definition = spice_create_action (yyvsp[-2].ident, strdup (yyvsp[-2].ident));
    yyval.definition->values = yyvsp[-1].value;
  }
    break;

  case 36:
#line 379 "parse_spice.y"
    {
    /* noise analysis */
    yyval.definition = spice_create_action (yyvsp[-4].ident, strdup (yyvsp[-4].ident));
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-3].value);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 37:
#line 386 "parse_spice.y"
    {
    /* pole-zero analysis */
    yyval.definition = spice_create_action (yyvsp[-7].ident, strdup (yyvsp[-7].ident));
    spice_append_str_value (yyval.definition, yyvsp[-6].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-5].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME);
    spice_append_str_value (yyval.definition, yyvsp[-1].ident, HINT_NAME);
  }
    break;

  case 38:
#line 396 "parse_spice.y"
    {
    /* subcircuit call */
    yyval.definition = spice_create_device (yyvsp[-2].ident);
    spice_set_last_hint (yyvsp[-1].value, HINT_NAME);
    yyval.definition->values = yyvsp[-1].value;
  }
    break;

  case 39:
#line 402 "parse_spice.y"
    {
    /* voltage controlled switch */
    yyval.definition = spice_create_device (yyvsp[-7].ident);
    spice_append_str_value (yyval.definition, yyvsp[-6].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-5].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 40:
#line 412 "parse_spice.y"
    {
    /* current controlled switch */
    yyval.definition = spice_create_device (yyvsp[-6].ident);
    spice_append_str_value (yyval.definition, yyvsp[-5].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NAME);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 41:
#line 421 "parse_spice.y"
    {
    /* lossy transline */
    yyval.definition = spice_create_device (yyvsp[-6].ident);
    spice_append_str_value (yyval.definition, yyvsp[-5].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-1].ident, HINT_NAME);
  }
    break;

  case 42:
#line 430 "parse_spice.y"
    {
    /* distributed lossy transline */
    yyval.definition = spice_create_device (yyvsp[-6].ident);
    spice_append_str_value (yyval.definition, yyvsp[-5].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NAME);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 43:
#line 439 "parse_spice.y"
    {
    /* lossless transline */
    yyval.definition = spice_create_device (yyvsp[-6].ident);
    spice_append_str_value (yyval.definition, yyvsp[-5].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-2].ident, HINT_NODE);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 44:
#line 448 "parse_spice.y"
    {
    /* lossless transline and initial condition */
    yyval.definition = spice_create_device (yyvsp[-7].ident);
    spice_append_str_value (yyval.definition, yyvsp[-6].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-5].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-4].ident, HINT_NODE);
    spice_append_str_value (yyval.definition, yyvsp[-3].ident, HINT_NODE);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-2].value);
    yyval.definition->values = netlist_append_values (yyval.definition->values, yyvsp[-1].value);
  }
    break;

  case 45:
#line 458 "parse_spice.y"
    {
    /* operating point analysis */
    yyval.definition = spice_create_action (yyvsp[-1].ident, strdup (yyvsp[-1].ident));
  }
    break;

  case 46:
#line 462 "parse_spice.y"
    {
    /* saving action */
    yyval.definition = spice_create_action (yyvsp[-1].ident, strdup (yyvsp[-1].ident));
  }
    break;

  case 47:
#line 466 "parse_spice.y"
    {
    /* sensitivity analysis */
    yyval.definition = spice_create_action (yyvsp[-1].ident, strdup (yyvsp[-1].ident));
  }
    break;

  case 48:
#line 470 "parse_spice.y"
    {
    /* transfer function analysis */
    yyval.definition = spice_create_action (yyvsp[-1].ident, strdup (yyvsp[-1].ident));
  }
    break;

  case 49:
#line 474 "parse_spice.y"
    {
    /* fourier analysis */
    yyval.definition = spice_create_action (yyvsp[-1].ident, strdup (yyvsp[-1].ident));
  }
    break;

  case 50:
#line 478 "parse_spice.y"
    {
    /* non-linear dependent sources */
    yyval.definition = spice_create_device (yyvsp[-1].ident);
  }
    break;

  case 51:
#line 482 "parse_spice.y"
    {
    /* distortion analysis */
    yyval.definition = spice_create_action (yyvsp[-2].ident, strdup (yyvsp[-2].ident));
    yyval.definition->values = yyvsp[-1].value;
  }
    break;

  case 52:
#line 487 "parse_spice.y"
    {
    /* file include */
    yyval.definition = spice_create_action (yyvsp[-2].ident, strdup (yyvsp[-2].ident));
    struct value_t * file = create_value ();
    file->ident = yyvsp[-1].ident;
    file->hint = HINT_NAME;
    yyval.definition->values = file;
  }
    break;

  case 53:
#line 495 "parse_spice.y"
    {
    /* nodeset functionality */
    yyval.definition = spice_create_action (yyvsp[-2].ident, strdup (yyvsp[-2].ident));
    yyval.definition->values = yyvsp[-1].value;
  }
    break;

  case 54:
#line 503 "parse_spice.y"
    {
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-1].ident, HINT_NAME);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[0].ident, HINT_NUMBER);
  }
    break;

  case 55:
#line 511 "parse_spice.y"
    {
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-2].ident, HINT_NAME);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[-1].ident, HINT_NUMBER);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[0].ident, HINT_NUMBER);
  }
    break;

  case 56:
#line 519 "parse_spice.y"
    {
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-3].ident, HINT_NAME);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[-2].ident, HINT_NUMBER);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[-1].ident, HINT_NUMBER);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[0].ident, HINT_NUMBER);
  }
    break;

  case 57:
#line 529 "parse_spice.y"
    {
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-4].ident, HINT_NAME);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[-3].ident, HINT_NUMBER);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[-2].ident, HINT_NUMBER);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[-1].ident, HINT_NUMBER);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[0].ident, HINT_NUMBER);
  }
    break;

  case 58:
#line 540 "parse_spice.y"
    { /* range specification during plotting */
    yyval.value = NULL;
    yyval.value = spice_append_val_values (yyval.value, yyvsp[-1].ident, HINT_NUMBER);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[0].ident, HINT_NUMBER);
  }
    break;

  case 59:
#line 548 "parse_spice.y"
    {
    /* print/plot specification of node voltage */
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, strdup ("V"), HINT_NAME | HINT_MSTART);
    yyval.value = spice_append_str_values (yyval.value, yyvsp[0].ident, HINT_NODE | HINT_MSTOP);
  }
    break;

  case 60:
#line 554 "parse_spice.y"
    {
    /* print/plot specification of node voltage */
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-1].ident, HINT_NAME | HINT_MSTART);
    yyval.value = spice_append_str_values (yyval.value, yyvsp[0].ident, HINT_NODE | HINT_MSTOP);
  }
    break;

  case 61:
#line 560 "parse_spice.y"
    {
    /* print/plot specification of differential node voltages */
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-2].ident, HINT_NAME | HINT_MSTART);
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-1].ident, HINT_NODE);
    yyval.value = spice_append_str_values (yyval.value, yyvsp[0].ident, HINT_NODE | HINT_MSTOP);    
  }
    break;

  case 64:
#line 573 "parse_spice.y"
    {
    /* print/plot specification of branch current */
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-1].ident, HINT_NAME | HINT_MSTART);
    yyval.value = spice_append_str_values (yyval.value, yyvsp[0].ident, HINT_NAME | HINT_MSTOP);
  }
    break;

  case 65:
#line 579 "parse_spice.y"
    {
    /* print/plot specification of branch current */
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, strdup ("I"), HINT_NAME | HINT_MSTART);
    yyval.value = spice_append_str_values (yyval.value, yyvsp[0].ident, HINT_NAME | HINT_MSTOP);
  }
    break;

  case 66:
#line 585 "parse_spice.y"
    {
    /* print/plot specification of operating point */
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, strdup ("OP"), HINT_NAME | HINT_MSTART);
    yyval.value = spice_append_str_values (yyval.value, yyvsp[0].ident, HINT_NAME | HINT_MSTOP);
  }
    break;

  case 67:
#line 593 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 68:
#line 594 "parse_spice.y"
    {
    yyval.value = netlist_append_values (yyvsp[-1].value, yyvsp[0].value);
  }
    break;

  case 69:
#line 597 "parse_spice.y"
    {
    yyval.value = netlist_append_values (yyvsp[-2].value, yyvsp[-1].value);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 70:
#line 601 "parse_spice.y"
    {
    yyval.value = netlist_append_values (yyvsp[-1].value, yyvsp[0].value);
  }
    break;

  case 71:
#line 604 "parse_spice.y"
    {
    yyval.value = netlist_append_values (yyvsp[-2].value, yyvsp[-1].value);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 72:
#line 610 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 73:
#line 611 "parse_spice.y"
    {
    yyval.value = spice_create_str_value (yyvsp[0].ident, HINT_NAME);
  }
    break;

  case 74:
#line 614 "parse_spice.y"
    {
    yyval.value = spice_create_str_value (yyvsp[0].ident, HINT_NAME);
  }
    break;

  case 75:
#line 619 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 76:
#line 620 "parse_spice.y"
    {
    yyval.value = netlist_append_values (yyvsp[-1].value, yyvsp[0].value);
  }
    break;

  case 77:
#line 623 "parse_spice.y"
    {
    yyval.value = netlist_append_values (yyvsp[-1].value, yyvsp[0].value);
  }
    break;

  case 78:
#line 628 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 79:
#line 629 "parse_spice.y"
    {
    yyval.value = spice_create_str_value (yyvsp[-1].ident, HINT_NAME);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 80:
#line 633 "parse_spice.y"
    {
    yyval.value = spice_create_par_value (yyvsp[-2].ident, yyvsp[-1].ident);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 81:
#line 639 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 82:
#line 640 "parse_spice.y"
    {
    yyval.value = spice_create_str_value (yyvsp[-1].ident, HINT_NAME);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 83:
#line 644 "parse_spice.y"
    {
    yyval.value = spice_create_par_value (yyvsp[-2].ident, yyvsp[-1].ident);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 84:
#line 650 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 85:
#line 651 "parse_spice.y"
    {
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-3].ident, HINT_NAME | HINT_MSTART);
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-2].ident, HINT_NODE | HINT_MSTOP);
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-1].ident, HINT_NUMBER);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 86:
#line 660 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 87:
#line 661 "parse_spice.y"
    {
    yyval.value = spice_create_par_value (yyvsp[-2].ident, yyvsp[-1].ident);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 88:
#line 665 "parse_spice.y"
    {
    yyval.value = spice_create_val_value (yyvsp[-1].ident, HINT_NUMBER);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 89:
#line 669 "parse_spice.y"
    {
    yyval.value = spice_create_val_value (yyvsp[-1].ident, HINT_NAME);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 90:
#line 673 "parse_spice.y"
    {
    yyval.value = netlist_append_values (yyvsp[-1].value, yyvsp[0].value);
  }
    break;

  case 91:
#line 678 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 92:
#line 679 "parse_spice.y"
    {
    yyval.value = spice_create_par_value (yyvsp[-2].ident, yyvsp[-1].ident);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 93:
#line 683 "parse_spice.y"
    {
    yyval.value = spice_create_val_value (yyvsp[-1].ident, HINT_NUMBER);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 94:
#line 687 "parse_spice.y"
    {
    yyval.value = spice_create_val_value (yyvsp[-1].ident, HINT_NAME);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 95:
#line 691 "parse_spice.y"
    {
    yyval.value = netlist_append_values (yyvsp[-1].value, yyvsp[0].value);
  }
    break;

  case 96:
#line 694 "parse_spice.y"
    {
    yyval.value = spice_create_par_value (yyvsp[-2].ident, yyvsp[-1].ident);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 97:
#line 700 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 98:
#line 701 "parse_spice.y"
    {
    yyval.value = spice_create_par_value (yyvsp[-2].ident, yyvsp[-1].ident);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 99:
#line 705 "parse_spice.y"
    {
    yyval.value = spice_create_par_value (yyvsp[-2].ident, yyvsp[-1].ident);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 100:
#line 709 "parse_spice.y"
    {
    yyval.value = spice_create_val_value (yyvsp[-1].ident, HINT_NUMBER);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 101:
#line 713 "parse_spice.y"
    {
    yyval.value = spice_create_val_value (yyvsp[-1].ident, HINT_NAME);
    yyval.value = netlist_append_values (yyval.value, yyvsp[0].value);
  }
    break;

  case 102:
#line 717 "parse_spice.y"
    {
    yyval.value = netlist_append_values (yyvsp[-1].value, yyvsp[0].value);
  }
    break;

  case 105:
#line 725 "parse_spice.y"
    {
    /* identification of a DC sweep */
    yyval.value = NULL;
    yyval.value = spice_append_str_values (yyval.value, yyvsp[-3].ident, HINT_NAME | HINT_MSTART);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[-2].ident, HINT_NUMBER);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[-1].ident, HINT_NUMBER);
    yyval.value = spice_append_val_values (yyval.value, yyvsp[0].ident, HINT_NUMBER | HINT_MSTOP);
  }
    break;

  case 111:
#line 739 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 112:
#line 740 "parse_spice.y"
    {
    yyval.value = spice_create_par_value (yyvsp[-2].ident, yyvsp[-1].ident);
    yyval.value->next = yyvsp[0].value;
  }
    break;

  case 113:
#line 746 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 114:
#line 747 "parse_spice.y"
    {
    yyval.value = spice_create_val_value (yyvsp[-1].ident, HINT_NUMBER);
    yyval.value->next = yyvsp[0].value;
  }
    break;

  case 115:
#line 753 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 116:
#line 754 "parse_spice.y"
    {
    yyval.value = spice_create_str_value (yyvsp[-1].ident, HINT_NODE);
    yyval.value->next = yyvsp[0].value;
  }
    break;

  case 117:
#line 761 "parse_spice.y"
    {
    yyval.value = spice_create_str_value (yyvsp[-1].ident, HINT_NAME | HINT_MSTART);
    spice_add_last_hint (yyvsp[0].value, HINT_MSTOP);
    yyval.value->next = yyvsp[0].value;
  }
    break;

  case 118:
#line 768 "parse_spice.y"
    { yyval.value = NULL; }
    break;

  case 119:
#line 769 "parse_spice.y"
    {
    yyval.value = netlist_append_values (yyvsp[-1].value, yyvsp[0].value);
  }
    break;

  case 120:
#line 775 "parse_spice.y"
    {
    yyvsp[-2].definition->sub = yyvsp[-1].definition;
    yyval.definition = yyvsp[-2].definition;
    yyvsp[-1].definition = NULL;
  }
    break;

  case 121:
#line 783 "parse_spice.y"
    {
    yyval.definition = spice_create_action (yyvsp[-3].ident, yyvsp[-2].ident);
    yyval.definition->values = yyvsp[-1].value;
  }
    break;

  case 122:
#line 789 "parse_spice.y"
    { yyval.definition = NULL; }
    break;

  case 123:
#line 790 "parse_spice.y"
    { /* chain definitions here */
    if (yyvsp[-1].definition) {
      yyvsp[-1].definition->next = yyvsp[0].definition;
      yyval.definition = yyvsp[-1].definition;
    }
    else {
      yyval.definition = yyvsp[0].definition;
    }
  }
    break;

  case 125:
#line 804 "parse_spice.y"
    { /* nothing to do */ }
    break;

  case 126:
#line 805 "parse_spice.y"
    { /* nothing to do */ }
    break;

  case 127:
#line 809 "parse_spice.y"
    { /* chain definitions here */
    yyvsp[0].definition->next = yyval.definition;
    yyval.definition = yyvsp[0].definition;
  }
    break;

  case 128:
#line 813 "parse_spice.y"
    { /* do nothing here, see subcircuit rule */ }
    break;

  case 129:
#line 814 "parse_spice.y"
    {
    yyval.definition = NULL;
  }
    break;


    }

/* Line 1010 of yacc.c.  */
#line 2612 "parse_spice.cpp"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
		 yydestruct (yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
	  yydestruct (yytoken, &yylval);
	  yychar = YYEMPTY;

	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 819 "parse_spice.y"


int spice_error (char * error) {
  fprintf (stderr, "line %d: %s\n", spice_lineno, error);
  return 0;
}

