/*
Remote Access Session v0.7 scanhost.c - Code By Angel Ramos <seamus@salix.org>
*/

#include "raccess.h"

int connect_nonblock (int sockfd, struct sockaddr_in *host, socklen_t len , int sec)	{
	int flags, error, n;
	socklen_t elen;
	fd_set rset, wset;
	struct timeval time;

	if ((flags = fcntl (sockfd, F_GETFL, 0)) == -1)	{
		perror ("Fcntl error");
	}
	if (fcntl (sockfd, F_SETFL, flags | O_NONBLOCK) == -1)	{
		perror ("Fcntl error");
	}
	error = 0;
	if ((n = connect (sockfd, (struct sockaddr *) host, len)) < 0)	{
		if (errno != EINPROGRESS)	{
			return (-1);
		}
	}
	if (n == 0)	{
		goto done;
	}  
	FD_ZERO (&rset);
	FD_SET (sockfd, &rset);
	wset = rset;
	time.tv_sec = sec;
	time.tv_usec = 0;
	if ((n = select (sockfd + 1, &rset, &wset, NULL, 
		sec ? &time : NULL)) == 0)	{
		close (sockfd);
		errno = ETIMEDOUT;
		return (-1);
	}
	if (FD_ISSET (sockfd, &rset) || FD_ISSET(sockfd, &wset))	{
		elen = sizeof(error);
		if (getsockopt (sockfd, SOL_SOCKET, SO_ERROR, &error, 
			&elen) < 0)	{
			return (-1);
		}
	}
	
	done:

		if (fcntl (sockfd, F_SETFL, flags) == -1)	{
			perror ("Fcntl error");
		}
		if (error)	{
			close (sockfd);
			errno = error;
			return (-1);
		}
		return (0);
}

void try_connect (char *host, int port, int *osdetect)	{
	int sockfd;
	struct sockaddr_in remotehost;
	struct hostent *hp;
	struct servent *service;
	char *servicename;
	char *token;
	char bannerports[512];
	int bannerport;
	
	if (port == 53)	{
		if ((sockfd = socket (AF_INET, SOCK_DGRAM, 0)) == -1)	{
		perror  ("Socket error");
		}
	}	
	else {
		if ((sockfd = socket (AF_INET, SOCK_STREAM, 0)) == -1)	{
		perror  ("Socket error");
		}
	}	
	remotehost.sin_family = AF_INET;
	remotehost.sin_port = htons (port);
	hp = gethostbyname (host);
	if (hp == 0)	{
		fprintf (stderr, "Can't resolve %s.\n\n", host);
		unlink (host);
		exit (1);
	}
	memcpy ((char *)&remotehost.sin_addr, (char *)hp->h_addr, 
		hp->h_length);
	if (connect_nonblock (sockfd, &remotehost, sizeof remotehost
		, 5) != -1)	{
		if ((*osdetect == 1) && (port != 53))	{
			detectos (host, port);
			*osdetect = 0;
		}
		if ((service = getservbyport (remotehost.sin_port
			, NULL)) == NULL)	{
			servicename = "unknown";
		}
		else	{
			servicename = service->s_name;
		} 
		if (port == 53)	{
			printf ("\n--Checking named version...\n");
		}
		else	{
			printf ("\n--Service %s Port %d: Opened!!--\n"
			, servicename, port);
			if ((filedesc = fopen (host, "a")) == NULL)	{
				printf ("Can't open log file.\n");
			} else	{
				fprintf (filedesc, "--Service %s Port %d opened!!--\n"
				, servicename, port);
				fclose (filedesc);
			}
		}
		strncpy (bannerports, BANNER_PORTS, 512);
		token = strtok (bannerports, ",");
		bannerport = atoi (token);
		if (port == bannerport)	{
			extract_banner (sockfd, port, servicename, host);
		}
		while ((token = strtok (NULL, ",")) != NULL)	{
			bannerport = atoi (token);
			if  (port == bannerport)	{
				extract_banner (sockfd, port, servicename, host);
			}
		}
	}
	close (sockfd);
}

void scanhost (char *host, int osdetect, int onlyscan)	{
	int port;
	char scanports[512];
	char *tok;
	int i, n;
	char *array_ports[1];
	
	strncpy (scanports, PORTS, 512);
	tok = strtok_r (scanports, ",", array_ports);
	port = atoi (tok);
	try_connect (host, port, &osdetect);
	while ((tok = strtok_r (NULL, ",", array_ports)) != NULL)	{
		port = atoi (tok);
		try_connect (host, port, &osdetect);
	}
	printf ("\n~~~~~~~~~~~~~~~~\n");
	printf ("Scan Completed!!\n\n");
	if (onlyscan == 0)	{
		control = 0;
		efind = 0;
		nfind = 0;
		printf ("Starting attack session...\n");
		remote_attack (host);
	}
} 
 
char *extract_host (char *host)	{
	char *orghost;
	char *netmask;
	int hostmask, hostnumber;
	static int remain;
	static int first = 1;
			
	if (first ==1)	{
		
		a = -1;
		b = -1;
		c = -1;
		d = -1;
		
		if (strstr (host, "/") == NULL)	{
			printf ("Bad format of network adresses.\n");
			usage ("raccess");
		} 
		orghost = strtok (host, "/");
		netmask = strtok (NULL, "/");
		if (atoi (netmask) > 32)	{
			printf ("Bad format of network adresses.\n");
			usage ("raccess");
		}
		hostmask = (32 - atoi (netmask));
		while (*netmask != '\0')	{
			if (isdigit (*netmask) == 0)	{
				printf ("Bad format of network adresses.\n");
				usage ("raccess");
			}
			netmask++;
		}
		sscanf (orghost, "%d.%d.%d.%d", &a, &b, &c, &d);
		if ((a == -1) || (b == -1) || (c == -1) || (d == -1))	{
			printf ("Bad format of network adresses.\n");
			usage ("raccess");
		} 
		if ((a > 255) || (b > 255) || (c > 255) || (d > 255))	{
			printf ("Bad format of network adresses.\n");
			usage ("raccess");
		}
		hostnumber = pow (2, hostmask);
		printf ("Hosts to scan: %d\n", hostnumber);
		first--;
		remain = hostnumber - 1;
		strncpy (finalhost, orghost, sizeof (finalhost));
	} else	{
		snprintf (finalhost, sizeof (finalhost), "%d.%d.%d.%d", a, b, c, d);
	}
	if (remain)	{
		printf ("\nHost: %s\n", finalhost);
		remain --;
		if (d < 255)	{
			d++;
		} else {
			d = 0;
			if (c < 255)	{
				c++;
			} else	{
				c = 0;
				if (b < 255)	{
					b++;
				} else	{
					b = 0;
					if (a < 255)	{
						a++;
					} else	{
						netscan = 0;
					}
				}
			}
		}
		return (finalhost);
	} else	{
		printf ("Host: %s\n", finalhost);
		netscan = 0;
		return (finalhost);
	}
}
