#include <ClanLib/core.h>
#include <ClanLib/display.h>

#include "fonts.h"
#include "debug.h"
#include "config.h"

CL_Font* Fonts::laps              = NULL;
CL_Font* Fonts::menu_big          = NULL;
CL_Font* Fonts::menu_small        = NULL;
CL_Font* Fonts::position          = NULL;

void Fonts::init()
{
	RaceDebug::print( "Resources: resources/fonts.res", 7 );

	CL_String path = DATADIR;
	path += "resources/fonts.res";

	CL_ResourceManager res( path, false );
	
	if( laps == NULL )
		laps = CL_Font::load("fonts/laps", &res);
	if( menu_big == NULL )
		menu_big = CL_Font::load("fonts/menu_big", &res);
	if( menu_small == NULL )
		menu_small = CL_Font::load("fonts/menu_small", &res);
	if( position == NULL )
		position = CL_Font::load("fonts/position", &res);
}



