#ifndef menu_options_keys
#define menu_options_keys

#include <ClanLib/gui.h>

class OptionsKeys : public CL_Component
{
 public:
	OptionsKeys(CL_Component *parent, CL_StyleManager *style);
	~OptionsKeys();

 // Callback functions
 private:
	void on_paint();

	void on_select_left();
	void on_select_right();
	void on_select_gas();
	void on_select_brake();

 // Operations
 private:
	int get_key();
	std::string get_key_name(int);

 private:
	CL_SlotContainer slots;
/*
	CL_Slot slot_paint;

	CL_Slot slot_select_left;
	CL_Slot slot_select_right;
	CL_Slot slot_select_gas;
	CL_Slot slot_select_brake;
*/
	CL_Button button_left;
	CL_Button button_brake;
	CL_Button button_gas;
	CL_Button button_right;

	CL_Label label_left;
	CL_Label label_right;
	CL_Label label_gas;
	CL_Label label_brake;

	CL_Surface *label_press_key;

	int key_left, key_right, key_gas, key_brake;
};

 #endif
