#include <ClanLib/core.h>
#include <ClanLib/display.h>
#include <ClanLib/gl.h>
#include <ClanLib/gui.h>

#ifdef WIN32
	#pragma warning (disable:4355)
#endif

#include "menu_gfx.h"
#include "track_menu.h"
#include "../debug.h"
#include "../music.h"
#include "../race_opengl.h"
#include "../race_text.h"
#include "../game_config.h"
#include "../season.h"
#include "../race_opengl.h"

TrackMenu::TrackMenu(CL_Component *parent, CL_StyleManager *style)
:
	CL_Component(
			CL_Rect(0, 0, CL_Display::get_width(), CL_Display::get_height()),
			parent,
			style),
		
		btn_cancel(   CL_Rect(  10,    100, 10 + 120, 100 + 30), "Cancel",   this, style),
		btn_continue( CL_Rect(  10,    140, 10 + 120, 140 + 30), "Continue", this, style),
		btn_add(      CL_Rect( 400-24, 290, 400 + 24, 290 + 30), "Add",      this, style),
		btn_del(      CL_Rect( 400-24, 340, 400 + 24, 340 + 30), "Del",      this, style),
		
		lbox_available( CL_Rect( 400-200-50, 270, 400-50,     485), this, style),
		lbox_selected(  CL_Rect( 400+50,     270, 400+200+50, 485), this, style)
{
	RaceDebug::print( "TrackMenu: constructor", 9 );
	
	slots.connect( sig_paint(), this, &TrackMenu::on_paint );
	slots.connect( btn_cancel.sig_clicked(), this, &TrackMenu::on_cancel );
	slots.connect( btn_continue.sig_clicked(), this, &TrackMenu::on_continue );
	slots.connect( btn_add.sig_clicked(), this, &TrackMenu::on_add );
	slots.connect( btn_del.sig_clicked(), this, &TrackMenu::on_del );

	load_track_list();
	
	lbox_available.set_multi_selection(true);
	lbox_selected.set_multi_selection(true);
}

TrackMenu::~TrackMenu()
{
}

// .=======================< >=======================.
// | on_* functions                                  |
// '=======================< >======================='

void TrackMenu::on_cancel()
{
	CL_Component::quit();
}

void TrackMenu::on_continue()
{
	save_selection();

	btn_del.set_focus();
	
	enable(false); // disable input to gui
	Race_OpenGL::end_2d();	
	
	Season season;
	season.start();
	
	Race_OpenGL::begin_2d();	
	
	RaceDebug::print( "TrackMenu: back from season loop", 6 );
	
	enable(true);
}

void TrackMenu::on_add()
{
	for( int index=0; index < lbox_available.get_count(); index++ )
		if( lbox_available.is_selected(index) )
			lbox_selected.insert_item(lbox_available.get_text(index));
}

void TrackMenu::on_del()
{
	for( int index = lbox_selected.get_count(); index >= 0; index-- )
	{
		if( lbox_selected.is_selected(index) )
		{
			lbox_selected.remove_item(index);
		}
	}
}

void TrackMenu::on_paint()
{
	RaceDebug::print( "TrackMenu: on_paint()", 8 );
	MenuGfx::bg->put_screen(0,0);

	Music::update();
}




void TrackMenu::load_track_list()
{
	CL_String list_path = "data/track_list.lst";
	
	CL_InputSourceProvider *input = CL_InputSourceProvider::create_file_provider("");
	CL_InputSource *file = input->open_source( list_path );
	
	bool a = true;
	while( a )
	{
		std::string track_name = RaceText::read_line_get_base_name(file);
		if( track_name == "#end" )
			a = false;
		else
			lbox_available.insert_item( track_name );
	}
	
	lbox_available.sort();
	load_selected_tracks();
}


void TrackMenu::load_selected_tracks()
{
	Config::selected_tracks.clear();

	CL_String list_path = "data/selected_tracks.lst";

	CL_InputSourceProvider *input = CL_InputSourceProvider::create_file_provider("");
	CL_InputSource *file = input->open_source( list_path );

	bool a = true;
	while( a )
	{
		std::string track_name = RaceText::read_line_get_base_name(file);
		if( track_name == "#end" )
			a = false;
		else
		{
			// Config::selected_tracks.push_back( track_name );
			lbox_selected.insert_item( track_name );
		}
	}
	
	lbox_selected.sort();
}

// Save the names of the selected tracks and 
// copy track names to Config::selected_tracks

void TrackMenu::save_selection()
{
	std::vector<CL_ListBox_Item> selected_tracks = lbox_selected.get_items();
	std::vector<std::string> tracks;

	std::ofstream fout("data/selected_tracks.lst");
	
	for( int i=0; i < selected_tracks.size(); i++ )
	{
		fout << selected_tracks[i].str.c_str() << std::endl;
		tracks.push_back(selected_tracks[i].str);
	}
   

	fout << "#end" << endl;
	
	fout.close();
	
	Config::selected_tracks = tracks;
}


