/*
 * This Game is distributed under the GNU GENERAL PUBLIC LICENSE
 * version 2. See COPYING for details.
 *
 * Copyright (C) 1999, 2000, 2001 Harry Storbacka <harrysto@nic.fi> 
 * 
 * Race homepage: http://race.sourceforge.net
 * 
*/


#include <ClanLib/display.h>

#include <algorithm>
#include <cstdio>
#include "map.h"
#include "game_config.h"
#include "tile_blitter.h"

// For some weird reason, min and max doesnt work under windows.
// I guess the win32 algorithm header file is broken or something.
// -- mbn
#ifdef WIN32
#define min(a, b) (a<b?a:b)
#define max(a, b) (a>b?a:b)
#endif


void TileBlitter::blit_road( CL_Canvas *canvas, CL_Surface* surface, tileMap *map )
{
	CL_SurfaceProvider *provider = surface->get_provider();

	float red, green, blue, alpha;
	float tred, tgreen, tblue, talpha;

	canvas->lock();
	provider->lock();

	for( int y=0; y < Config::map_tiles_y; y++ ) // x & y are in tile coords
	{
		for( int x=0; x < Config::map_tiles_x; x++ )
		{
			if( map->get_tile_id( x, y ) > 0 ) // #: road
			{
				int tsrc_x = Config::tile_size*x +Config::tile_size;
				int tsrc_y = Config::tile_size*y +Config::tile_size;
				
				for( int src_y = Config::tile_size*y; src_y < tsrc_y; src_y++ )
				{
					for( int src_x = Config::tile_size*x; src_x < tsrc_x; src_x++ )
					{
						provider->get_pixel( src_x, src_y, &red, &green, &blue, &alpha);
						
						if( alpha > 0 )
						{
							canvas->get_pixel( src_x, src_y, &tred, &tgreen, &tblue, &talpha);
							canvas->draw_pixel( src_x, src_y,
							max(0.0, min(1.0, (red * alpha) + (tred * (1.0-alpha)))),
							max(0.0, min(1.0, (green * alpha) +(tgreen * (1.0-alpha)))),
							max(0.0, min(1.0, (blue * alpha)  + (tblue * (1.0-alpha)))),
							1.0 );
						}
					}
				}
			}
		}
	}
  	provider->unlock();
	canvas->unlock();
}




void TileBlitter::blit_water( CL_Canvas *canvas, CL_Surface* surface, tileMap *map )
{
	CL_SurfaceProvider *provider = surface->get_provider();

	float red, green, blue, alpha;
	float tred, tgreen, tblue, talpha;

	canvas->lock();
	provider->lock();

	for( int y=0; y < Config::map_tiles_y; y++ ) // x & y are in tile coords
	{
		for( int x=0; x < Config::map_tiles_x; x++ )
		{
			if( map->get_tmp_map( x, y ) == 'W' ) // W: water
			{
				int tsrc_x = Config::tile_size*x +Config::tile_size;
				int tsrc_y = Config::tile_size*y +Config::tile_size;
			
				for( int src_y = Config::tile_size*y; src_y < tsrc_y; src_y++ )
				{
					for( int src_x = Config::tile_size*x; src_x < tsrc_x; src_x++ )
					{
						provider->get_pixel( src_x, src_y, &red, &green, &blue, &alpha);
						
						if( alpha > 0 ) 
						{
							canvas->get_pixel( src_x, src_y, &tred, &tgreen, &tblue, &talpha);
							canvas->draw_pixel( src_x, src_y,
							max(0.0, min(1.0, (red * alpha) + (tred * (1.0-alpha)))),
							max(0.0, min(1.0, (green * alpha) +(tgreen * (1.0-alpha)))),
							max(0.0, min(1.0, (blue * alpha)  + (tblue * (1.0-alpha)))),
							1.0 );
						}
					}
				}
			}
		}
	}
	canvas->unlock();
  	provider->unlock();
}




void TileBlitter::fill_road( CL_Canvas *canvas, CL_Surface* surface, tileMap *map )
{
	CL_SurfaceProvider *provider = surface->get_provider();
	
	int s_width = provider->get_width();
	int s_height = provider->get_height();
	
	float r,g,b,a, bogus_a;

	float cR, cB;
	cR = cB = 1.0f; // pink
	
	canvas->lock();
	provider->lock();

	for( int y=0; y < Config::map_tiles_y; y++ ) // x & y are in tile coords
	{
		for( int x=0; x < Config::map_tiles_x; x++ )
		{
			if( map->get_tile_id( x, y ) > 0 )
			{
				int tsrc_x = Config::tile_size*x +Config::tile_size;
				int tsrc_y = Config::tile_size*y +Config::tile_size;
			
				for( int ay = Config::tile_size*y; ay < tsrc_y; ay++ )
				{
					for( int ax = Config::tile_size*x; ax < tsrc_x; ax++ )
					{
						int times_x = (int)(ax / s_width);
					    int src_x = ax - (times_x * s_width);
			
						int times_y = (int)(ay / s_height);
					    int src_y = ay - (times_y * s_height);
			
					    canvas->get_pixel( ax, ay, &r, &g, &b, &a );
			
						if( r == cR && b == cB )
						{
							provider->get_pixel( src_x, src_y, &r, &g, &b, &bogus_a );
						    canvas->draw_pixel( ax, ay, r, g, b, a ); // doesnt change canvas alpha
						}
					}
				}
			}
		}
	}

	canvas->unlock();
	provider->unlock();
}

void TileBlitter::fill_water( CL_Canvas *canvas, CL_Surface* surface, tileMap *map )
{
	CL_SurfaceProvider *provider = surface->get_provider();
	
	int s_width = provider->get_width();
	int s_height = provider->get_height();
	
	float r,g,b,a, bogus_a;

	float cR, cB;
	cR = cB = 1.0f; // pink
	
	canvas->lock();
	provider->lock();

	for( int y=0; y < Config::map_tiles_y; y++ ) // x & y are in tile coords
	{
		for( int x=0; x < Config::map_tiles_x; x++ )
		{
			if( map->get_tmp_map( x, y ) == 'W' ) // W: water
			{
				int tsrc_x = Config::tile_size*x +Config::tile_size;
				int tsrc_y = Config::tile_size*y +Config::tile_size;
			
				for( int ay = Config::tile_size*y; ay < tsrc_y; ay++ )
				{
					for( int ax = Config::tile_size*x; ax < tsrc_x; ax++ )
					{
						int times_x = (int)(ax / s_width);
					    int src_x = ax - (times_x * s_width);
			
						int times_y = (int)(ay / s_height);
					    int src_y = ay - (times_y * s_height);
			
					    canvas->get_pixel( ax, ay, &r, &g, &b, &a );
			
						if( r == cR && b == cB )
						{
							provider->get_pixel( src_x, src_y, &r, &g, &b, &bogus_a );
						    canvas->draw_pixel( ax, ay, r, g, b, a ); // doesnt change canvas alpha
						}
					}
				}
			}
		}
	}

	canvas->unlock();
	provider->unlock();
}


