// 
// $Id: qaregexperror.hpp,v 1.3 1999/07/22 01:57:35 amos Exp $
//
// Definition of QaRegExpError class
//
// Jan Borsodi <amos@abn.hibu.no>
// Created on: <21-Jul-1999 23:16:39 amos>
//
// Copyright (C) 1999 Jan Borsodi.  All rights reserved.
//

#ifndef QAREGEXPERROR_HPP
#define QAREGEXPERROR_HPP

#include <qstring.h>

class QaRegExpError
{
public:
    enum RegExpCode
    {
        NoErr,
        BadPointer,
        BadBackReference,
        UnmatchedBrace,
        UnmatchedBracket,
        InvalidRange,
        UnknownClass,
        InvalidCollate,
        UnmatchedParenthesis,
        InvalidBackReference,
        NonPosixError,
        TrailingBackslash,
        BadPattern,
        BufferOverflow,
        OutOfMemory,
        UnknownError
    };
    QaRegExpError( int err,  const QString &s );
    virtual ~QaRegExpError();

    const QString &error() const;
    RegExpCode errorCode() const;

private:
    QString Str;
    RegExpCode Error;
};


#endif // QAREGEXPERROR_HPP
