// 
// $Id$
//
// Implementation of QaPlainLanguage class
//
// Jan Borsodi <jb@ez.no>
// Created on: <04-Sep-2000 14:10:08 amos>
//
// Copyright (C) Jan Borsodi.  All rights reserved.


#include "qaplainlanguage.hpp"

/*! \file qaplainlanguage.cpp
  Implementation of QaPlainLanguage class
*/

/*!
  \class QaPlainLanguage qaplainlanguage.hpp
  \brief
  \author <a href="mailto:jb@ez.no">Jan Borsodi</a>
  \date Enter current date here

*/

/*!
  Default constructor
*/

QaPlainLanguage::QaPlainLanguage()
    : QaRegExpLanguage()
{
}

/*!
  Destroys the object
*/

QaPlainLanguage::~QaPlainLanguage()
{
}

/*!
  Converts the RegExp to a plain form, that is without special \'s etc..
*/

QString QaPlainLanguage::fromPlainText( const QString &s, bool, MatchType type )
{
    QString str;
    unsigned int i = 0;
    bool bracket = false;
    bool negated = false;
//    ( i = s.find( "\\", i ) ) != -1 )
    for ( i = 0; i < s.length(); i++ )
    {
        QChar c2 = s.at( i );
        if ( bracket )
        {
            if ( c2 == ']' )
            {
                bracket = false;
                negated = false;
                str += c2;
            }
            else if ( c2 == '^' )
            {
                negated = true;
                str += c2;
            }
            else if ( c2 == '\\' )
            {
                i++;
                if ( i < s.length() )
                {
                    QChar c  = s.at( i );
                    if ( c == "t" )
                        str += "\\t";
                    else if ( c == "n" )
                        str += "\\n";
                    else if ( c == "r" )
                        str += "\\r";
                    else if ( c == "f" )
                        str += "\\f";
                    else if ( c == "d" )
                        str += "0-9";
                    else if ( c == "D" )
                    {
                        if ( !negated )
                        {
                            negated = true;
                            str += "^";
                        }
                        str += "0-9";
                    }
                    else if ( c == "w" )
                        str += characters();
                    else if ( c == "W" )
                    {
                        if ( !negated )
                        {
                            negated = true;
                            str += "^";
                        }
                        str += characters();
                    }
                    else if ( c == 'c' )
                        str += nonCapitalCharacters();
                    else if ( c == 'C' )
                        str += capitalCharacters();
                    else if ( c == 'i' )
                        str += wordCharacters();
                    else if ( c == "s" )
                        str += " \\t\\n\\r\\f";
                    else if ( c == "S" )
                    {
                        if ( !negated )
                        {
                            negated = true;
                            str += "^";
                        }
                        str += " \\t\\n\\r\\f";
                    }
                    else if ( c == "]" )
                        str += "\\]";
                    else if ( c == "\\" )
                        str += "\\\\";
                    else
                    {
                        str += c2;
                        str += c;
                    }
                }
                else
                    str += c2;
            }
            else
                str += c2;
        }
//\a<(class|public|private|protected|typename|signals|slots)>
        else
        {
            if ( c2 == '[' )
            {
                bracket = true;
                negated = false;
                str += c2;
            }
            else if ( c2 == '\\' )
            {
                i++;
                if ( i < s.length() )
                {
                    QChar c  = s.at( i );
                    if ( c == 't' )
                        str += "\\t";
                    else if ( c == 'n' )
                        str += "\\n";
                    else if ( c == 'r' )
                        str += "\\r";
                    else if ( c == 'f' )
                        str += "\\f";
                    else if ( c == 'd' )
                        str += "[0-9]";
                    else if ( c == 'D' )
                        str += "[^0-9]";
                    else if ( c == 'w' )
                        str += QString( "[" ) + characters() + QString( "]" );
                    else if ( c == 'W' )
                        str +=  QString( "[^" ) + characters() + QString( "]" );
                    else if ( c == 'c' )
                        str += QString( "[" ) + nonCapitalCharacters() + QString( "]" );
                    else if ( c == 'C' )
                        str += QString( "[" ) + capitalCharacters() + QString( "]" );
                    else if ( c == 'i' )
                        str += QString( "[" ) + wordCharacters() + QString( "]" );
                    else if ( c == 'I' )
                        str += identifiers();
                    else if ( c == 's' )
                        str += "[ \\t\\n\\r\\f]";
                    else if ( c == 'S' )
                        str += "[^ \\t\\n\\r\\f]";
//                    else if ( c == "]" )
//                        str += "\\]";
                    else if ( c == '\\' )
                        str += "\\\\";
                    else
                    {
                        str += c2;
                        str += c;
                    }
                }
                else
                    str += c2;
            }
            else
                str += c2;
        }
    }
    return str;
}
