\name{localPkg-class}
\docType{class}
\alias{localPkg-class}
\alias{Depends}
\alias{Keywords}
\alias{Package}
\alias{Repos}
\alias{Suggests}
\alias{Imports}
\alias{PkgVersion}
\alias{Bundle}
\alias{Bundle,localPkg-method}
\alias{Depends,localPkg-method}
\alias{Keywords,localPkg-method}
\alias{Package,localPkg-method}
\alias{PkgVersion,localPkg-method}
\alias{Repos,localPkg-method}
\alias{Suggests,localPkg-method}
\alias{Imports,localPkg-method}
\title{Class "localPkg": A class to represent locally installed packages}
\description{ This class is used to represent a package, and the
  information necessary for repository management}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("localPkg", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{Package}:}{Object of class \code{"character"} The name
      of the package}
    \item{\code{PkgVersion}:}{Object of class \code{"VersionNumber"} The
    version of the package}
    \item{\code{Keywords}:}{Object of class \code{"character"} Keywords
      for the package}
    \item{\code{Depends}:}{Object of class \code{"character"}
      Dependencies for the package}
    \item{\code{Suggests}:}{Object of class \code{"character"} Suggests
      level dependencies of the package}
    \item{\code{Imports}:}{Object of class \code{"character"} Imports level
      dependencies for the package}
    \item{\code{Repos}:}{Object of class \code{"character"} The
      repository that this package was obtained from}
    \item{\code{Bundle}:}{Object of class \code{"character"} Reports
      which (if any) package bundle this package is a part of}
  }
}

\section{Methods}{
  \describe{
    \item{Depends}{\code{signature(object = "localPkg")}: Returns the
      Depends slot}
    \item{Keywords}{\code{signature(object = "localPkg")}: Returns the
      Keywords slot }
    \item{Package}{\code{signature(object = "localPkg")}: Returns the
      Package slot}
    \item{PkgVersion}{\code{signature(object = "localPkg")}: Returns the
    PkgVersion slot}
    \item{Repos}{\code{signature(object = "localPkg")}: Returns the
      Repos slot}
    \item{Suggests}{\code{signature(object = "localPkg")}: Returns the
      Suggests slot}
    \item{Imports}{\code{signature(object = "localPkg")}: Returns the Imports slot}
    \item{Bundle}{\code{signature(object = "localPkg")}: Returns the
      Bundle slot}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{syncLocalLibList}}, \code{\link{install.packages2}}}

\examples{
}
\keyword{classes}
