\name{reposTheme-class}
\docType{class}
\alias{reposTheme-class}
\alias{reposTheme}
\alias{repThemeName}
\alias{repThemePkgs}
\alias{repThemeDesc}
\alias{repThemeRepos}
\alias{repThemeDesc,reposTheme-method}
\alias{repThemeRepos,reposTheme-method}
\alias{repThemeName,reposTheme-method}
\alias{repThemePkgs,reposTheme-method}
\alias{show,reposTheme-method}
\title{Class "reposTheme", a class to model repository themes}
\description{
  The \code{reposTheme} class is used to model repository
  \code{\link{themes}} for both server and client operations within the
  \code{reposTools} package.
}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("reposTheme", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{repThemeName}:}{Object of class \code{"character"}: The
      name of the theme.}
    \item{\code{repThemeDesc}:}{Object of class \code{"character"}:  A
      short description of this theme.}
    \item{\code{repThemeRepos}:}{Object of class \code{"character"}: The
      URL of the repository that this theme belongs to.}
    \item{\code{repThemePkgs}:}{Object of class \code{"list"}: A list of
    objects of class \code{pkgInfo}, used to specify the packages
    contained by this \code{\link{themes}}.}
  }
}
\section{Methods}{
  \describe{
    \item{repThemeName}{\code{signature(object = "reposTheme")}:
      Retrieves the \code{repThemeName} slot.}
    \item{repThemeDesc}{\code{signature(object = "reposTheme")}:
      Retrieves the \code{repThemeDesc} slot.}
    \item{repThemeRepos}{\code{signature(object = "reposTheme")}:
      Retrieves the \code{repThemeRepos} slot.}
    \item{repThemePkgs}{\code{signature(object = "reposTheme")}:
      Retrieves the \code{repThemePkgs} slot.}
    \item{show}{\code{signature(object = "reposTheme")}:
      Displays a summary of the information about the theme.}
  }
}
\author{Jeff Gentry}
\seealso{\code{link{themes}}, \code{\link{writeThemesXML}}}
\examples{
   ## loading an example RDA file
   load(system.file(file.path("themes", "repThemes.rda"), package="reposTools"))
   for (i in seq(along=repThemes))
      show(repThemes[[i]])
}
\keyword{classes}

