# Source this file into a thread-enabled version of R & then call threadedInputExample().
#
# Issue the two commands
#  e1 <- evalWindow("A")
#  e2 <- evalWindow("B")
# to create two windows entitled `A' and `B' and two R variables named
# e1 and e2.
#
# Then, in each input window (A and B respectively), issue the following command
# 
#  NewThread(longCommand(e1$output))
#  NewThread(longCommand(e2$output, n = 30))
#
# and click on the "Eval" button in each.
#
# You will see the first count to 20 and the second count to 30,
# printing the numbers in the corresponding output window.

# As one clicks the Eval button multiple times, new threads
# will be interleaved and the output will be mixed across
# threads reporting to the same output area.


#
#
#
#

evalWindow <-
function(title="A") {
 
  w <- gtkWindow(title) 
  box <- gtkVBox()
  txt <- gtkText()
  gtkAdd(box, txt)

  output <- gtkText("")
  gtkAdd(box, output)

  b <- gtkButton("Eval")
  gtkAdd(box, b)


  gtkAdd(w, box)
  gtkShow(b, txt, output, box, w)

  handler <-
  function(text, output)
  {
    function(w) { 
      try( {
          sink(con <- textConnection(".output", "w"))
          print(eval(parse(text=gtkGetText(text))))
          sink()          
          close(con)        
          gtkSetText(output, paste(.output, "\n", collapse="\n"), append=T)
        })
      }
  }
  gtkAddCallback(b, "clicked", handler(txt, output))

  return(list(text = txt, output=output, button = b))
}

longCommand <-
function(out, n = 20) {
 function() {
   for(i in 1:n) {
    gtkSetText(out, paste(i, "\n", sep=""), append=T)   
    Snooze(2)
   }
 }
}

threadedInputExample <-
function()
{
  e1 <- evalWindow("A")
  e2 <- evalWindow("B")
  assign("e1", e1, envir=globalenv())
  assign("e2", e2, envir=globalenv())

  gtkSetText(e1$text, "NewThread(longCommand(e1$output))", append=FALSE)
  gtkSetText(e2$text, "NewThread(longCommand(e2$output))", append=FALSE)
}
