\name{print.GtkType}
\alias{print.GtkType}
\title{Produce prettier output for a GtkType object}
\description{
  This is a simple method for creating a
  more human-readable view of a \code{GtkType}
  object which represents the underlying
  ``class'' in the C-level Gtk libraries.
  The simplified representation just gives the
  name of the Gtk class (as defined in the C code
  that declares that class).
}
\usage{
print.GtkType(x, ...)
}
\arguments{
  \item{x}{the \code{GtkType} object to be shown.}
  \item{...}{passed on to the \code{print} call for the names.}
}
\details{
  This discards the low-level key used to identify
  the C-level type information and shows ony the
  name of the Gtk type.
}
\value{
 A character vector giving the button.
}
\references{
  Information on the package is available
  from \url{http://www.omegahat.org/RGtk}.

  Information on Gtk is available from
  \url{http://www.gtk.org}.
}
\author{
Duncan Temple Lang <duncan@research.bell-labs.com>
}


\seealso{
  \code{\link{gtkGetType}}
  \code{\link{gtkObjectGetType}}  
}

\examples{
 gtkInit()

  # Make certain the class is available to us.
  # Either create an instance or
  #  call the C routine to get the type.
  # .C("gtk_button_get_type")
 gtkButton()

 tp <- gtkGetType("GtkButton")
 print(tp)
}
\keyword{interface}
