/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.debugger;

import java.awt.ActiveEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextListener;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeCall;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.debug.DebugFrame;
import org.mozilla.javascript.debug.DebuggableScript;
import org.mozilla.javascript.debug.Debugger;
import org.mozilla.javascript.tools.debugger.ContextData;
import org.mozilla.javascript.tools.debugger.ContextHelper;
import org.mozilla.javascript.tools.debugger.ContextWindow;
import org.mozilla.javascript.tools.debugger.CreateFileWindow;
import org.mozilla.javascript.tools.debugger.EnterInterrupt;
import org.mozilla.javascript.tools.debugger.EvalWindow;
import org.mozilla.javascript.tools.debugger.ExitInterrupt;
import org.mozilla.javascript.tools.debugger.FileWindow;
import org.mozilla.javascript.tools.debugger.FindFunction;
import org.mozilla.javascript.tools.debugger.FrameHelper;
import org.mozilla.javascript.tools.debugger.JSInternalConsole;
import org.mozilla.javascript.tools.debugger.LoadFile;
import org.mozilla.javascript.tools.debugger.Menubar;
import org.mozilla.javascript.tools.debugger.MessageDialogWrapper;
import org.mozilla.javascript.tools.debugger.MoreWindows;
import org.mozilla.javascript.tools.debugger.OpenFile;
import org.mozilla.javascript.tools.debugger.ScopeProvider;
import org.mozilla.javascript.tools.debugger.ScriptItem;
import org.mozilla.javascript.tools.debugger.SetFilePosition;
import org.mozilla.javascript.tools.debugger.SourceInfo;
import org.mozilla.javascript.tools.debugger.UpdateContext;
import org.mozilla.javascript.tools.debugger.UpdateFileText;

public class Main
extends JFrame
implements Debugger,
ContextListener {
    ObjToIntMap contexts = new ObjToIntMap();
    static Thread mainThread;
    boolean breakFlag = false;
    static final int STEP_OVER = 0;
    static final int STEP_INTO = 1;
    static final int STEP_OUT = 2;
    static final int GO = 3;
    static final int BREAK = 4;
    static final int RUN_TO_CURSOR = 5;
    static final int EXIT = 6;
    private Hashtable threadState = new Hashtable();
    private Thread runToCursorThread;
    private int runToCursorLine;
    private String runToCursorFile;
    private Hashtable scriptItems = new Hashtable();
    private Hashtable sourceNames = new Hashtable();
    Hashtable functionNames = new Hashtable();
    JDesktopPane desk;
    ContextWindow context;
    Menubar menubar;
    JToolBar toolBar;
    JSInternalConsole console;
    EvalWindow evalWindow;
    JSplitPane split1;
    JLabel statusBar;
    ScopeProvider scopeProvider;
    Runnable exitAction;
    int frameIndex = -1;
    boolean isInterrupted = false;
    boolean nonDispatcherWaiting = false;
    int dispatcherIsWaiting = 0;
    Context currentContext = null;
    JFileChooser dlg;
    Hashtable fileWindows = new Hashtable();
    FileWindow currentWindow;
    Object monitor = new Object();
    Object swingMonitor = new Object();
    int returnValue = -1;
    boolean breakOnExceptions;
    boolean breakOnEnter;
    boolean breakOnReturn;
    Hashtable toplevels = new Hashtable();
    static /* synthetic */ Class class$javax$swing$JSplitPane;

    public void contextCreated(Context cx) {
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            ContextData contextData = new ContextData();
            cx.setDebugger(this, contextData);
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(-1);
            if (this.breakFlag || Thread.currentThread() == mainThread) {
                contextData.breakNextLine = true;
            }
        }
    }

    public void contextEntered(Context cx) {
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            if (!this.contexts.has(cx) && cx.getDebugger() == this) {
                this.contexts.put(cx, 1);
            }
        }
    }

    public void contextExited(Context cx) {
    }

    public void contextReleased(Context cx) {
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            this.contexts.remove(cx);
        }
    }

    public void doBreak() {
        this.breakFlag = true;
        ObjToIntMap objToIntMap = this.contexts;
        synchronized (objToIntMap) {
            ObjToIntMap.Iterator iter = this.contexts.newIterator();
            iter.start();
            while (!iter.done()) {
                Context cx = (Context)iter.getKey();
                ContextData.get((Context)cx).breakNextLine = true;
                iter.next();
            }
        }
    }

    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.console.consoleTextArea.requestFocus();
            this.context.split.setDividerLocation(0.5);
            try {
                this.console.setMaximum(true);
                this.console.setSelected(true);
                this.console.show();
                this.console.consoleTextArea.requestFocus();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    ScriptItem getScriptItem(DebuggableScript fnOrScript) {
        ScriptItem item = (ScriptItem)this.scriptItems.get(fnOrScript);
        if (item == null) {
            String url = this.getNormilizedUrl(fnOrScript);
            SourceInfo si = (SourceInfo)this.sourceNames.get(url);
            if (si == null && !fnOrScript.isGeneratedScript()) {
                String source = null;
                try {
                    InputStream is = Main.openSource(url);
                    try {
                        source = Main.readSource(is);
                        Object var8_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    {
                    }
                }
                catch (IOException ex) {
                    System.err.println("Failed to load source from " + url + ": " + ex);
                }
                if (source != null) {
                    si = this.registerSource(url, source);
                }
            }
            if (si != null) {
                item = this.registerScript(si, fnOrScript);
            }
        }
        return item;
    }

    public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
        String sourceUrl = this.getNormilizedUrl(fnOrScript);
        SourceInfo si = this.registerSource(sourceUrl, source);
        this.registerScript(si, fnOrScript);
    }

    String getNormilizedUrl(DebuggableScript fnOrScript) {
        String url = fnOrScript.getSourceName();
        if (url == null) {
            url = "<stdin>";
        } else {
            int searchStart;
            int evalSeparator = 35;
            StringBuffer sb = null;
            int urlLength = url.length();
            int cursor = 0;
            while ((searchStart = url.indexOf(evalSeparator, cursor)) >= 0) {
                String replace = null;
                int i = searchStart + 1;
                boolean hasDigits = false;
                while (i != urlLength) {
                    char c = url.charAt(i);
                    if ('0' > c || c > '9') break;
                    ++i;
                }
                if (i != searchStart + 1 && "(eval)".regionMatches(0, url, i, 6)) {
                    cursor = i + 6;
                    replace = "(eval)";
                }
                if (replace == null) break;
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append(url.substring(0, searchStart));
                }
                sb.append(replace);
            }
            if (sb != null) {
                if (cursor != urlLength) {
                    sb.append(url.substring(cursor));
                }
                url = sb.toString();
            }
        }
        return url;
    }

    private static InputStream openSource(String sourceUrl) throws IOException {
        int hash = sourceUrl.indexOf(35);
        if (hash >= 0) {
            sourceUrl = sourceUrl.substring(0, hash);
        }
        if (sourceUrl.indexOf(58) < 0) {
            try {
                String pathFromHome;
                File f;
                String home;
                if (sourceUrl.startsWith("~/") && (home = System.getProperty("user.home")) != null && (f = new File(new File(home), pathFromHome = sourceUrl.substring(2))).exists()) {
                    return new FileInputStream(f);
                }
                File f2 = new File(sourceUrl);
                if (f2.exists()) {
                    return new FileInputStream(f2);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            sourceUrl = sourceUrl.startsWith("//") ? "http:" + sourceUrl : (sourceUrl.startsWith("/") ? "http://127.0.0.1" + sourceUrl : "http://" + sourceUrl);
        }
        return new URL(sourceUrl).openStream();
    }

    private static String readSource(InputStream is) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        int offset = 0;
        while ((n = is.read(buffer, 0, buffer.length - offset)) >= 0) {
            if ((offset += n) != buffer.length) continue;
            byte[] tmp = new byte[buffer.length * 2];
            System.arraycopy(buffer, 0, tmp, 0, offset);
            buffer = tmp;
        }
        return new String(buffer, 0, offset);
    }

    private SourceInfo registerSource(String sourceUrl, String source) {
        SourceInfo si;
        Hashtable hashtable = this.sourceNames;
        synchronized (hashtable) {
            si = (SourceInfo)this.sourceNames.get(sourceUrl);
            if (si == null) {
                si = new SourceInfo(sourceUrl, source);
                this.sourceNames.put(sourceUrl, si);
            } else {
                si.setSource(source);
            }
        }
        return si;
    }

    private ScriptItem registerScript(SourceInfo si, DebuggableScript fnOrScript) {
        ScriptItem item = new ScriptItem(fnOrScript, si);
        si.updateLineInfo(item);
        this.scriptItems.put(fnOrScript, item);
        String name = fnOrScript.getFunctionName();
        if (name != null && name.length() > 0 && !name.equals("anonymous")) {
            this.functionNames.put(name, item);
        }
        this.loadedFile(si);
        return item;
    }

    void handleBreakpointHit(Context cx) {
        this.breakFlag = false;
        this.interrupted(cx);
    }

    private static String exceptionString(Throwable ex) {
        String msg;
        Throwable wrapped;
        if (ex instanceof JavaScriptException) {
            JavaScriptException jse = (JavaScriptException)ex;
            return ScriptRuntime.toString(jse.getValue());
        }
        if (ex instanceof EcmaError) {
            return ex.toString();
        }
        if (ex instanceof WrappedException && (wrapped = ((WrappedException)ex).getWrappedException()) != null) {
            ex = wrapped;
        }
        if ((msg = ex.toString()) == null || msg.length() == 0) {
            msg = ex.getClass().toString();
        }
        return msg;
    }

    void handleExceptionThrown(Context cx, Throwable ex, FrameHelper frame) {
        if (this.breakOnExceptions) {
            String url = frame.getUrl();
            int lineNumber = frame.getLineNumber();
            FileWindow w = this.getFileWindow(url);
            String msg = Main.exceptionString(ex);
            msg = msg + " (" + url + ", line " + lineNumber + ")";
            if (w != null) {
                Main.swingInvoke(new SetFilePosition(this, w, lineNumber));
            }
            MessageDialogWrapper.showMessageDialog(this, msg, "Exception in Script", 0);
            this.interrupted(cx);
        }
    }

    public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
        return new FrameHelper(cx, this, fnOrScript);
    }

    void init() {
        JButton stepOutButton;
        JButton stepOverButton;
        JButton stepIntoButton;
        JButton goButton;
        JButton breakButton;
        JButton button;
        this.menubar = new Menubar(this);
        this.setJMenuBar(this.menubar);
        this.toolBar = new JToolBar();
        String[] toolTips = new String[]{"Break (Pause)", "Go (F5)", "Step Into (F11)", "Step Over (F7)", "Step Out (F8)"};
        int count = 0;
        JButton focusButton = button = (breakButton = new JButton("Break"));
        button.setToolTipText("Break");
        button.setActionCommand("Break");
        button.addActionListener(this.menubar);
        button.setEnabled(true);
        button.setToolTipText(toolTips[count++]);
        button = goButton = new JButton("Go");
        button.setToolTipText("Go");
        button.setActionCommand("Go");
        button.addActionListener(this.menubar);
        button.setEnabled(false);
        button.setToolTipText(toolTips[count++]);
        button = stepIntoButton = new JButton("Step Into");
        button.setToolTipText("Step Into");
        button.setActionCommand("Step Into");
        button.addActionListener(this.menubar);
        button.setEnabled(false);
        button.setToolTipText(toolTips[count++]);
        button = stepOverButton = new JButton("Step Over");
        button.setToolTipText("Step Over");
        button.setActionCommand("Step Over");
        button.setEnabled(false);
        button.addActionListener(this.menubar);
        button.setToolTipText(toolTips[count++]);
        button = stepOutButton = new JButton("Step Out");
        button.setToolTipText("Step Out");
        button.setActionCommand("Step Out");
        button.setEnabled(false);
        button.addActionListener(this.menubar);
        button.setToolTipText(toolTips[count++]);
        Dimension dim = stepOverButton.getPreferredSize();
        breakButton.setPreferredSize(dim);
        breakButton.setMinimumSize(dim);
        breakButton.setMaximumSize(dim);
        breakButton.setSize(dim);
        goButton.setPreferredSize(dim);
        goButton.setMinimumSize(dim);
        goButton.setMaximumSize(dim);
        stepIntoButton.setPreferredSize(dim);
        stepIntoButton.setMinimumSize(dim);
        stepIntoButton.setMaximumSize(dim);
        stepOverButton.setPreferredSize(dim);
        stepOverButton.setMinimumSize(dim);
        stepOverButton.setMaximumSize(dim);
        stepOutButton.setPreferredSize(dim);
        stepOutButton.setMinimumSize(dim);
        stepOutButton.setMaximumSize(dim);
        this.toolBar.add(breakButton);
        this.toolBar.add(goButton);
        this.toolBar.add(stepIntoButton);
        this.toolBar.add(stepOverButton);
        this.toolBar.add(stepOutButton);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)contentPane, "Center");
        this.desk = new JDesktopPane();
        this.desk.setPreferredSize(new Dimension(600, 300));
        this.desk.setMinimumSize(new Dimension(150, 50));
        this.console = new JSInternalConsole("JavaScript Console");
        this.desk.add(this.console);
        this.context = new ContextWindow(this);
        this.context.setPreferredSize(new Dimension(600, 120));
        this.context.setMinimumSize(new Dimension(50, 50));
        this.split1 = new JSplitPane(0, this.desk, this.context);
        this.split1.setOneTouchExpandable(true);
        Main.setResizeWeight(this.split1, 0.66);
        contentPane.add((Component)this.split1, "Center");
        this.statusBar = new JLabel();
        this.statusBar.setText("Thread: ");
        contentPane.add((Component)this.statusBar, "South");
        this.dlg = new JFileChooser();
        FileFilter filter = new FileFilter(){

            public boolean accept(File f) {
                String ext;
                if (f.isDirectory()) {
                    return true;
                }
                String n = f.getName();
                int i = n.lastIndexOf(46);
                return i > 0 && i < n.length() - 1 && (ext = n.substring(i + 1).toLowerCase()).equals("js");
            }

            public String getDescription() {
                return "JavaScript Files (*.js)";
            }
        };
        this.dlg.addChoosableFileFilter(filter);
        final Main self = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                self.Exit();
            }
        });
    }

    Scriptable getScope() {
        return this.scopeProvider != null ? this.scopeProvider.getScope() : null;
    }

    FileWindow getFileWindow(String url) {
        if (url == null || url.equals("<stdin>")) {
            return null;
        }
        return (FileWindow)this.fileWindows.get(url);
    }

    void loadedFile(SourceInfo si) {
        String fileName = si.getUrl();
        FileWindow w = this.getFileWindow(fileName);
        if (w != null) {
            Main.swingInvoke(UpdateFileText.action(w));
            w.show();
        } else if (!fileName.equals("<stdin>")) {
            Main.swingInvoke(CreateFileWindow.action(this, si, -1));
        }
    }

    static void swingInvoke(Runnable f) {
        if (SwingUtilities.isEventDispatchThread()) {
            f.run();
            return;
        }
        try {
            SwingUtilities.invokeAndWait(f);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    static void swingInvokeLater(Runnable f) {
        try {
            SwingUtilities.invokeLater(f);
        }
        catch (RuntimeException exc) {
            exc.printStackTrace();
        }
    }

    void contextSwitch(int frameIndex) {
        Context cx = this.getCurrentContext();
        ContextData contextData = ContextData.get(cx);
        ContextHelper helper = new ContextHelper();
        helper.attach(cx);
        if (cx != null) {
            int frameCount = contextData.getFrameCount();
            if (frameIndex < 0 || frameIndex >= frameCount) {
                helper.reset();
                return;
            }
            this.frameIndex = frameIndex;
            FrameHelper frame = contextData.getFrame(frameIndex);
            String sourceName = frame.getUrl();
            if (sourceName == null || sourceName.equals("<stdin>")) {
                this.console.show();
                helper.reset();
                return;
            }
            int lineNumber = frame.getLineNumber();
            this.frameIndex = frameIndex;
            FileWindow w = this.getFileWindow(sourceName);
            if (w != null) {
                SetFilePosition action = new SetFilePosition(this, w, lineNumber);
                action.run();
            } else {
                SourceInfo si = frame.getSourceInfo();
                CreateFileWindow.action(this, si, lineNumber).run();
            }
            helper.reset();
        }
    }

    Context getCurrentContext() {
        return this.currentContext;
    }

    /*
     * Unable to fully structure code
     */
    void interrupted(Context cx) {
        block58: {
            var2_2 = this.swingMonitor;
            synchronized (var2_2) {
                block59: {
                    if (!SwingUtilities.isEventDispatchThread()) ** GOTO lbl-1000
                    ++this.dispatcherIsWaiting;
                    if (!this.nonDispatcherWaiting) break block59;
                    eventQ = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    while (this.nonDispatcherWaiting) {
                        try {
                            event = eventQ.getNextEvent();
                            if (event instanceof ActiveEvent) {
                                ((ActiveEvent)event).dispatch();
                            } else {
                                source = event.getSource();
                                if (source instanceof Component) {
                                    comp = (Component)source;
                                    comp.dispatchEvent(event);
                                } else if (source instanceof MenuComponent) {
                                    ((MenuComponent)source).dispatchEvent(event);
                                }
                            }
                            if (this.returnValue == 6) {
                                return;
                            }
                            this.swingMonitor.wait(1L);
                        }
                        catch (InterruptedException exc) {
                            return;
                        }
                    }
                    break block59;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            this.swingMonitor.wait();
                            continue;
                        }
                        catch (InterruptedException exc) {
                            return;
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** while (this.isInterrupted || this.dispatcherIsWaiting > 0)
                    }
lbl35:
                    // 1 sources

                    this.nonDispatcherWaiting = true;
                }
                this.isInterrupted = true;
            }
            this.currentContext = cx;
            contextData = ContextData.get(cx);
            thread = Thread.currentThread();
            this.statusBar.setText("Thread: " + thread.toString());
            state = (ThreadState)this.threadState.get(thread);
            stopAtFrameDepth = -1;
            if (state != null) {
                stopAtFrameDepth = ThreadState.access$000(state);
            }
            if (this.runToCursorFile != null && thread == this.runToCursorThread && (frameCount = contextData.getFrameCount()) > 0 && (url = (frame = contextData.getFrame(0)).getUrl()) != null && url.equals(this.runToCursorFile)) {
                lineNumber = frame.getLineNumber();
                if (lineNumber == this.runToCursorLine) {
                    stopAtFrameDepth = -1;
                    this.runToCursorFile = null;
                } else {
                    w = this.getFileWindow(url);
                    if (w == null || !w.isBreakPoint(lineNumber)) {
                        return;
                    }
                    this.runToCursorFile = null;
                }
            }
            if (stopAtFrameDepth <= 0 || contextData.getFrameCount() <= stopAtFrameDepth) {
                if (state != null) {
                    ThreadState.access$002(state, -1);
                }
                this.threadState.remove(thread);
                frameCount = contextData.getFrameCount();
                this.frameIndex = frameCount - 1;
                line = 0;
                if (frameCount != 0) {
                    frame = contextData.getFrame(0);
                    url = frame.getUrl();
                    contextData.breakNextLine = false;
                    line = frame.getLineNumber();
                    enterCount = 0;
                    isDispatchThread = SwingUtilities.isEventDispatchThread();
                    if (!isDispatchThread) {
                        Context.exit();
                        while (Context.getCurrentContext() != null) {
                            Context.exit();
                            ++enterCount;
                        }
                    }
                    if (url != null && !url.equals("<stdin>")) {
                        w = this.getFileWindow(url);
                        if (w != null) {
                            action = new SetFilePosition(this, w, line);
                            Main.swingInvoke(action);
                        } else {
                            si = frame.getSourceInfo();
                            Main.swingInvoke(CreateFileWindow.action(this, (SourceInfo)si, line));
                        }
                    } else if (this.console.isVisible()) {
                        finalConsole = this.console;
                        Main.swingInvoke(new Runnable(){

                            public void run() {
                                finalConsole.show();
                            }
                        });
                    }
                    Main.swingInvoke(new EnterInterrupt(this, cx));
                    Main.swingInvoke(new UpdateContext(this, cx));
                    if (!isDispatchThread) {
                        si = this.monitor;
                        synchronized (si) {
                            this.returnValue = -1;
                            try {
                                while (this.returnValue == -1) {
                                    this.monitor.wait();
                                }
                                returnValue = this.returnValue;
                            }
                            catch (InterruptedException exc) {
                                break block58;
                            }
                        }
                    }
                    eventQ = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    this.returnValue = -1;
                    while (this.returnValue == -1) {
                        try {
                            event = eventQ.getNextEvent();
                            if (event instanceof ActiveEvent) {
                                ((ActiveEvent)event).dispatch();
                                continue;
                            }
                            source = event.getSource();
                            if (source instanceof Component) {
                                comp = (Component)source;
                                comp.dispatchEvent(event);
                                continue;
                            }
                            if (!(source instanceof MenuComponent)) continue;
                            ((MenuComponent)source).dispatchEvent(event);
                        }
                        catch (InterruptedException exc) {
                            // empty catch block
                        }
                    }
                    returnValue = this.returnValue;
                    Main.swingInvoke(new ExitInterrupt(this));
                    if (!isDispatchThread) {
                        current = Context.enter(cx);
                        if (current != cx) {
                            System.out.println("debugger error: cx = " + cx + " current = " + current);
                        }
                        while (enterCount > 0) {
                            Context.enter();
                            --enterCount;
                        }
                    }
                    switch (returnValue) {
                        case 0: {
                            contextData.breakNextLine = true;
                            stopAtFrameDepth = contextData.getFrameCount();
                            if (state == null) {
                                state = new ThreadState();
                            }
                            ThreadState.access$002(state, stopAtFrameDepth);
                            this.threadState.put(thread, state);
                            break;
                        }
                        case 1: {
                            contextData.breakNextLine = true;
                            if (state == null) break;
                            ThreadState.access$002(state, -1);
                            break;
                        }
                        case 2: {
                            stopAtFrameDepth = contextData.getFrameCount() - 1;
                            if (stopAtFrameDepth <= 0) break;
                            contextData.breakNextLine = true;
                            if (state == null) {
                                state = new ThreadState();
                            }
                            ThreadState.access$002(state, stopAtFrameDepth);
                            this.threadState.put(thread, state);
                            break;
                        }
                        case 5: {
                            contextData.breakNextLine = true;
                            if (state == null) break;
                            ThreadState.access$002(state, -1);
                        }
                    }
                }
            }
        }
        var3_3 = this.swingMonitor;
        synchronized (var3_3) {
            this.isInterrupted = false;
            if (SwingUtilities.isEventDispatchThread()) {
                --this.dispatcherIsWaiting;
            } else {
                this.nonDispatcherWaiting = false;
            }
            this.swingMonitor.notifyAll();
        }
    }

    String chooseFile(String title) {
        int returnVal;
        this.dlg.setDialogTitle(title);
        File CWD = null;
        String dir = System.getProperty("user.dir");
        if (dir != null) {
            CWD = new File(dir);
        }
        if (CWD != null) {
            this.dlg.setCurrentDirectory(CWD);
        }
        if ((returnVal = this.dlg.showOpenDialog(this)) == 0) {
            try {
                String result = this.dlg.getSelectedFile().getCanonicalPath();
                CWD = this.dlg.getSelectedFile().getParentFile();
                Properties props = System.getProperties();
                ((Hashtable)props).put("user.dir", CWD.getPath());
                System.setProperties(props);
                return result;
            }
            catch (IOException ignored) {
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
        }
        return null;
    }

    JInternalFrame getSelectedFrame() {
        JInternalFrame[] frames = this.desk.getAllFrames();
        int i = 0;
        while (i < frames.length) {
            if (frames[i].isShowing()) {
                return frames[i];
            }
            ++i;
        }
        return frames[frames.length - 1];
    }

    void actionPerformed(ActionEvent e) {
        JDialog dlg;
        String cmd = e.getActionCommand();
        int returnValue = -1;
        if (cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste")) {
            JInternalFrame f = this.getSelectedFrame();
            if (f != null && f instanceof ActionListener) {
                ((ActionListener)((Object)f)).actionPerformed(e);
            }
        } else if (cmd.equals("Step Over")) {
            returnValue = 0;
        } else if (cmd.equals("Step Into")) {
            returnValue = 1;
        } else if (cmd.equals("Step Out")) {
            returnValue = 2;
        } else if (cmd.equals("Go")) {
            returnValue = 3;
        } else if (cmd.equals("Break")) {
            this.doBreak();
        } else if (cmd.equals("Run to Cursor")) {
            returnValue = 5;
        } else if (cmd.equals("Exit")) {
            this.Exit();
        } else if (cmd.equals("Open")) {
            String fileName = this.chooseFile("Select a file to compile");
            if (fileName != null) {
                new Thread(new OpenFile(this, fileName)).start();
            }
        } else if (cmd.equals("Load")) {
            Scriptable scope = this.getScope();
            if (scope == null) {
                MessageDialogWrapper.showMessageDialog(this, "Can't run scripts: no scope available", "Run", 0);
            } else {
                String fileName = this.chooseFile("Select a file to execute");
                if (fileName != null) {
                    new Thread(new LoadFile(this, scope, fileName)).start();
                }
            }
        } else if (cmd.equals("More Windows...")) {
            dlg = new MoreWindows(this, this.fileWindows, "Window", "Files");
            ((MoreWindows)dlg).showDialog(this);
        } else if (cmd.equals("Console")) {
            if (this.console.isIcon()) {
                this.desk.getDesktopManager().deiconifyFrame(this.console);
            }
            this.console.show();
            this.desk.getDesktopManager().activateFrame(this.console);
            this.console.consoleTextArea.requestFocus();
        } else if (!(cmd.equals("Cut") || cmd.equals("Copy") || cmd.equals("Paste"))) {
            JInternalFrame[] frames;
            if (cmd.equals("Go to function...")) {
                dlg = new FindFunction(this, this.functionNames, "Go to function", "Function");
                ((FindFunction)dlg).showDialog(this);
            } else if (cmd.equals("Tile")) {
                frames = this.desk.getAllFrames();
                int count = frames.length;
                int cols = (int)Math.sqrt(count);
                int rows = cols;
                if (rows * cols < count && rows * ++cols < count) {
                    ++rows;
                }
                Dimension size = this.desk.getSize();
                int w = size.width / cols;
                int h = size.height / rows;
                int x = 0;
                int y = 0;
                int i = 0;
                while (i < rows) {
                    int j = 0;
                    while (j < cols) {
                        int index = i * cols + j;
                        if (index >= frames.length) break;
                        JInternalFrame f = frames[index];
                        try {
                            f.setIcon(false);
                            f.setMaximum(false);
                        }
                        catch (Exception exc) {
                            // empty catch block
                        }
                        this.desk.getDesktopManager().setBoundsForFrame(f, x, y, w, h);
                        x += w;
                        ++j;
                    }
                    y += h;
                    x = 0;
                    ++i;
                }
            } else if (cmd.equals("Cascade")) {
                frames = this.desk.getAllFrames();
                int count = frames.length;
                int y = 0;
                int x = 0;
                int h = this.desk.getHeight();
                int d = h / count;
                if (d > 30) {
                    d = 30;
                }
                int i = count - 1;
                while (i >= 0) {
                    JInternalFrame f = frames[i];
                    try {
                        f.setIcon(false);
                        f.setMaximum(false);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                    Dimension dimen = f.getPreferredSize();
                    int w = dimen.width;
                    h = dimen.height;
                    this.desk.getDesktopManager().setBoundsForFrame(f, x, y, w, h);
                    --i;
                    x += d;
                    y += d;
                }
            } else {
                FileWindow obj = this.getFileWindow(cmd);
                if (obj != null) {
                    FileWindow w = obj;
                    try {
                        if (w.isIcon()) {
                            w.setIcon(false);
                        }
                        w.setVisible(true);
                        w.moveToFront();
                        w.setSelected(true);
                    }
                    catch (Exception exc) {
                        // empty catch block
                    }
                }
            }
        }
        if (returnValue != -1) {
            if (this.currentWindow != null) {
                this.currentWindow.setPosition(-1);
            }
            Object object = this.monitor;
            synchronized (object) {
                this.returnValue = returnValue;
                this.monitor.notify();
            }
        }
    }

    void runToCursor(String fileName, int lineNumber, ActionEvent evt) {
        SourceInfo si = (SourceInfo)this.sourceNames.get(fileName);
        if (si == null) {
            System.out.println("debugger error: Couldn't find source: " + fileName);
        }
        if (si.breakableLine(lineNumber)) {
            this.runToCursorFile = fileName;
            this.runToCursorLine = lineNumber;
            this.actionPerformed(evt);
        }
    }

    JMenu getWindowMenu() {
        return this.menubar.getMenu(3);
    }

    void removeWindow(FileWindow w) {
        this.fileWindows.remove(w.getUrl());
        JMenu windowMenu = this.getWindowMenu();
        int count = windowMenu.getItemCount();
        JMenuItem lastItem = windowMenu.getItem(count - 1);
        String name = SourceInfo.getShortName(w.getUrl());
        int i = 5;
        while (i < count) {
            int pos;
            String text;
            JMenuItem item = windowMenu.getItem(i);
            if (item != null && (text = item.getText()).substring((pos = text.indexOf(32)) + 1).equals(name)) {
                windowMenu.remove(item);
                if (count == 6) {
                    windowMenu.remove(4);
                    break;
                }
                int j = i - 4;
                while (i < count - 1) {
                    JMenuItem thisItem = windowMenu.getItem(i);
                    if (thisItem != null) {
                        text = thisItem.getText();
                        if (text.equals("More Windows...")) break;
                        pos = text.indexOf(32);
                        thisItem.setText((char)(48 + j) + " " + text.substring(pos + 1));
                        thisItem.setMnemonic(48 + j);
                        ++j;
                    }
                    ++i;
                }
                if (count - 6 != 0 || lastItem == item || !lastItem.getText().equals("More Windows...")) break;
                windowMenu.remove(lastItem);
                break;
            }
            ++i;
        }
        windowMenu.revalidate();
    }

    boolean stringIsCompilableUnit(String expr) {
        Context cx = Context.enter();
        boolean result = cx.stringIsCompilableUnit(expr);
        Context.exit();
        return result;
    }

    String eval(String expr) {
        String resultString;
        Context cx = this.getCurrentContext();
        if (cx == null) {
            return "undefined";
        }
        ContextData contextData = ContextData.get(cx);
        ContextHelper helper = new ContextHelper();
        helper.attach(cx);
        if (this.frameIndex >= contextData.getFrameCount()) {
            helper.reset();
            return "undefined";
        }
        cx.setDebugger(null, null);
        cx.setGeneratingDebug(false);
        cx.setOptimizationLevel(-1);
        boolean savedBreakNextLine = contextData.breakNextLine;
        contextData.breakNextLine = false;
        try {
            Object result;
            Script script;
            int savedLevel = cx.getOptimizationLevel();
            try {
                cx.setOptimizationLevel(-1);
                script = cx.compileString(expr, "", 0, null);
                Object var10_9 = null;
                cx.setOptimizationLevel(savedLevel);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                cx.setOptimizationLevel(savedLevel);
                throw throwable;
            }
            FrameHelper frame = contextData.getFrame(this.frameIndex);
            Scriptable scope = frame.getVariableObject();
            if (scope instanceof NativeCall && script instanceof Function) {
                NativeCall call = (NativeCall)scope;
                Function f = (Function)((Object)script);
                result = f.call(cx, scope, call.getThisObj(), ScriptRuntime.emptyArgs);
            } else {
                result = script.exec(cx, scope);
            }
            if (result == Undefined.instance) {
                result = "";
            }
            try {
                resultString = ScriptRuntime.toString(result);
            }
            catch (RuntimeException exc) {
                resultString = result.toString();
            }
        }
        catch (Exception exc) {
            resultString = exc.getMessage();
        }
        if (resultString == null) {
            resultString = "null";
        }
        cx.setDebugger(this, contextData);
        cx.setGeneratingDebug(true);
        cx.setOptimizationLevel(-1);
        contextData.breakNextLine = savedBreakNextLine;
        helper.reset();
        return resultString;
    }

    void Exit() {
        this.returnValue = 6;
        if (this.exitAction != null) {
            Main.swingInvokeLater(this.exitAction);
        }
    }

    static void setResizeWeight(JSplitPane pane, double weight) {
        try {
            Method m = (class$javax$swing$JSplitPane == null ? (class$javax$swing$JSplitPane = Main.class$("javax.swing.JSplitPane")) : class$javax$swing$JSplitPane).getMethod("setResizeWeight", Double.TYPE);
            m.invoke((Object)pane, new Double(weight));
        }
        catch (NoSuchMethodException exc) {
        }
        catch (IllegalAccessException exc) {
        }
        catch (InvocationTargetException exc) {
            // empty catch block
        }
    }

    boolean shouldDispatchTo(Component source) {
        Component root = SwingUtilities.getRoot(source);
        if (root == this) {
            return true;
        }
        Enumeration e = this.toplevels.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            JFrame frame = (JFrame)this.toplevels.get(key);
            if (root != frame) continue;
            return true;
        }
        return false;
    }

    void addTopLevel(String key, JFrame frame) {
        if (frame != this) {
            this.toplevels.put(key, frame);
        }
    }

    public Main(String title) {
        super(title);
        this.init();
    }

    public void setBreakOnExceptions(boolean value) {
        this.breakOnExceptions = value;
    }

    public void setBreakOnEnter(boolean value) {
        this.breakOnEnter = value;
    }

    public void setBreakOnReturn(boolean value) {
        this.breakOnReturn = value;
    }

    public void clearAllBreakpoints() {
        Enumeration e = this.sourceNames.elements();
        while (e.hasMoreElements()) {
            SourceInfo si = (SourceInfo)e.nextElement();
            si.removeAllBreakpoints();
        }
    }

    public void go() {
        this.returnValue = 3;
        Object object = this.monitor;
        synchronized (object) {
            this.returnValue = this.returnValue;
            this.monitor.notifyAll();
        }
    }

    public void setScopeProvider(ScopeProvider p) {
        this.scopeProvider = p;
    }

    public void setExitAction(Runnable r) {
        this.exitAction = r;
    }

    public InputStream getIn() {
        return this.console.getIn();
    }

    public PrintStream getOut() {
        return this.console.getOut();
    }

    public PrintStream getErr() {
        return this.console.getErr();
    }

    public static void main(String[] args) {
        try {
            mainThread = Thread.currentThread();
            final Main sdb = new Main("Rhino JavaScript Debugger");
            Main.swingInvoke(new Runnable(){

                public void run() {
                    sdb.pack();
                    ((Component)sdb).setSize(600, 460);
                    sdb.setVisible(true);
                }
            });
            sdb.setExitAction(new Runnable(){

                public void run() {
                    System.exit(0);
                }
            });
            System.setIn(sdb.getIn());
            System.setOut(sdb.getOut());
            System.setErr(sdb.getErr());
            Context.addContextListener(sdb);
            sdb.setScopeProvider(new ScopeProvider(){

                public Scriptable getScope() {
                    return org.mozilla.javascript.tools.shell.Main.getScope();
                }
            });
            org.mozilla.javascript.tools.shell.Main.exec(args);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ThreadState {
        private int stopAtFrameDepth = -1;

        ThreadState() {
        }

        static /* synthetic */ int access$000(ThreadState x0) {
            return x0.stopAtFrameDepth;
        }

        static /* synthetic */ int access$002(ThreadState x0, int x1) {
            x0.stopAtFrameDepth = x1;
            return x0.stopAtFrameDepth;
        }
    }
}

