# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("File::Stat", "Object", "class")
aClass.addFragment(Paragraph.new("Objects of class <code>File::Stat</code> encapsulate common status information for <code>File</code> objects. The information is recorded at the moment the <code>File::Stat</code> object is created; changes made to the file after that point will not be reflected. <code>File::Stat</code> objects are returned by <code>IO\#stat</code>, <code>File::stat</code>, <code>File\#lstat</code>, and <code>File::lstat</code>. Many of these methods return platform-specific values, and not all values are meaningful on all systems. See also <code>Kernel\#test</code> on page 429.\n"))
m0002 = MethodDesc.new("<=>", "instance", "<i>statfile</i> <=> <i>anOtherStat</i> -> -1, 0, 1")
m0002.addFragment(Paragraph.new("Compares <code>File::Stat</code> objects by comparing their respective modification times.\n"))
m0002.addFragment(Verbatim.new("f1 = File.new(\"f1\", \"w\")\nsleep 1\nf2 = File.new(\"f2\", \"w\")\nf1.stat <=> f2.stat   \#=> -1\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("atime", "instance", "<i>statfile</i>.atime -> <i>aTime</i>")
m0003.addFragment(Paragraph.new("Returns the last access time for this file as an object of class <code>Time</code>.\n"))
m0003.addFragment(Verbatim.new("File.stat(\"testfile\").atime   \#=> Wed Dec 31 18:00:00 CST 1969\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("blksize", "instance", "<i>statfile</i>.blksize -> <i>anInteger</i>")
m0004.addFragment(Paragraph.new("Returns the native file system's block size. Will return 0 on platforms that don't support this information.\n"))
m0004.addFragment(Verbatim.new("File.stat(\"testfile\").blksize   \#=> 4096\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("blockdev?", "instance", "<i>statfile</i>.blockdev? -> <code>true</code> or <code>false</code>")
m0005.addFragment(Paragraph.new("Returns <code>true</code> if the file is a block device, <code>false</code> if it isn't or if the operating system doesn't support this feature.\n"))
m0005.addFragment(Verbatim.new("File.stat(\"testfile\").blockdev?   \#=> false\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("blocks", "instance", "<i>statfile</i>.blocks -> <i>anInteger</i>")
m0006.addFragment(Paragraph.new("Returns the number of native file system blocks allocated for this file, or 0 if the operating system doesn't support this feature.\n"))
m0006.addFragment(Verbatim.new("File.stat(\"testfile\").blocks   \#=> 2\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("chardev?", "instance", "<i>statfile</i>.chardev? -> <code>true</code> or <code>false</code>")
m0007.addFragment(Paragraph.new("Returns <code>true</code> if the file is a character device, <code>false</code> if it isn't or if the operating system doesn't support this feature.\n"))
m0007.addFragment(Verbatim.new("File.stat(\"/dev/tty\").chardev?   \#=> true\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("ctime", "instance", "<i>statfile</i>.ctime -> <i>aTime</i>")
m0008.addFragment(Paragraph.new("Returns the change time for <i>statfile</i> (that is, the time directory information about the file was changed, not the file itself).\n"))
m0008.addFragment(Verbatim.new("File.stat(\"testfile\").ctime   \#=> Sun Mar 04 23:28:25 CST 2001\n"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("dev", "instance", "<i>statfile</i>.dev -> <i>aFixnum</i>")
m0009.addFragment(Paragraph.new("Returns an integer representing the device on which <i>statfile</i> resides.\n"))
m0009.addFragment(Verbatim.new("File.stat(\"testfile\").dev   \#=> 774\n"))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("directory?", "instance", "<i>statfile</i>.directory? -> <code>true</code> or <code>false</code>")
m0010.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> is a directory, <code>false</code> otherwise.\n"))
m0010.addFragment(Verbatim.new("File.stat(\"testfile\").directory?   \#=> false\nFile.stat(\".\").directory?          \#=> true\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("executable?", "instance", "<i>statfile</i>.executable? -> <code>true</code> or <code>false</code>")
m0011.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> is executable or if the operating system doesn't distinguish executable files from nonexecutable files. The tests are made using the effective owner of the process.\n"))
m0011.addFragment(Verbatim.new("File.stat(\"testfile\").executable?   \#=> false\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("executable_real?", "instance", "<i>statfile</i>.executable_real? -> <code>true</code> or <code>false</code>")
m0012.addFragment(Paragraph.new("Same as <code>executable?</code>, but tests using the real owner of the process.\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("file?", "instance", "<i>statfile</i>.file? -> <code>true</code> or <code>false</code>")
m0013.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> is a regular file (not a device file, pipe, socket, etc.).\n"))
m0013.addFragment(Verbatim.new("File.stat(\"testfile\").file?   \#=> true\n"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("ftype", "instance", "<i>statfile</i>.ftype -> <i>fileType</i>")
m0014.addFragment(Paragraph.new("Identifies the type of <i>statfile</i>. The return string is one of: ``<code>file</code>'', ``<code>directory</code>'', ``<code>characterSpecial</code>'', ``<code>blockSpecial</code>'', ``<code>fifo</code>'', ``<code>link</code>'', or ``<code>socket</code>''.\n"))
m0014.addFragment(Verbatim.new("File.stat(\"/dev/tty\").ftype   \#=> \"characterSpecial\"\n"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("gid", "instance", "<i>statfile</i>.gid -> <i>aFixnum</i>")
m0015.addFragment(Paragraph.new("Returns the numeric group id of the owner of <i>statfile</i>.\n"))
m0015.addFragment(Verbatim.new("File.stat(\"testfile\").gid   \#=> 500\n"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("grpowned?", "instance", "<i>statfile</i>.grpowned? -> <code>true</code> or <code>false</code>")
m0016.addFragment(Paragraph.new("Returns true if the effective group id of the process is the same as the group id of <i>statfile</i>. On Windows NT, returns <code>false</code>.\n"))
m0016.addFragment(Verbatim.new("File.stat(\"testfile\").grpowned?      \#=> true\nFile.stat(\"/etc/passwd\").grpowned?   \#=> false\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("ino", "instance", "<i>statfile</i>.ino -> <i>aFixnum</i>")
m0017.addFragment(Paragraph.new("Returns the inode number for <i>statfile</i>.\n"))
m0017.addFragment(Verbatim.new("File.stat(\"testfile\").ino   \#=> 43331\n"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("mode", "instance", "<i>statfile</i>.mode -> <i>aFixnum</i>")
m0018.addFragment(Paragraph.new("Returns an integer representing the permission bits of <i>statfile</i>. The meaning of the bits is platform dependent; on Unix systems, see <code>stat(2)</code>.\n"))
m0018.addFragment(Verbatim.new("File.chmod(0644, \"testfile\")   \#=> 1\ns = File.stat(\"testfile\")\nsprintf(\"%o\", s.mode)          \#=> \"100644\"\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("mtime", "instance", "<i>statfile</i>.mtime -> <i>aTime</i>")
m0019.addFragment(Paragraph.new("Returns the modification time for <i>statfile</i>.\n"))
m0019.addFragment(Verbatim.new("File.stat(\"testfile\").mtime   \#=> Sun Mar 04 23:28:25 CST 2001\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("nlink", "instance", "<i>statfile</i>.nlink -> <i>aFixnum</i>")
m0020.addFragment(Paragraph.new("Returns the number of hard links to <i>statfile</i>.\n"))
m0020.addFragment(Verbatim.new("File.stat(\"testfile\").nlink             \#=> 1\nFile.link(\"testfile\", \"testfile.bak\")   \#=> 0\nFile.stat(\"testfile\").nlink             \#=> 2\n"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("owned?", "instance", "<i>statfile</i>.owned? -> <code>true</code> or <code>false</code>")
m0021.addFragment(Paragraph.new("Returns <code>true</code> if the effective user id of the process is the same as the owner of <i>statfile</i>.\n"))
m0021.addFragment(Verbatim.new("File.stat(\"testfile\").owned?      \#=> true\nFile.stat(\"/etc/passwd\").owned?   \#=> false\n"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("pipe?", "instance", "<i>statfile</i>.pipe? -> <code>true</code> or <code>false</code>")
m0022.addFragment(Paragraph.new("Returns <code>true</code> if the operating system supports pipes and <i>statfile</i> is a pipe; <code>false</code> otherwise.\n"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("rdev", "instance", "<i>statfile</i>.rdev -> <i>aFixnum</i>")
m0023.addFragment(Paragraph.new("Returns an integer representing the device type on which <i>statfile</i> resides. Returns <code>0</code> if the operating system doesn't support this feature.\n"))
m0023.addFragment(Verbatim.new("File.stat(\"/dev/fd0\").rdev   \#=> 512\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("readable?", "instance", "<i>statfile</i>.readable? -> <code>true</code> or <code>false</code>")
m0024.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> is readable by the effective user id of this process.\n"))
m0024.addFragment(Verbatim.new("File.stat(\"testfile\").readable?   \#=> true\n"))
aClass.addMethod(m0024)
m0025 = MethodDesc.new("readable_real?", "instance", "<i>statfile</i>.readable_real? -> <code>true</code> or <code>false</code>")
m0025.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> is readable by the real user id of this process.\n"))
m0025.addFragment(Verbatim.new("File.stat(\"testfile\").readable_real?   \#=> true\n"))
aClass.addMethod(m0025)
m0026 = MethodDesc.new("setgid?", "instance", "<i>statfile</i>.setgid? -> <code>true</code> or <code>false</code>")
m0026.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> has the set-group-id permission bit set, <code>false</code> if it doesn't or if the operating system doesn't support this feature.\n"))
m0026.addFragment(Verbatim.new("File.stat(\"/usr/sbin/lpc\").setgid?   \#=> true\n"))
aClass.addMethod(m0026)
m0027 = MethodDesc.new("setuid?", "instance", "<i>statfile</i>.setuid? -> <code>true</code> or <code>false</code>")
m0027.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> has the set-user-id permission bit set, <code>false</code> if it doesn't or if the operating system doesn't support this feature.\n"))
m0027.addFragment(Verbatim.new("File.stat(\"/bin/su\").setuid?   \#=> true\n"))
aClass.addMethod(m0027)
m0028 = MethodDesc.new("size", "instance", "<i>statfile</i>.size -> <i>aFixnum</i>")
m0028.addFragment(Paragraph.new("Returns the size of <i>statfile</i> in bytes.\n"))
m0028.addFragment(Verbatim.new("File.stat(\"testfile\").size   \#=> 66\n"))
aClass.addMethod(m0028)
m0029 = MethodDesc.new("size?", "instance", "<i>statfile</i>.size? -> <i>aFixnum</i> or <code>nil</code>")
m0029.addFragment(Paragraph.new("Returns <code>nil</code> if <i>statfile</i> is a zero-length file; otherwise, returns the file size.\n"))
m0029.addFragment(Verbatim.new("File.stat(\"testfile\").size?   \#=> 66\n"))
aClass.addMethod(m0029)
m0030 = MethodDesc.new("socket?", "instance", "<i>statfile</i>.socket? -> <code>true</code> or <code>false</code>")
m0030.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> is a socket, <code>false</code> if it isn't or if the operating system doesn't support this feature.\n"))
m0030.addFragment(Verbatim.new("File.stat(\"testfile\").socket?   \#=> false\n"))
aClass.addMethod(m0030)
m0031 = MethodDesc.new("sticky?", "instance", "<i>statfile</i>.sticky? -> <code>true</code> or <code>false</code>")
m0031.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> has its sticky bit set, <code>false</code> if it doesn't or if the operating system doesn't support this feature.\n"))
m0031.addFragment(Verbatim.new("File.stat(\"testfile\").sticky?   \#=> false\n"))
aClass.addMethod(m0031)
m0032 = MethodDesc.new("symlink?", "instance", "<i>statfile</i>.symlink? -> <code>true</code> or <code>false</code>")
m0032.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> is a symbolic link, <code>false</code> if it isn't or if the operating system doesn't support this feature. As <code>File::stat</code> automatically follows symbolic links, <code>symlink?</code> will always be <code>false</code> for an object returned by <code>File::stat</code>.\n"))
m0032.addFragment(Verbatim.new("File.symlink(\"testfile\", \"alink\")   \#=> 0\nFile.stat(\"alink\").symlink?         \#=> false\nFile.lstat(\"alink\").symlink?        \#=> true\n"))
aClass.addMethod(m0032)
m0033 = MethodDesc.new("uid", "instance", "<i>statfile</i>.uid -> <i>aFixnum</i>")
m0033.addFragment(Paragraph.new("Returns the numeric user id of the owner of <i>statfile</i>.\n"))
m0033.addFragment(Verbatim.new("File.stat(\"testfile\").uid   \#=> 501\n"))
aClass.addMethod(m0033)
m0034 = MethodDesc.new("writable?", "instance", "<i>statfile</i>.writable? -> <code>true</code> or <code>false</code>")
m0034.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> is writable by the effective user id of this process.\n"))
m0034.addFragment(Verbatim.new("File.stat(\"testfile\").writable?   \#=> true\n"))
aClass.addMethod(m0034)
m0035 = MethodDesc.new("writable_real?", "instance", "<i>statfile</i>.writable_real? -> <code>true</code> or <code>false</code>")
m0035.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> is writable by the real user id of this process.\n"))
m0035.addFragment(Verbatim.new("File.stat(\"testfile\").writable_real?   \#=> true\n"))
aClass.addMethod(m0035)
m0036 = MethodDesc.new("zero?", "instance", "<i>statfile</i>.zero? -> <code>true</code> or <code>false</code>")
m0036.addFragment(Paragraph.new("Returns <code>true</code> if <i>statfile</i> is a zero-length file; <code>false</code> otherwise.\n"))
m0036.addFragment(Verbatim.new("File.stat(\"testfile\").zero?   \#=> false\n"))
aClass.addMethod(m0036)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
