
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

#define NUM_LOOKUPS 100000

typedef struct
{
    RHASH_HEADER;
    RBuf *data;
} MyHashEntry;

static unsigned int
hash_compare (const void *rbuf1, const void *rbuf2)
{
    return (rbuf_equal_rbuf (rbuf1, rbuf2));
}


int main (void)
{
    FILE *fp;
    RBuf *keys[1000];
    MyHashEntry *entry;
    RHash *hash;
    char buf[1024];
    int i, a, num_entries = 0;

    rinit ();

    hash = rhash_new ((RHashHashFunction) rbuf_hash2, hash_compare);

    fp = fopen ("sample-keys.txt", "r");
    if (!fp) {
        printf ("Unable to open file 'sample-keys.txt', exiting\n");
        exit (1);
    }

    while (fgets (buf, sizeof (buf), fp)) {
        RBuf *rbuf;
        
        buf[strlen (buf) - 1] = '\0';

        entry = rchunk_alloc (sizeof (MyHashEntry));
        keys[num_entries] = rbuf_new_with_str (buf);
        
        rbuf = rbuf_new_with_str (buf);
        entry->data = rbuf;

        rhash_insert (hash, entry, rbuf);

        num_entries++;
    }

    printf ("Using %d entries from sample-keys.txt.  Will lookup each %d times (%d lookups)\n", 
        num_entries, NUM_LOOKUPS, num_entries * NUM_LOOKUPS);

    for (a = 0; a < NUM_LOOKUPS; a++) {
        for (i = 0; i < num_entries; i++) {
            entry = rhash_lookup (hash, keys[i]);
            if (!entry)
                printf ("lookup for key %s, returned NULL!!!\n", rbuf_str (keys[i]));
		/*if (!rbuf_equal_rbuf (entry->key, keys[i]))
		  printf ("lookup returned wrong string!\n"); */

        }
    }

    for (i = 0; i < num_entries; i++) {
        rbuf_free (keys[i]);
    }

    entry = rhash_lookup (hash, rbuf_auto ("name"));
    printf ("entry for 'name' returned '%s'\n", rbuf_str (entry->data));

    a = 0;

    /* Destruct the hash table entries */
    RHASH_FOREACH (hash, entry) {

        /* It's not actually necessary to remove every entry
         * if you are just freeing the whole hash table, but
         * we do it anyway to demonstrate. */
        rhash_remove_entry (hash, entry);

        rbuf_free (entry->data);
        rchunk_free (entry, sizeof (MyHashEntry));
        a++;
    } RFOREACH_CLOSE;

    printf ("num entries: %d, num walked: %d\n", num_entries, a);

    /* Test duplicate keys */
    for (i = 0; i < 10; i++) {
        RBuf *rbuf;

        entry = rchunk_alloc (sizeof (MyHashEntry));
        rbuf = rbuf_new_with_sprintf ("Key %d", i);
        entry->data = rbuf;
        rbuf = rbuf_new_with_str ("somekey");
        rhash_insert (hash, entry, rbuf);
    }

    entry = rhash_lookup (hash, rbuf_auto ("somekey"));

    while (entry) {
        printf ("entry %s\n", rbuf_str (entry->data));
        entry = rhash_lookup_next (hash, entry, rbuf_auto ("somekey"));
    }

    RHASH_FOREACH (hash, entry) {
        rbuf_free (entry->data);
        rbuf_free (rhash_entry_getkey (entry));
        rchunk_free (entry, sizeof (MyHashEntry));
    } RFOREACH_CLOSE;

    /* Free the hash table */
    rhash_free (hash);

    rcleanup ();

    return (0);
}


