
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

#define USE_CHUNKS 1

#ifdef USE_CHUNKS
#define ALLOC(size) rchunk_alloc (size)
#define FREE(ptr, size) rchunk_free (ptr, size)

#else

#define ALLOC(size) rmem_alloc (size)
#define FREE(ptr, size) rmem_free (ptr)

#endif


typedef struct {
    RLIST_HEADER;
    int id;
    int id2;
} MyInfo;

int main (void)
{
    MyInfo *info;
    RList *list;
    int i, a;

    rinit ();

    list = rlist_new ();

    for (a = 0; a < 2000; a++) {
        for (i = 0; i < 2000; i++) {
            info = ALLOC (sizeof (MyInfo));
            info->id = i;
            info->id2 = i * i;
            rlist_append (list, info);
        }

        RLIST_FOREACH (list, info) {
            /* printf ("freeing/deleting list num %d\n", info->id); */
            info->id++;
            info->id2++;
            rlist_remove (list, info);
            FREE (info, sizeof (MyInfo));
        } RFOREACH_CLOSE;

    }

    rlist_free (list);

    rcleanup ();

    return (0);
}


