// -*- objc -*-

#import "HTTPFetcher.h"

@implementation HTTPFetcher

-initWithURL: (NSString*) url
{
  [super init];
  myUrl = [[NSURL alloc] initWithString: url];
  return self;
}

-init
{
  RELEASE(self);
  return nil;
}

-initWithNSURL: (NSURL*) url
{
  [super init];
  myUrl = RETAIN(url);
  return self;
}

-dealloc
{
  RELEASE(myUrl);
  [super dealloc];
}

-(id)initWithCoder: (NSCoder*)coder
{
  if (self = [self initWithNSURL: [coder decodeObject]])
    NSLog(@"HTTPFetcher (rc=%i) initialized with %@",
	  [self retainCount], [myUrl description]);
  
  return self;
}

-(void)encodeWithCoder: (NSCoder*)coder
{
  NSLog(@"HTTPFetcher encodeWithCoder");
  [coder encodeObject: myUrl];
}


// FIXME: Not fully functional!
-(NSString*) fetch
{
  NSURLHandle* handle;
  NSData*      resultData;
  
  printf("Could init NSURLHandle with URL %s\n", [[myUrl description] cString]);
  
  // autoreleased, i hope...
  handle = [myUrl URLHandleUsingCache: NO];
  
  resultData = [handle resourceData];
  
  return
    AUTORELEASE([[NSString alloc] initWithData:resultData
				  encoding: NSASCIIStringEncoding]);
}

@end
