/*
*  Rubrica
*  file: form_int.c
*
*  
*  Copyright (C) 2000-2003 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#include <gnome.h>

#include "form_cb.h"
#include "form_card.h"
#include "ui.h"
#include "rubrica_type.h"
#include "utils.h"


GtkWidget *card_form = NULL;

RubricaOptionType options[] = {
  {"",                 N_("no group"),      NO_GROUP},
  {"favorites.png",    N_("favorites"),     FAVORITES_GROUP},
  {"hot-contacts.png", N_("hot contact"),   HOT_GROUP},
  {"friends.png",      N_("friends"),       FRIENDS_GROUP},
  {"heart.png",        N_("heart"),         HEART_GROUP},
  {"home.png",         N_("relatives"),     RELATIVES_GROUP},
  {"holiday.png",      N_("holidays"),      HOLIDAYS_GROUP},
  {"hobby.png",        N_("hobbies"),       HOBBIES_GROUP},
  {"football.png",     N_("sport"),         SPORT_GROUP},
  {"money.png",        N_("bussines"),      BUSSINES_GROUP},
  {"company2.png",     N_("company"),       COMPANY_GROUP},
  {"genius.png",       N_("work"),          WORK_GROUP},
  {"customer.png",     N_("customer"),      CUSTOMER_GROUP},
  {"strategies.png",   N_("strategies"),    STRATEGIES_GROUP},
  {"penguin.png",      N_("programmers"),   PROGRAMMERS_GROUP},
  {"freebsd.png",      N_("BSD friends"),   BSD_GROUP},
  {"pj.png",           N_("journal"),       PLUTO_GROUP},
  {NULL, NULL}
};



gchar *rubrica_form_get_option_label(gint index)
{
  gint option_len;

  if (index < 0)
    return g_strdup("");

  option_len = rubrica_utils_option_len(options);

  if (index <= option_len)
    return g_strdup(options[index].label);

  return g_strdup("");
}


gchar *rubrica_form_get_option_pixmap(gint index)
{
  gint option_len;  

  option_len = rubrica_utils_option_len(options);

  if ((index > 0) && (index < option_len))
    return (gchar *) options[index].pixmap;
  
  return NULL;
}

RubricaCategoriesType rubrica_form_get_option_type(gchar *label)
{
  gint option_len, i;
  
  g_return_val_if_fail(label != NULL, NO_GROUP);

  if (strcmp(label, "") == 0)
    return NO_GROUP;

  i = 0;
  option_len = rubrica_utils_option_len(options);

  while(i < option_len)
    {
      if (strcmp(options[i].label, label) == 0)
	return (RubricaCategoriesType) options[i].type;
      
      i++;
    }

  return (RubricaCategoriesType) NO_GROUP;
}

GtkTreeModel *rubrica_form_create_model(RubricaModelType type)
{
  GtkListStore *model = NULL;
  
  switch (type)
    {
    case NET_MODEL:
      model = gtk_list_store_new(LAST_NET_COLUMN, G_TYPE_STRING);
      break;

    case TELEPHONE_MODEL:
      model = gtk_list_store_new(LAST_TEL_COLUMN, 
				 G_TYPE_STRING,
				 G_TYPE_STRING);
      break;
      
    default:
      break;
    }

  return GTK_TREE_MODEL(model);
}



GtkWidget *rubrica_form_create_card_data_page(RubricaCardForm *form)
{
  GtkWidget *data_frame;

  GtkWidget *data_box;
  GtkWidget *card_frame;
  GtkWidget *card_box;
  GtkWidget *option_box;
  GtkWidget *name_frame;
  GtkWidget *name_box;
  GtkWidget *name_table;
  GtkWidget *address_frame;
  GtkWidget *address_box;
  GtkWidget *address_table;

  g_return_val_if_fail(form != NULL, NULL);

  data_frame = rubrica_ui_frame_new(_("Personal Data"));

  data_box   = rubrica_ui_pack_in_frame_new_box(data_frame, VBOX, FALSE, 0, 2);
  card_frame = rubrica_ui_pack_in_box_new_frame(data_box, _("Cards"), TRUE);
  card_box   = rubrica_ui_pack_in_frame_new_box(card_frame, VBOX, FALSE, 0, 2);
    
  form->card = rubrica_ui_pack_in_box_boxed_label_entry_pix_new(card_box, 
								HBOX, FALSE,
								_("Card"), 
								"schede.png", 
								FALSE, TRUE);

  option_box = rubrica_ui_box_new(HBOX, FALSE, 0, 2);  
  gtk_box_pack_start(GTK_BOX(card_box), option_box, FALSE, FALSE, 0);

  form->delete = rubrica_ui_pack_in_box_check_button_new(option_box, 
							 _("_deleting card"));
  form->option = rubrica_ui_pack_in_box_boxed_label_option_menu_new(option_box,
								    _("Categories"), 
								    options,
								    HBOX, 
								    TRUE);

  name_frame = rubrica_ui_pack_in_box_new_frame(data_box, _("Name"), TRUE);
  name_box   = rubrica_ui_pack_in_frame_new_box(name_frame, VBOX, FALSE, 0, 2);
  rubrica_ui_pack_in_box_image_new(name_box, "testa.png", TRUE);
  name_table =rubrica_ui_pack_in_box_table_new(name_box, 6, 4, FALSE, 2, 2, 4);

  rubrica_ui_tabled_label_new(name_table, _("First name"),  0, 1, 0, 1);
  rubrica_ui_tabled_label_new(name_table, _("Middle name"), 0, 1, 1, 2);
  rubrica_ui_tabled_label_new(name_table, _("Last name"),   0, 1, 2, 3);
  rubrica_ui_tabled_label_new(name_table, _("Profession"),  0, 1, 3, 4);
  rubrica_ui_tabled_label_new(name_table, _("Name Prefix"), 2, 3, 3, 4);  
  rubrica_ui_tabled_label_new(name_table, _("Title"),       0, 1, 4, 5);

  form->personal.first  = rubrica_ui_tabled_entry_new(name_table, 1, 4, 0, 1);
  form->personal.middle = rubrica_ui_tabled_entry_new(name_table, 1, 4, 1, 2);
  form->personal.last   = rubrica_ui_tabled_entry_new(name_table, 1, 4, 2, 3);
  form->personal.profession = rubrica_ui_tabled_entry_new(name_table, 1, 2, 3, 4);
  form->personal.prefix = rubrica_ui_tabled_entry_new(name_table, 3, 4, 3, 4);
  form->personal.title  = rubrica_ui_tabled_entry_new(name_table, 1, 2, 4, 5);

  form->personal.birthknow = rubrica_ui_tabled_check_new(name_table,_("Birthday"), 2, 3, 4, 5);
  form->personal.date = rubrica_ui_tabled_date_new(name_table, 3, 4, 4, 5);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->personal.birthknow), 
			       FALSE);
  gtk_widget_set_sensitive(form->personal.date, FALSE);
  
  address_frame = rubrica_ui_pack_in_box_new_frame(data_box, _("Address"), 
						   FALSE);
  address_box   = rubrica_ui_pack_in_frame_new_box(address_frame, VBOX, FALSE, 0, 2);

  rubrica_ui_pack_in_box_image_new(address_box, "street.png", TRUE);
  address_table = rubrica_ui_pack_in_box_table_new(address_box, 5, 4, FALSE, 2, 2, 4);

  rubrica_ui_tabled_label_new(address_table, _("Street"),   0, 1, 0, 1);
  rubrica_ui_tabled_label_new(address_table, _("Number"),   0, 1, 1, 2);
  rubrica_ui_tabled_label_new(address_table, _("Zip code"), 2, 3, 1, 2);
  rubrica_ui_tabled_label_new(address_table, _("City"),     0, 1, 2, 3);
  rubrica_ui_tabled_label_new(address_table, _("Province"), 2, 3, 2, 3);
  rubrica_ui_tabled_label_new(address_table, _("State"),    0, 1, 3, 4);
  rubrica_ui_tabled_label_new(address_table, _("Country"),  2, 3, 3, 4);

  form->address.street   = rubrica_ui_tabled_entry_new(address_table, 1, 4, 0, 1);
  form->address.number   = rubrica_ui_tabled_entry_new(address_table, 1, 2, 1, 2);
  form->address.zip      = rubrica_ui_tabled_entry_new(address_table, 3, 4, 1, 2);
  form->address.city     = rubrica_ui_tabled_entry_new(address_table, 1, 2, 2, 3);
  form->address.province = rubrica_ui_tabled_entry_new(address_table, 3, 4, 2, 3);
  form->address.state    = rubrica_ui_tabled_entry_new(address_table, 1, 2, 3, 4);
  form->address.country  = rubrica_ui_tabled_entry_new(address_table, 3, 4, 3, 4);

  g_signal_connect(G_OBJECT(form->personal.birthknow), "toggled", 
		   G_CALLBACK(option_check_toggled), form->personal.date);   
		   
  return data_frame;
}


GtkWidget *rubrica_form_create_card_net_page(RubricaCardForm *form)
{
  GtkWidget *net_frame;

  GtkWidget *net_box;
  GtkWidget *web_frame;
  GtkWidget *web_box;
  GtkWidget *email_frame;
  GtkWidget *email_box;
  GtkWidget *web_address_box;
  GtkWidget *email_address_box;
  GtkWidget *web_list_box;
  GtkWidget *web_buttonbox;
  GtkWidget *email_list_box;
  GtkWidget *email_buttonbox;
  GtkWidget *wbox, *ebox;
  GtkWidget *label;
  GtkWidget *image;

  GtkTreeModel *model;
  GtkTreeSelection *selection;


  net_frame   = rubrica_ui_frame_new(_("Net Addresses"));
  net_box     = rubrica_ui_pack_in_frame_new_box(net_frame, VBOX, TRUE, 0, 2);

  /*    WEB LIST
  */
  web_frame = rubrica_ui_frame_new(_("Web"));
  gtk_box_pack_start(GTK_BOX(net_box), web_frame, TRUE, TRUE, 2);

  web_box   = rubrica_ui_box_new(VBOX, FALSE, 2, 2);
  gtk_container_add(GTK_CONTAINER(web_frame), web_box);

  web_address_box = rubrica_ui_box_new(HBOX, FALSE, 2, 2);
  gtk_box_pack_start(GTK_BOX(web_box), web_address_box, TRUE, TRUE, 2);

  wbox = rubrica_ui_box_new(HBOX, FALSE, 2, 2);
  gtk_box_pack_start(GTK_BOX(web_address_box), wbox, TRUE, TRUE, 2);

  label  = rubrica_ui_label_new(_("Web address"));
  image = rubrica_ui_image_new("internet.png");
  form->net.web = rubrica_ui_entry_new();

  gtk_box_pack_start(GTK_BOX(wbox), label, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(wbox), form->net.web, TRUE, TRUE, 2);
  gtk_box_pack_start(GTK_BOX(wbox), image, FALSE, FALSE, 2);

  web_list_box = rubrica_ui_box_new(HBOX, FALSE, 0, 2);
  gtk_box_pack_start(GTK_BOX(web_box), web_list_box, TRUE, TRUE, 2);

  web_buttonbox = rubrica_ui_buttonbox_new(VBOX);
  gtk_box_pack_start(GTK_BOX(web_list_box), web_buttonbox, FALSE, FALSE, 2);
  
  form->net.web_add = rubrica_ui_pixbutton_new(_("_Add"),    "add.png");
  form->net.web_mod = rubrica_ui_pixbutton_new(_("_Modify"), "mod.png");
  form->net.web_del = rubrica_ui_pixbutton_new(_("_Delete"), "remove.png");

  gtk_box_pack_start(GTK_BOX(web_buttonbox), form->net.web_add, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(web_buttonbox), form->net.web_mod, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(web_buttonbox), form->net.web_del, FALSE, FALSE, 2);

  /*    desensibilizzo i bottoni modifica e cancella,
  */
  gtk_widget_set_sensitive(GTK_WIDGET(form->net.web_mod), FALSE);
  gtk_widget_set_sensitive(GTK_WIDGET(form->net.web_del), FALSE); 

  model = rubrica_form_create_model(NET_MODEL);
  form->net.web_tree = rubrica_ui_pack_in_box_tree_view_new_with_model(web_list_box, model);
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(form->net.web_tree));
  gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE);

  rubrica_ui_add_columns(GTK_TREE_VIEW(form->net.web_tree), WEB_COLUMNS);

  g_signal_connect(G_OBJECT(selection), "changed", 
		   G_CALLBACK(rubrica_form_web_list_activated), form);
  
  /*    EMAIL LIST
  */
  email_frame = rubrica_ui_frame_new(_("Email"));
  gtk_box_pack_start(GTK_BOX(net_box), email_frame, TRUE, TRUE, 2);
  
  email_box = rubrica_ui_box_new(VBOX, FALSE, 2, 2);
  gtk_container_add(GTK_CONTAINER(email_frame), email_box);

  email_address_box = rubrica_ui_box_new(HBOX, FALSE, 2, 2);
  gtk_box_pack_start(GTK_BOX(email_box), email_address_box, TRUE, TRUE, 2);

  ebox = rubrica_ui_box_new(HBOX, FALSE, 2, 2);
  gtk_box_pack_start(GTK_BOX(email_address_box), ebox, TRUE, TRUE, 2);

  label  = rubrica_ui_label_new(_("Email address"));
  image = rubrica_ui_image_new("email.png");
  form->net.email = rubrica_ui_entry_new();

  gtk_box_pack_start(GTK_BOX(ebox), label, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(ebox), form->net.email, TRUE, TRUE, 2);
  gtk_box_pack_start(GTK_BOX(ebox), image, FALSE, FALSE, 2);

  email_list_box  = rubrica_ui_box_new(HBOX, FALSE, 0, 2);
  gtk_box_pack_start(GTK_BOX(email_box), email_list_box, TRUE, TRUE, 2);

  email_buttonbox = rubrica_ui_buttonbox_new(VBOX);
  gtk_box_pack_start(GTK_BOX(email_list_box), email_buttonbox, FALSE, FALSE, 2);
  
  form->net.email_add = rubrica_ui_pixbutton_new(_("_Add"),    "add.png");
  form->net.email_mod = rubrica_ui_pixbutton_new(_("_Modify"), "mod.png");
  form->net.email_del = rubrica_ui_pixbutton_new(_("_Delete"), "remove.png");

  gtk_box_pack_start(GTK_BOX(email_buttonbox), form->net.email_add, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(email_buttonbox), form->net.email_mod, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(email_buttonbox), form->net.email_del, FALSE, FALSE, 2);

  /*    desensibilizzo i bottoni modifica e cancella
  */
  gtk_widget_set_sensitive(GTK_WIDGET(form->net.email_mod), FALSE);
  gtk_widget_set_sensitive(GTK_WIDGET(form->net.email_del), FALSE); 

  model = rubrica_form_create_model(NET_MODEL);
  form->net.email_tree  = rubrica_ui_pack_in_box_tree_view_new_with_model(email_list_box, 
									   model); 
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(form->net.email_tree));
  gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE);

  rubrica_ui_add_columns(GTK_TREE_VIEW(form->net.email_tree), EMAIL_COLUMNS);
  
  g_signal_connect(G_OBJECT(selection), "changed", 
		   G_CALLBACK(rubrica_form_email_list_activated), form);


  /*    
   *	FUNZIONI DI CALLBACK
   */

  /*    entry web, email
  */
  g_signal_connect (G_OBJECT (form->net.web), "activate", 
		    G_CALLBACK (entry_activate), form->net.web_add); 
  g_signal_connect (G_OBJECT (form->net.email), "activate", 
		    G_CALLBACK (entry_activate), form->net.email_add); 

  /*    bottoni web
  */
  g_signal_connect (G_OBJECT (form->net.web_add), "clicked", 
		    G_CALLBACK (web_add_clicked), RUBRICA_CARD(form)); 
  g_signal_connect (G_OBJECT (form->net.web_mod), "clicked", 
		    G_CALLBACK (web_mod_clicked), RUBRICA_CARD(form)); 
  g_signal_connect (G_OBJECT (form->net.web_del), "clicked", 
		    G_CALLBACK (web_del_clicked), RUBRICA_CARD(form)); 

  /*    bottoni mail
  */
  g_signal_connect (G_OBJECT (form->net.email_add), "clicked",
		    G_CALLBACK (email_add_clicked), RUBRICA_CARD(form));
  g_signal_connect (G_OBJECT (form->net.email_mod), "clicked",
		    G_CALLBACK (email_mod_clicked), RUBRICA_CARD(form));
  g_signal_connect (G_OBJECT (form->net.email_del), "clicked",
		    G_CALLBACK (email_del_clicked), RUBRICA_CARD(form));

  return (GtkWidget *) net_frame;
}


GtkWidget *rubrica_form_create_card_telephone_page(RubricaCardForm *form)
{
  GtkWidget *frame;
  GtkWidget *tel_box;
  GtkWidget *number_frame;
  GtkWidget *number_box;
  GtkWidget *list_box;
  GtkWidget *type_frame;
  GtkWidget *type_table;
  GtkWidget *list_frame;
  GtkWidget *tel_buttonbox;
  GtkWidget *box;
  GtkWidget *label;
  GtkWidget *image;

  GtkTreeSelection *selection;
  GtkTreeModel *model;
  

  model = GTK_TREE_MODEL(gtk_list_store_new(LAST_TEL_COLUMN, G_TYPE_STRING, G_TYPE_STRING));

  frame   = rubrica_ui_frame_new(_("Telephone Infos"));
  tel_box = rubrica_ui_pack_in_frame_new_box(frame, VBOX, FALSE, 0, 2);
  
  number_frame = rubrica_ui_pack_in_box_new_frame(tel_box, _("Telephone Number"), TRUE);
  number_box   = rubrica_ui_pack_in_frame_new_box(number_frame, HBOX, FALSE, 0, 2);

  box = rubrica_ui_box_new(HBOX, FALSE, 2, 2);
  gtk_box_pack_start(GTK_BOX(number_box), box, TRUE, TRUE, 2);

  label  = rubrica_ui_label_new(_("Number"));
  image = rubrica_ui_image_new("telefono.png");
  form->tel.number = rubrica_ui_entry_new();

  gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(box), form->tel.number, TRUE, TRUE, 2);
  gtk_box_pack_start(GTK_BOX(box), image, FALSE, FALSE, 2);
 
  list_box   = rubrica_ui_pack_in_frame_new_box(tel_box, HBOX, FALSE, 0, 2);
  type_frame = rubrica_ui_pack_in_box_new_frame(list_box, _("Telephone Type"), TRUE);
  type_table = rubrica_ui_table_new(5, 2, FALSE, 2, 2, 2);
  gtk_container_add(GTK_CONTAINER(type_frame), type_table);

  rubrica_ui_tabled_pixmap_new(type_table, "casa.png", 0, 1, 0, 1);
  rubrica_ui_tabled_pixmap_new(type_table, "work.png", 0, 1, 1, 2);
  rubrica_ui_tabled_pixmap_new(type_table, "fax.png",  0, 1, 2, 3);
  rubrica_ui_tabled_pixmap_new(type_table, "cellulare.png", 0, 1, 3, 4);
  rubrica_ui_tabled_pixmap_new(type_table, "altrotel.png",  0, 1, 4, 5);

  form->tel.group = NULL;
  form->tel.radiohome  = rubrica_ui_tabled_radio_new(type_table, form->tel.group, 
						  _("Home telephone"), 1, 2, 0, 1);

  form->tel.group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (form->tel.radiohome));
  form->tel.radiowork  = rubrica_ui_tabled_radio_new(type_table, form->tel.group, 
						  _("Work telephone"), 1, 2, 1, 2);
  
  form->tel.group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (form->tel.radiohome));
  form->tel.radiofax   = rubrica_ui_tabled_radio_new(type_table, form->tel.group, 
						  _("Fax telephone"), 1, 2, 2, 3);

  form->tel.group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (form->tel.radiohome));
  form->tel.radiocell  = rubrica_ui_tabled_radio_new(type_table, form->tel.group, 
						  _("Cellphone"), 1, 2, 3, 4);

  form->tel.group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (form->tel.radiohome));
  form->tel.radioother = rubrica_ui_tabled_radio_new(type_table, form->tel.group, 
						  _("Other telephone"), 1, 2, 4, 5);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (form->tel.radiohome), TRUE);

  list_frame = rubrica_ui_frame_new(_("Telephone List"));
  gtk_box_pack_start(GTK_BOX(list_box), list_frame, TRUE, TRUE, 2);
  
//  model = rubrica_form_create_model(TELEPHONE_MODEL);
  form->tel.tree = rubrica_ui_pack_in_frame_tree_view_new_with_model(list_frame, model); 
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(form->tel.tree));
  gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE); 

  rubrica_ui_add_columns(GTK_TREE_VIEW(form->tel.tree), TELEPHONE_COLUMNS);

  tel_buttonbox = rubrica_ui_buttonbox_new(HBOX);
  gtk_box_pack_start(GTK_BOX(tel_box), tel_buttonbox, FALSE, 2, 2);

  form->tel.tel_add = rubrica_ui_pixbutton_new(_("_Add"),    "add.png");
  form->tel.tel_mod = rubrica_ui_pixbutton_new(_("_Modify"), "mod.png");
  form->tel.tel_del = rubrica_ui_pixbutton_new(_("_Delete"), "remove.png");
  
  gtk_box_pack_start(GTK_BOX(tel_buttonbox), form->tel.tel_add, FALSE, 2, 2);
  gtk_box_pack_start(GTK_BOX(tel_buttonbox), form->tel.tel_mod, FALSE, 2, 2);
  gtk_box_pack_start(GTK_BOX(tel_buttonbox), form->tel.tel_del, FALSE, 2, 2);

  gtk_widget_set_sensitive(GTK_WIDGET(form->tel.tel_mod), FALSE);
  gtk_widget_set_sensitive(GTK_WIDGET(form->tel.tel_del), FALSE);  

  /*
   * COLLEGAMENTO A FUNZIONI CALLBACK
   */
  g_signal_connect(G_OBJECT(selection), "changed", 
		   G_CALLBACK(rubrica_form_telephone_list_activated), form);
  
  g_signal_connect (G_OBJECT (form->tel.number), "activate", 
		    G_CALLBACK (entry_activate), form->tel.tel_add);

  g_signal_connect (G_OBJECT (form->tel.tel_add), "clicked", 
		    G_CALLBACK (tel_add_clicked), RUBRICA_CARD(form)); 
  g_signal_connect (G_OBJECT (form->tel.tel_mod), "clicked", 
		    G_CALLBACK (tel_mod_clicked), RUBRICA_CARD(form)); 
  g_signal_connect (G_OBJECT (form->tel.tel_del), "clicked", 
		    G_CALLBACK (tel_del_clicked), RUBRICA_CARD(form)); 

  return (GtkWidget *) frame;  
}

GtkWidget *rubrica_form_create_card_job_page(RubricaCardForm *form)
{
  GtkWidget *work_frame;

  GtkWidget *work_box;
  GtkWidget *company_frame;
  GtkWidget *info_box;
  GtkWidget *company_table;
  GtkWidget *assign_frame;
  GtkWidget *assign_box;
  GtkWidget *assign_table;

  work_frame = rubrica_ui_frame_new(_("Work"));
  work_box   = rubrica_ui_pack_in_frame_new_box(work_frame, VBOX, FALSE, 0,2);
  company_frame = rubrica_ui_pack_in_box_new_frame(work_box, _("Company Infos"), TRUE);

  info_box = rubrica_ui_pack_in_frame_new_box(company_frame, VBOX, FALSE, 0, 2);
  rubrica_ui_pack_in_box_image_new(info_box, "puzzle.png", TRUE);

  company_table = rubrica_ui_table_new(8, 4, FALSE, 2, 2, 2);
  gtk_box_pack_start(GTK_BOX(info_box), company_table, FALSE, 0, 0);

  rubrica_ui_tabled_label_new(company_table, _("Company name"),  0, 1, 0, 1);
  rubrica_ui_tabled_label_new(company_table, _("Street"),        0, 1, 1, 2);
  rubrica_ui_tabled_label_new(company_table, _("Street number"), 2, 3, 1, 2);
  rubrica_ui_tabled_label_new(company_table, _("Zip code"),      0, 1, 2, 3);
  rubrica_ui_tabled_label_new(company_table, _("City"),          2, 3, 2, 3);
  rubrica_ui_tabled_label_new(company_table, _("Province"),      0, 1, 3, 4);
  rubrica_ui_tabled_label_new(company_table, _("Country"),       2, 3, 3, 4);
  rubrica_ui_tabled_label_new(company_table, _("Web Page"),      0, 1, 4, 5);
  rubrica_ui_tabled_label_new(company_table, _("Email"),         2, 3, 4, 5);
  rubrica_ui_tabled_label_new(company_table, _("Operator"),      0, 1, 5, 6);
  rubrica_ui_tabled_label_new(company_table, _("Fax"),           2, 3, 5, 6);
  rubrica_ui_tabled_label_new(company_table, _("Notes"),         0, 1, 7, 8);
  rubrica_ui_tabled_label_new(company_table, _("Green"),         0, 1, 6, 7);
  rubrica_ui_tabled_label_new(company_table, _("Customer care"), 2, 3, 6, 7);

  form->company.name  = rubrica_ui_tabled_entry_new(company_table, 1, 4, 0, 1);
  form->company.street = rubrica_ui_tabled_entry_new(company_table, 
						     1, 2, 1, 2);
  form->company.number = rubrica_ui_tabled_entry_new(company_table,
						     3, 4, 1, 2);
  form->company.zip   = rubrica_ui_tabled_entry_new(company_table, 1, 2, 2, 3);
  form->company.city  = rubrica_ui_tabled_entry_new(company_table, 3, 4, 2, 3);
  form->company.province = rubrica_ui_tabled_entry_new(company_table, 
						       1, 2, 3, 4);
  form->company.country  = rubrica_ui_tabled_entry_new(company_table,
						       3, 4, 3, 4);
  form->company.web   = rubrica_ui_tabled_entry_new(company_table, 1, 2, 4, 5);
  form->company.email = rubrica_ui_tabled_entry_new(company_table, 3, 4, 4, 5);
  form->company.operator = rubrica_ui_tabled_entry_new(company_table, 
						       1, 2, 5, 6);
  form->company.fax   = rubrica_ui_tabled_entry_new(company_table, 3, 4, 5, 6);
  form->company.green = rubrica_ui_tabled_entry_new(company_table, 1, 2, 6, 7);
  form->company.customer_care = rubrica_ui_tabled_entry_new(company_table,
							    3, 4, 6, 7);
  form->company.notes    = rubrica_ui_text_view_new();
  rubrica_ui_tabled_text_view(company_table, form->company.notes, 1, 4, 7, 8);

  assign_frame = rubrica_ui_pack_in_box_new_frame(work_box, _("Assigment"),
						  TRUE);
  assign_box   = rubrica_ui_pack_in_frame_new_box(assign_frame, VBOX, 
						  FALSE, 0, 2);
  rubrica_ui_pack_in_box_image_new(assign_box, "role.png", TRUE);

  assign_table = rubrica_ui_table_new(4, 4, FALSE, 2, 2, 2);
  gtk_box_pack_start(GTK_BOX(assign_box), assign_table, FALSE, 0, 0);

  rubrica_ui_tabled_label_new(assign_table, _("Assigment"),       0, 1, 0, 1);
  rubrica_ui_tabled_label_new(assign_table, _("Organization"),    2, 3, 0, 1);
  rubrica_ui_tabled_label_new(assign_table, _("Department"),      0, 1, 1, 2);
  rubrica_ui_tabled_label_new(assign_table, _("Sub-department"),  2, 3, 1, 2);
  rubrica_ui_tabled_label_new(assign_table, _("Secretary name"),  0, 1, 2, 3);
  rubrica_ui_tabled_label_new(assign_table, _("Secretary phone"), 2, 3, 2, 3);
  
  form->work.role = rubrica_ui_tabled_entry_new(assign_table, 1, 2, 0, 1);
  form->work.dep  = rubrica_ui_tabled_entry_new(assign_table, 1, 2, 1, 2);
  form->work.sub  = rubrica_ui_tabled_entry_new(assign_table, 3, 4, 1, 2);
  form->work.org  = rubrica_ui_tabled_entry_new(assign_table, 3, 4, 0, 1);
  form->work.secretary = rubrica_ui_tabled_entry_new(assign_table, 1, 2, 2, 3);
  form->work.phone = rubrica_ui_tabled_entry_new(assign_table, 3, 4, 2, 3);

  return (GtkWidget *) work_frame;  
}

GtkWidget *rubrica_form_create_card_notes_page(RubricaCardForm *form)
{
  GtkWidget *note_frame;
  GtkWidget *note_box;
  GtkWidget *pers_frame;
  GtkWidget *pers_box;
  GtkWidget *pers_table;
  GtkWidget *pix_lbl;
  GtkWidget *pix;
  GtkWidget *pix_box;
  GtkWidget *pubkey_frame;
  GtkWidget *pub_lbl;
  GtkWidget *hpixbox;
  GtkWidget *pub_pix;
  GtkWidget *pub_box;
  GtkWidget *pubscroll;
  GtkWidget *check_box;
  GtkWidget *label;

  note_frame = rubrica_ui_frame_new(_("Misc"));
  note_box = gtk_vbox_new(FALSE, 2);
  gtk_container_add(GTK_CONTAINER(note_frame), note_box);
  gtk_widget_show(note_box);

  pers_frame = rubrica_ui_frame_new(_("Personal Notes"));
  gtk_box_pack_start(GTK_BOX(note_box), pers_frame, TRUE, TRUE, 2);

  pers_box = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(pers_frame), pers_box);
  gtk_widget_show(pers_box);
  rubrica_ui_pack_in_box_image_new(pers_box, "post-it.png", TRUE);
  
  check_box = rubrica_ui_box_new(HBOX, FALSE, 2, 2);
  gtk_box_pack_start(GTK_BOX(pers_box), check_box, TRUE, TRUE, 2);
  
  label = rubrica_ui_label_new(_("Know"));
  form->notes.is_married = rubrica_ui_check_button_new(_("_Married"));
  form->notes.birthknow = rubrica_ui_check_button_new(_("_spouse's birthday"));
  form->notes.anniverknow = rubrica_ui_check_button_new(_("marriage _anniversary"));
  
  gtk_box_pack_start(GTK_BOX(check_box), form->notes.is_married, 
		     TRUE, TRUE, 2);
  gtk_box_pack_start(GTK_BOX(check_box), label,  FALSE, FALSE, 2);
  gtk_box_pack_start(GTK_BOX(check_box), form->notes.birthknow,  
		     TRUE, TRUE, 2);
  gtk_box_pack_start(GTK_BOX(check_box), form->notes.anniverknow,
		     TRUE, TRUE, 2);

  pers_table = rubrica_ui_table_new(5, 4, FALSE, 2, 2, 2);
  gtk_box_pack_start(GTK_BOX(pers_box), pers_table, FALSE, 0, 0);
  
  rubrica_ui_tabled_label_new(pers_table, _("Spouse's name"),     0, 1, 0, 1);
  rubrica_ui_tabled_label_new(pers_table, _("Spouse's birthday"), 0, 1, 1, 2); 
  rubrica_ui_tabled_label_new(pers_table, _("Anniversary"),       2, 3, 1, 2);

  form->notes.spouse     = rubrica_ui_tabled_entry_new(pers_table, 1, 4, 0, 1);
  form->notes.birthdate  = rubrica_ui_tabled_date_new(pers_table, 1, 2, 1, 2);
  form->notes.anniverdate = rubrica_ui_tabled_date_new(pers_table, 3, 4, 1, 2);

  form->notes.has_children = rubrica_ui_tabled_check_new(pers_table,
							 _("Children"),
							 0, 1, 2, 3);
  form->notes.children = rubrica_ui_text_view_new();
  rubrica_ui_tabled_text_view(pers_table, form->notes.children, 1, 4, 2, 3);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.birthknow), 
			       FALSE);
  gtk_widget_set_sensitive(form->notes.birthdate, FALSE);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.anniverknow), 
			       FALSE);
  gtk_widget_set_sensitive(form->notes.anniverdate, FALSE);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.is_married),
			       FALSE);
  gtk_widget_set_sensitive(form->notes.birthknow, FALSE);
  gtk_widget_set_sensitive(form->notes.anniverknow, FALSE);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(form->notes.has_children),
			       FALSE);
  gtk_widget_set_sensitive(form->notes.children, TRUE);

  /*     Other notes 
  */
  hpixbox = rubrica_ui_box_new(HBOX, FALSE, 2, 2);
  pix_box = rubrica_ui_box_new(VBOX, FALSE, 2, 2);
  pix_lbl = rubrica_ui_label_new(_("Hobbies"));
  pix = rubrica_ui_image_new("multimedia.png");
  gtk_box_pack_start(GTK_BOX(hpixbox), pix_box, FALSE, FALSE, 0); 
  gtk_box_pack_start(GTK_BOX(pix_box), pix_lbl, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(pix_box), pix, FALSE, FALSE, 0);
  rubrica_ui_tabled_widget(pers_table, hpixbox, 0, 1, 3, 4);

  form->notes.hobbies = rubrica_ui_text_view_new();
  rubrica_ui_tabled_text_view(pers_table, form->notes.hobbies, 1, 4, 3, 4);

  rubrica_ui_tabled_label_new(pers_table, _("Other notes"), 0, 1, 4, 5);
  form->notes.notes = rubrica_ui_text_view_new();
  rubrica_ui_tabled_text_view(pers_table, form->notes.notes, 1, 4, 4, 5);

  /*     Public Key frame
   */
  pubkey_frame = rubrica_ui_frame_new(_("Public Key"));
  gtk_box_pack_start(GTK_BOX(note_box), pubkey_frame, TRUE, TRUE, 2);

  pub_box = rubrica_ui_box_new(HBOX, FALSE, 2, 5);
  gtk_container_add(GTK_CONTAINER(pubkey_frame), pub_box);

  pix_box = rubrica_ui_box_new(VBOX, FALSE, 2, 5);
  pub_lbl = rubrica_ui_label_new(_("Key"));
  pub_pix = rubrica_ui_image_new("keys.png");
  gtk_box_pack_start(GTK_BOX(pix_box), pub_lbl, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(pix_box), pub_pix, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(pub_box), pix_box, FALSE, FALSE, 0);
  
  form->notes.pubkey = rubrica_ui_text_view_new();
  pubscroll = rubrica_ui_scrolled_window_new();
  gtk_container_add(GTK_CONTAINER(pubscroll), form->notes.pubkey);
  gtk_box_pack_start(GTK_BOX(pub_box), pubscroll, TRUE, TRUE, 0);

  g_signal_connect(G_OBJECT(form->notes.is_married), "toggled", 
		   G_CALLBACK(married_check_toggled), form); 

  g_signal_connect(G_OBJECT(form->notes.birthknow), "toggled", 
		   G_CALLBACK(option_check_toggled), form->notes.birthdate); 

  g_signal_connect(G_OBJECT(form->notes.anniverknow), "toggled", 
		   G_CALLBACK(option_check_toggled), form->notes.anniverdate); 
  
  g_signal_connect(G_OBJECT(form->notes.has_children), "toggled", 
		   G_CALLBACK(option_check_toggled), form->notes.children);

  return (GtkWidget *) note_frame;
}
