=begin
$Id: manual.rd,v 1.2 2001/08/02 20:29:13 tam Exp $

== RubyMagick - Ruby interface for ImageMagick

((* This manual is far from complete. Sorry for inconviniece. *))

= Magick::Image

== class method

=== instance generation

--- Magick::Image.new()

This class method only initializes Magick::Image object, without
any image entity.  You need to have this object create a new image, or
read image(s) from some external file(s) by either of following ways.

 * After setting image attributes(such as the size, background color, etc.) with ((<Magick::Image#set>)), create a new image by ((<Magick::Image#read>)).

 * Specify the name of image file in ((<Magick::Image#read>))

--- Magick::Image.new("filename1" [, "filename2", ...])

Creates a new Magick::Image from ((|filename|)).
If multiple ((|filename|)) are specified, an image sequence
is generated.

--- Magick::Image.ping("filename")

returns an Array object whose elements are the width, height,
size(in byte), format of the image in ((|filename|)).
Image format is a string such as "GIF".

== method

--- Magick::Image#read("filename1" [, "filename2", ...])

you can specify the following special arguments
provided by ImageMagick.

+ "NULL:<color name>"

creates a new image with specified ((|color name|)).
If some image attributes has been set by ((<Magick::Image#set>))
in advance of using this method, the generated image
will have these attributes.

+ "logo:"

the 'Wizard' image provided by ImageMagick will be created.

+ "plasma:#xxxxxx-#xxxxxx"

+ "gradient:#xxxxxx-#xxxxxx"


=== Image sequence

Besides using ((<Magick::Image#read>)) with mulitple arguments,
you can create an image sequence by ((<Magick::Image#push>))

--- Magick::Image#push(image)

* image : ((<Magick::Image>)) object

If a sequence is pushed, the top of the image sequence
of ((|image|)) object will be added to the destination object.
Each of the image sequence is indexed from 0.

RubyMagick provides the following methods to refer or access
each image.

--- Magick::Image#at(pos) { |im| block... }

the ((|pos|))-th image is passed to block as the block argument ((|im|)).

--- Magick::Image#each { |im| block... }

=== Getting or Setting image attributes

You can access members of Image and ImageInfo structure(image attributes)
by ((<Magick::Image#get>)) or ((<Magick::Image#set>)).

--- Magick::Image#get("attr1" [, "attr2", ...])

get values specified by the attributes ((|attr1|)), ((|attr2|)).
When multiple attributes are specified, it returns an Array
consists of corresponding attribute values.

--- Magick::Image#set({"attr1"=>value1 [, "attr2"=>value2, ...]})

set the values of attributes ((|attr1|)), ((|attr2|)) as "key"=>"value" pair(Hash).

=== List of image attributes

See Image.html, or ImageInfo.html in ImageMagick distribution
for details.

=== "adjoin"

+ set({"adjoin"=>bool})

+ get("adjoin") => bool (true or false)

=== "antialias"

+ set({"antialias"=>bool})

+ get("antialias") => bool (true or false)

=== "background"

+ set({"background"=>str})

((|str|)) is a string representing color name. See color.html in
ImageMagick distribution.

+ get("background") => str

=== "base-column"

+ get("base-column") => num

=== "base-filename"

+ get("base-filename") => str

=== "blue-primary"

+ set({"blue-primary"=>"float, float"})

+ get("blue-primary") => str

=== "bordercolor"

+ set({"bordercolor"=>str})

+ get("bordercolor") => str

=== "cache-threshold"

+ set({"cache-threshold"=>num})

+ get("cache-threshold") => num

=== "class"

+ get("class") => num

=== "colormap"

+ set({"colormap[i]"=>str})

+ get("colormap[i]") => str

=== "colors"

+ get("colors") => num

=== "colorspace"

+ set({"colorspace"=>ColorspaceType})

((|ColorspaceType|)) is a constant defined in Magick::ColorspaceType.

=== "columns"

+ get("columns") => num

=== "comment"

+ get("comment") => str

=== "compress"

+ set({"compress"=>CompressType})

((|CompressType|)) is a constant defined in Magick::CompressType.

+ get("compress") => num

=== "delay"

+ set({"delay"=>num})

+ get("delay") => num

=== "density"

+ set({"density"=>str})

+ get("density") => str

=== "depth"

+ set({"depth"=>num})

+ get("density")

=== "directory"

+ get("directory") => str

=== "display"

+ set({"display"=>str})

=== "dispose"

+ set({"dispose"=>0 or 1 or 2 or 3})

+ get("dispose") => num

=== "dither"

+ set({"dither"=>bool})

+ get("dither") => bool

=== "error"

+ get("error") => float

=== "file"

+ set({"file"=>io})

=== "filename"

+ set({"filename"=>str}

+ get("filename") => str

=== "filesize"

+ get("filesize") => num

=== "filter"

+ set({"fileter"=>FileterType})

((|FilterType|)) is a constant defined in ((<Magick::FileterType>))

+ get("filter") => num

=== "font"

+ set({"font"=>str})

+ get("font") => str


=== "format"

+ get("format") => str

=== "fuzz"

+ set({"fuzz"=>num})

+ get("fuzz") => num

=== "gamma"

+ get("gamma") => float

=== "geometry"

+ set({"geometry"=> str})

+ get("geometry") => str

=== "green-primary"

+ set({"green-primary"=>"float, float"})

+ get("green-primary") => str

=== "height"

+ get("height") => num

=== "index"

+ set({"index[x,y]"=>num})

+ get("index[x,y]") => str

=== "interlace"

+ set({"interlace"=>InterlaceType})

((|InterlaceType|)) is a constants defined in ((<Magick::InterlaceType>))

+ get("interlace") => num

=== "iterations"

+ set({"iterations"=>num})

+ get("iterations") => num

=== "label"

+ set({"label"=>str})

+ get("label") => str

=== "loop"

+ set({"loop"=>num})

+ get("loop") => num

=== "magick"

+ set({"magick"=>str})

+ get("magick") => str

=== "matte"

+ set({"matte"=>bool})

+ get("matte")

=== "mattecolor"

+ set({"mattecolor"=>str})

+ get("mattercolor") => str

=== "maximum-error"

+ get("maximum-error") => float

=== "mean-error"

+ get("maximum-error") => float

=== "montage"

+ get("montage") => str

=== "monochrome"

+ set({"monochrome"=>bool})

+ get("monochrome") => bool

=== "page"

+ set({"page"=>str})

+ get("page") =>str

=== "pen"

+ set({"pen"=>str})

=== "pixel"

+ set({"pixel[x,y]"=>"r,g,b,o"})

+ get("pixel") => str

=== "pointsize"

+ set({"pointsize"=>num})

+ get("pointsize") => num

=== "quality"

+ set({"quality"=>num})

+ get("quality") => num

=== "red-primary"

+ set({"red-primary"}=>"float, float"})

+ get("red-primary") => str

=== "rendering-intent"

+ set({"rendering-intent"=>RenderingIntent})

((|RenderingIntent|)) is a constant defined in ((<Magick::RenderingIntent>)).

+ get("rendering-intent") => num

=== "rows"

+ get("rows") => num

=== "scene"

+ set({"scene"=>num})

+ get("scene") => num

=== "server"

=== "signature"

+ get("signature") => str

=== "size"

+ set({"size"=>geom_str})

+ get("size") => str

=== "subimage"

=== "subrange"

=== "taint"

+ get("taint") => bool

=== "texture"

+ set({"texture"=>filename})

+ get("texture") => str

=== "tile"

+ set("tile"=>filename)

+ get("tile") => str

=== "type"

+ get("type") => num

=== "units"

+ set("units"=>ResolutionType)

((|ResolutionType|)) is a constant defined in ((<Magick::ResolutionType>))

+ get("units") => str

=== "verbose"

+ set("verbose"=>bool)

+ get("verbose") => bool

=== "view"

+ get("view") => str

=== "width"

+ get("width") => num

=== "x-resolution"

+ get("x-resolution") => num

=== "y-resolution"

+ get("y-resolution") => num


=== Write an image

--- Magick::Image#write({"attr1"=>val, ...})

Write a (possibly sequence of) image with specified attriburtes
given as hash.

=== Image Effect

--- Magick::Image#add_noise(NoiseType)

* ((|NoiseType|)) : one of constants defined in ((<Magick::NoiseType>))

--- Magick::Image#blur(radius, sigma)

* ((|radius|)) : aFloat or aFixnum
* ((|sigma|))  : aFloat or aFixnum

--- Magick::Image#colorize(opacity, color)

* ((|opacity|)) : aString
* ((|color|)) : aString.

--- Magick::Image#convolve(coef)

* ((|coef|)) : Array object consists of odd numbers of elements.

--- Magick::Image#despeckle

--- Magick::Image#edge(radius)

* ((|radius|)) : aFloat

--- Magick::Image#emboss(radius, sigma)

* ((|radius|)) : aFloat
* ((|sigma|))  : aFloat

--- Magick::Image#enhance

--- Magick::Image#gaussian_blur(radius, sigma)

* ((|radius|)) : aFloat
* ((|sigma|))  : aFloat

--- Magick::Image#implode(factor)

* ((|factor|)) : aFloat

--- Magick::Image#median_filter(radius)

* ((|radius|)) : aFloat

--- Magick::Image#morph(frames)

* ((|frames|)) : aFixnum

--- Magick::Image#mortion_blur(radius, sigma, amount)

* ((|radius|)) : aFloat
* ((|sigma|))  : aFloat
* ((|amount|)) : aFloat

--- Magick::Image#oilpaint(radius)

* ((|radius|)) : aFloat

--- Magick::Image#plasma(segment, attenuate, depth)

* ((|segment|))   : anArray of shape [x1, x2, y1, y2]
* ((|attenuate|)) : aFixnum
* ((|depth|))     : aFixnum

--- Magick::Image#reduce_noise(radius)

* ((|radius|)) : aFloat

--- Magick::Image#shade(color_shading, azimuth, elevation)

* ((|color_shading|)) : (({true})) or (({false}))
* ((|azimuth|)) : aFloat
* ((|elevation|)) : aFloat

--- Magick::Image#sharpen(radius, sigma)

* ((|radius|)) : aFloat
* ((|sigma|))  : aFloat

--- Magick::Image#solarize(factor)

* ((|factor|)) : aFloat(0.0-1.0)

--- Magick::Image#spread(amount)

* ((|amount|)) : aFixnum

--- Magick::Image#stegano(image)

* ((|image|)) : ((<Magick::Image>)) object

--- Magick::Image#stereo(offset_image)

* ((|offset_image|)) : ((<Magick::Image>)) object

--- Magick::Image#swirl(degree)

* ((|degree|)) : aFloat

--- Magick::Image#threshold(val)

* ((|val|)) : aFloat

--- Magick::Image#transparent(color, opacity)

* ((|color|)) : aString
* opacity     : Fixnum (0 .. Magick::TransparentOpacity)

To create full transparent image, set ((|opacity|)) to
(({Magick::TransparentOpacity}))

--- Magick::Image#unsharp_mask(radius, sigma, amount, threshold)

* ((|radius|))    : aFloat
* ((|sigma|))     : aFloat
* ((|amount|))    : aFloat
* ((|threshold|)) : aFloat


--- Magick::Image#wave(amplitude, wave_length)

* ((|amlitude|))    : aFloat
* ((|wave_length|)) : aFloat


=== Transform

--- Magick::Image#chop(geom)

* ((|geom|)) : anArray or geometry string.

--- Magick::Image#coalesce

--- Magick::Image#crop(geom)

* ((|geom|)) : anArray or geometry string.

--- Magick::Image#deconstruct

--- Magick::Image#flatten

--- Magick::Image#flip

--- Magick::Image#flop

--- Magick::Image#profile(profname, filename)

* profname : aString or (({nil}))
* filename : aString or (({nil}))

--- Magick::Image#roll(offset_x, offset_y)

* offset_x : aFixnum
* offset_y : aFixnum

--- Magick::Image#shave(geom)

* geom : geometry string (see ((<URL:misc.html>)))

--- Magick::Image#transform(geom, crop_geom)

* geom      : geometry string (see((<URL:misc.html>)))
* crop_geom : geometry string (see((<URL:misc.html>)))

--- Magick::Image#magnify

--- Magick::Image#minify

--- Magick::Image#resize(geom, FilterType, blur)

* geom : aString
* FilterType: ((<Magick::FilterType>))
* blur : aFloat

--- Magick::Image#sample(geom)

* geom : aString

--- Magick::Image#scale(geom)

* geom : aString

--- Magick::Image#zoom(geom)

* geom : aString

=== Drawing primitives

--- Magick::Image#annotate("key"=>"value")

--- Magick::Image#draw(drawable1 [,drawable2, ...])

* drawable : objects defined in classes under ((<Magick::Drawable>))

=== Montage

--- Magick::Image#montage({"key1"=>val1 [,"key2"=>val2, ...])

options for generating a montage image are given as hash keys.

==== available options

+ "filename"=>aString

+ "geometry"=>aString

+ "tile"=>aString

+ "title"=>aString

+ "frame"=>aString

+ "gravity"=>GravityType (see ((<Magick::GravityType>)))

+ "label"=>aString

+ "shadow"=>bool

+ "composite"=>CompositeOp

((|CompositeOp|)) is a constant defined in Magick::CompositeOp

+ "fill"=>aString

+ "stroke"=>aString

+ "background_color"=>aString

+ "border_color"=>aString

+ "border_width"=>aFixnum

+ "matte_color"=>aString

+ "font"=>aString

+ "texture"=>aString

=== handling colors

--- Magick::Image#compress_colormap

--- Magick::Image#number_colors([io])

* io : IO object

--- Magick::Image#is_grayscale_image?

--- Magick::Image#is_monochrome_image?

--- Magick::Image#is_opaque_image?

--- Magick::Image#is_pseudo_class?

=== Decoration

--- Magick::Image#border(geom, color)

* geom : aString
* color: aString

--- Magick::Image#frame(geom)

* geom : aString

--- Magick::Image#raise(geom, raised)

* geom   : aString
* raised : bool

=== Enhace

--- Magick::Image#contrast(sharpen)

* sharpen : bool

--- Magick::Image#equalize

--- Magick::Image#gamma(level)

* level : aString

Specify ((|level|)) as (({"r,g,b,o"})).
r, g, b, o are red, green, blue, opacity value, respectively.

--- Magick::Image#modulate(modulation)

* modulation : aString

Specify ((|modulation|)) as (({"b,s,h"}))

--- Magick::Image#negate(grayscale)

* grayscale : bool

--- Magick::Image#normalize

--- Magick::Image#map(image, dither_flag)

* image       : ((<Magick::Image>)) object
* dither_flag : bool

--- Magick::Image#map_images(image, dither_flag)

* image       : ((<Magick::Image>)) object
* dither_flag : bool

--- Magick::Image#ordered_dither

--- Magick::Image#quantize({"key"=>value ["key2"=>value2,...]})

quantizes a image with specified option given as hash keys.
Available options are listed below.

+ "colorspace"=>ColorspaceType

((|ColorspaceType|)) is a constants defined in ((<Magick::ColorspaceType>))

+ "dither"=>(({true})) or (({false}))

+ "measure_error"=>(({true})) or (({false}))

+ "colors"=>aFixnum

--- Magick::Image#quantize_images({"key"=>value ["key2"=>value2,...]})

--- Magick::Image#segment(Colorspace, verbose, cluster, smooth)

* Colorspace : ((<Magick::ColorspaceType>))
* verbose    : bool
* cluster    : aFloat
* smooth     : aFloat

=== Shear or Rotate

--- Magick::Image#rotate(degree)

* degree : aFixnum

--- Magick::Image#shear(x_shear, y_shear)

* x_shear : aFixnum
* y_shear : aFixnum

=== Other methods

--- Magick::Image#channel(ChannelType)

* ChannelType : one of constants definend in ((<Magick::ChannelType>))

--- Magick::Image#composite(image, CompositeOp, offset_x, offset_y)

* image       : ((<Magick::Image>)) object
* CompositeOp : one of constants defined in ((<Magick::CompositeOp>))
* offset_x    : aFixnum
* offset_y    : aFixnum

--- Magick::Image#cycle_colormap(amount)

* amount : aFixnum

--- Magick::Image#describe(dest_io, [verbose_flag])

* dest_io      : IO
* verbose_flag : bool

--- Magick::Image#animate

--- Magick::Image#append(horizontal_direction=true)

* horizontal_direction : bool

--- Magick::Image#display

--- Magick::Image#bounding_box

--- Magick::Image#depth

--- Magick::Image#image_type

--- Magick::Image#scenes

--- Magick::Image#mogrify(option1 [, option2, ...])

* options : aString

((|options|)) is the command line options given to mogrify(1).

--- Magick::Image#mosaic

--- Magick::Image#rgb_transform(ColorspaceType)

* ColorspaceType : one of constants defined in ((<Magick::ColorspaceType>))

--- Magick::Image#texture(image)

* image : ((<Magick::Image>)) object

= Magick::Drawable

This modules collects the classes which define primitive drawables
available in ImageMagick. see also "magick.rb"

Instances of theses classes become arguments of ((<Magick::Image#draw>)).
You can draw primitives on an image by following ways.

 1. use class method 'new' whose arguments are parameters that determines the primitives of interest, create a new instance. Parameters are arguments listed at  the section of Drawing Primitives in 'DrawInfo.html' in ImageMagick documentation.
 2. set attributes with using the instance method 'set' to this object. Attributes are members of DrawInfo structure. See 'DrawInfo.html' in ImageMagick documentation for available attributes and desriptions.
 3. take it as an argument of ((<Magick::Image#draw>)).


== Magick::Drawable::Point

=== class method

--- Magick::Drawable::Point.new(image, x, y)

* image : ((<Magick::Image>)) object
* x, y  : aFixnum


=== method

--- Magick::Drawable::Point#set

== Magick::Drawable::Line

=== class method

--- Magick::Drawable::Line.new(image, x1, x2, y1, y2)

* image : ((<Magick::Image>)) object
* x1, y1, x2, y2 : aFixnum

== Magick::Drawable::Rectangle

=== class method

--- Magick::Drawable::Rectangle.new(image, x1, x2, y1, y2)

* image : ((<Magick::Image>)) object
* x1, y1, x2, y2 : aFixnum

== Magick::Drawable::Arc

=== class method

--- Magick::Drawable::Arc.new(image, startX,startY,endX,endY,startDegree,endDegree)

* image : ((<Magick::Image>)) object
* startX,startY,endX,endY,startDegree,endDegree : aFixnum

== Magick::Drawable::Ellipse

=== class method

--- Magick::Drawable::Ellipse.new(image, origX,origY,width,height,arcStart,arcEnd)

* image : ((<Magick::Image>)) object
* origX,origY,width,height,arcStart,arcEnd : aFixnum

== Magick::Drawable::Circle

=== class method

--- Magick::Drawable::Circle.new(image, origX,origY,perimX,perimY)

* image : ((<Magick::Image>)) object
* origX,origY,perimX,perimY : aFixnum

== Magick::Drawable::Polyline

=== class method

--- Magick::Drawable::Polyline.new(image, x1,y1,x2,y2,...)

* image : ((<Magick::Image>)) object
* x1,y1,... : aFixnum

== Magick::Drawable::Polygon

=== class method

--- Magick::Drawable::Polygon.new(image, x1,y1,x2,y2,...)

* image : ((<Magick::Image>)) object
* x1,y1, ... : aFixnum

== Magick::Drawable::Bezier

=== class method

--- Magick::Drawable::Bezier.new(image, x1,y1,x2,y2,...)

* image : ((<Magick::Image>)) object
* x1,y1, ... : aFixnum

== Magick::Drawable::Text

=== class method

--- Magick::Drawable::Text.new(image, text, x, y)

* image : ((<Magick::Image>)) object
* text : aString
* x, y : aFixnum

=end
