// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "colorscaletrue24.h"
#include "util.h"

ColorScaleTrueColor24::ColorScaleTrueColor24(int s, Visual* v, int msb)
  : ColorScale(s)
{
  // this makes the assumption of one byte per color.

  colors_ = new unsigned char[s*3];
#ifndef _WIN32
  int rs = decodeMask((unsigned long)v->red_mask);
  int gs = decodeMask((unsigned long)v->green_mask);
  int bs = decodeMask((unsigned long)v->blue_mask);
#else
  int rs = decodeMask((unsigned long)0x00FF0000);
  int gs = decodeMask((unsigned long)0x0000FF00);
  int bs = decodeMask((unsigned long)0x000000FF);
#endif
      
  // we need to check to byteswap when we have cross platforms

  if ((!msb && lsb()) || (msb && !lsb())) {
    for (int i=0; i<s; i++) {
      unsigned int r = psColors_[i*3+2];
      unsigned int g = psColors_[i*3+1];
      unsigned int b = psColors_[i*3];
      unsigned int a = 0;
      a |= r << rs;
      a |= g << gs;
      a |= b << bs;

      memcpy(colors_+i*3, &a, 3);
    }
  }
  else {
    for (int i=0; i<s; i++) {
      unsigned int r = psColors_[i*3+2];
      unsigned int g = psColors_[i*3+1];
      unsigned int b = psColors_[i*3];
      unsigned int a = 0;
      a |= r << rs;
      a |= g << gs;
      a |= b << bs;

      unsigned char* rr = (unsigned char*)(&a);
      *(colors_+i*3) = *(rr+3);
      *(colors_+i*3+1) = *(rr+2);
      *(colors_+i*3+2) = *(rr+1);
    }
  }
}

ColorScaleTrueColor24::~ColorScaleTrueColor24()
{
  if (colors_)
    delete [] colors_;
}

LinearScaleTrueColor24::LinearScaleTrueColor24(int s, 
					       unsigned short* indexCells,
					       unsigned char* colorCells,
					       int count, Visual* v, int msb) 
  : LinearScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor24(s, v, msb), 
    ColorScale(s) {}

LogScaleTrueColor24::LogScaleTrueColor24(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, Visual* v, int msb)
  : LogScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor24(s, v, msb), 
    ColorScale(s) {}

SquaredScaleTrueColor24::SquaredScaleTrueColor24(int s,
						 unsigned short* indexCells,
						 unsigned char* colorCells,
						 int count, Visual* v, int msb)
  : SquaredScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor24(s, v, msb), 
    ColorScale(s) {}

SqrtScaleTrueColor24::SqrtScaleTrueColor24(int s,
					   unsigned short* indexCells,
					   unsigned char* colorCells,
					   int count, Visual* v, int msb)
  : SqrtScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor24(s, v, msb), 
    ColorScale(s) {}

IISScaleTrueColor24::IISScaleTrueColor24(unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, Visual* v, int msb) 
  : IISScale(indexCells, colorCells, count),
    ColorScaleTrueColor24(IISSIZE, v, msb), 
    ColorScale(IISSIZE) {}

HistEquScaleTrueColor24::HistEquScaleTrueColor24(int s, 
						 unsigned short* indexCells,
						 unsigned char* colorCells,
						 int count, 
						 double* hist, int histsize,
						 Visual* v, int msb) 
  : HistEquScale(s, indexCells, colorCells, count, hist, histsize), 
    ColorScaleTrueColor24(s, v, msb), 
    ColorScale(s) {}

