// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#ifndef __compass_h__
#define __compass_h__

#include "marker.h"

class Compass : public Marker {
private:
  Vector p1;
  Vector p2;
  Vector pp1;
  Vector pp2;

  double radius;
  CoordSystem coordSystem;
  SkyFrame skyFrame;
  Tk_Font df;

  char* northText;
  char* eastText;
  int northArrow;
  int eastArrow;

  void render(Drawable, const Matrix&, double, RenderMode);

public:
  Compass(const Compass&);
  Compass(FrameBase* parent, const Vector& ctr, double r, 
	  const char* n, const char* e, int na, int ea,
	  CoordSystem, SkyFrame, 
	  const char* clr, int w, const char* f, 
	  const char* t, unsigned short prop, const char* c,
	  const List<Tag>& tag);
  ~Compass();

  Marker* dup() {return new Compass(*this);}
  void updateBBox();
  void edit(const Vector&, int);

  void rotateBegin() {}
  void rotate(const Vector& v, int h) {}
  void rotateEnd() {}

  void ps(int);
  int isIn(const Vector&);

  double getRadius() {return radius;}
  void setRadius(double);
  void setCoordSystem(CoordSystem, SkyFrame);
  void setLabels(const char*, const char*);
  void setArrows(int,int);
  const char* getNorthText() {return northText;}
  const char* getEastText() {return eastText;}
  int getNorthArrow() {return northArrow;}
  int getEastArrow() {return eastArrow;}

  void list(ostream&, CoordSystem, SkyFrame, SkyFormat, char);
  void listProperties(ostream&, char);
};

#endif
