'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: panedwindow.n,v 1.1.1.1 2004/04/02 22:35:04 joye Exp $
'\" 
.so man.macros
.TH panedwindow n 8.4 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
panedwindow \- Create and manipulate panedwindow widgets
.SH SYNOPSIS
\fBpanedwindow\fR \fIpathName \fR?\fIoptions\fR?
.SO
\-background	\-height	\-width
\-borderwidth	\-orient
\-cursor	\-relief
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-handlepad handlePad HandlePad
When sash handles are drawn, specifies the distance from the top or
left end of the sash (depending on the orientation of the widget) at
which to draw the handle.  May be any value accepted by \fBTk_GetPixels\fR.
.OP \-handlesize handleSize HandleSize
Specifies the side length of a sash handle.  Handles are always
drawn as squares.  May be any value accepted by \fBTk_GetPixels\fR.
.OP \-opaqueresize opaqueResize OpaqueResize
Specifies whether panes should be resized as a sash is moved (true),
or if resizing should be deferred until the sash is placed (false).
.OP \-sashcursor sashCursor SashCursor
Mouse cursor to use when over a sash.  If null,
\fBsb_h_double_arrow\fR will be used for horizontal panedwindows, and
\fBsb_v_double_arrow\fR will be used for vertical panedwindows.
.OP \-sashpad sashPad SashPad
Specifies the amount of padding to leave of each side of a sash.  May
be any value accepted by \fBTk_GetPixels\fR.
.OP \-sashrelief sashRelief SashRelief
Relief to use when drawing a sash.  May be any of the standard Tk
relief values.
.OP \-sashwidth sashWidth SashWidth
Specifies the width of each sash.  May be any value accepted by
\fBTk_GetPixels\fR.
.OP \-showhandle showHandle ShowHandle
Specifies whether sash handles should be shown.  May be any valid Tcl
boolean value.
.BE

.SH DESCRIPTION
.PP
The \fBpanedwindow\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a panedwindow widget.
Additional options, described above, may be specified on the command
line or in the option database to configure aspects of the panedwindow
such as its default background color and relief.  The
\fBpanedwindow\fR command returns the path name of the new window.
.PP
A panedwindow widget contains any number of panes, arranged
horizontally or vertically, according to the value of the
\fB\-orient\fR option.  Each pane contains one widget, and each pair of
panes is separated by a moveable (via mouse movements) sash.  Moving a
sash causes the widgets on either side of the sash to be resized.

.SH "WIDGET COMMAND"
.PP
The \fBpanedwindow\fR command creates a new Tcl command whose name is
the same as the path name of the panedwindow's window.  This command
may be used to invoke various operations on the widget.  It has the
following general form:
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
\fIPathName\fR is the name of the command, which is the same as
the panedwindow widget's path name.  \fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for panedwindow widgets:
.TP
\fIpathName \fBadd \fIwindow ?window ...? ?option value ...?\fR
Add one or more windows to the panedwindow, each in a separate pane.
The arguments consist of the names of one or more windows
followed by pairs of arguments that specify how to manage the windows.
\fIOption\fR may have any of the values accepted by the
\fBconfigure\fR subcommand.
.TP
\fIpathName \fBcget \fIoption\fR
Returns the current value of the configuration option given by
\fIoption\fR.  \fIOption\fR may have any of the values accepted by the
\fBpanedwindow\fR command.
.TP
\fIpathName \fBconfigure \fI?option? ?value option value ...?\fR
Query or modify the configuration options of the widget.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string. \fIOption\fR may have
any of the values accepted by the \fBpanedwindow\fR command.
.TP
\fIpathName \fBforget \fIwindow ?window ...?\fR
Remove the pane containing \fIwindow\fR from the panedwindow.  All
geometry management options for \fIwindow\fR will be forgotten.
.TP
\fIpathName \fBidentify \fIx y\fR
Identify the panedwindow component underneath the point given by
\fIx\fR and \fIy\fR, in window coordinates.  If the point is over a
sash or a sash handle, the result is a two element list containing the
index of the sash or handle, and a word indicating whether it is over
a sash or a handle, such as {0 sash} or {2 handle}.  If the point is
over any other part of the panedwindow, the result is an empty list.
.TP
\fIpathName \fBproxy \fI?args?\fR
This command is used to query and change the position of the sash
proxy, used for rubberband-style pane resizing. It can take any of
the following forms:
.RS
.TP
\fIpathName \fBproxy coord\fR
Return a list containing the x and y coordinates of the most recent
proxy location.
.TP
\fIpathname \fBproxy forget\fR
Remove the proxy from the display.
.TP
\fIpathName \fBproxy place \fIx y\fR
Place the proxy at the given \fIx\fR and \fIy\fR coordinates.  
.RE
.TP
\fIpathName \fBsash \fI?args?\fR
This command is used to query and change the position of sashes in the
panedwindow.  It can take any of the following forms:
.RS
.TP
\fIpathName \fBsash coord \fIindex\fR
Return the current x and y coordinate pair for the sash given by
\fIindex\fR.  \fIIndex\fR must be an integer between 0 and 1 less than
the number of panes in the panedwindow.  The coordinates given are
those of the top left corner of the region containing the sash.
\fIpathName \fBsash dragto \fIindex x y\fR
This command computes the difference between the given coordinates and the
coordinates given to the last \fBsash coord\fR command for the given
sash.  It then moves that sash the computed difference.  The return
value is the empty string.
.TP
\fIpathName \fBsash mark \fIindex x y\fR
Records \fIx\fR and \fIy\fR for the sash given by \fIindex\fR; used in
conjunction with later dragto commands to move the sash.
.TP
\fIpathName \fBsash place \fIindex x y\fR
Place the sash given by \fIindex\fR at the given coordinates.
.RE
.TP
\fIpathName \fBpanecget \fIwindow option\fR
Query a management option for \fIwindow\fR.  \fIOption\fR may be any
value allowed by the \fBpaneconfigure\fR subcommand.
.TP
\fIpathName \fBpaneconfigure \fIwindow ?option? ?value option value ...?\fR
Query or modify the management options for \fIwindow\fR.  If no
\fIoption\fR is specified, returns a list describing all of the
available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.  The following options
are supported:
.RS
.TP
\fB\-after \fIwindow\fR
Insert the window after the window specified.  \fIwindow\fR should be the
name of a window already managed by \fIpathName\fR.
.TP
\fB\-before \fIwindow\fR
Insert the window before the window specified.  \fIwindow\fR should be
the name of a window already managed by \fIpathName\fR.
.TP
\fB\-height \fIsize\fR
Specify a height for the window.  The height will be the outer
dimension of the window including its border, if any.  If \fIsize\fR
is an empty string, or if \fB\-height\fR is not specified, then the
height requested internally by the window will be used initially; the
height may later be adjusted by the movement of sashes in the
panedwindow.  \fISize\fR may be any value accepted by \fBTk_GetPixels\fR.
.TP
\fB\-minsize \fIn\fR
Specifies that the size of the window cannot be made less than
\fIn\fR.  This constraint only affects the size of the widget in the
paned dimension -- the x dimension for horizontal panedwindows, the y
dimension for vertical panedwindows.  May be any value accepted by
\fBTk_GetPixels\fR.
.TP
\fB\-padx \fIn\fR
Specifies a non-negative value indicating how much extra space to
leave on each side of the window in the X-direction.  The value may 
have any of the forms accepted by \fBTk_GetPixels\fR.
.TP
\fB\-pady \fIn\fR
Specifies a non-negative value indicating how much extra space to
leave on each side of the window in the Y-direction.  The value may 
have any of the forms accepted by \fBTk_GetPixels\fR.
.TP
\fB\-sticky \fIstyle\fR
If a window's pane is larger than the requested dimensions of the
window, this option may be used to position (or stretch) the window
within its pane.  \fIStyle\fR  is a string that contains zero or more
of the characters \fBn\fP, \fBs\fP, \fBe\fP or \fBw\fP.  The string
can optionally contains spaces or commas, but they are ignored.  Each
letter refers to a side (north, south, east, or west) that the window
will "stick" to.  If both \fBn\fP and \fBs\fP (or \fBe\fP and \fBw\fP)
are specified, the window will be stretched to fill the entire height
(or width) of its cavity.
.TP
\fB\-width \fIsize\fR
Specify a width for the window.  The width will be the outer
dimension of the window including its border, if any.  If \fIsize\fR
is an empty string, or if \fB\-width\fR is not specified, then the
width requested internally by the window will be used initially; the
width may later be adjusted by the movement of sashes in the
panedwindow.  \fISize\fR may be any value accepted by \fBTk_GetPixels\fR.
.RE
.TP
\fIpathName \fBpanes\fR
Returns an ordered list of the widgets managed by \fIpathName\fR.

.SH "RESIZING PANES"

A pane is resized by grabbing the sash (or sash handle if present) and
dragging with the mouse.  This is accomplished via mouse motion
bindings on the widget.  When a sash is moved, the sizes of the panes
on each side of the sash, and thus the widgets in those panes, are
adjusted.
.PP
When a pane is resized from outside (eg, it is packed to expand and
fill, and the containing toplevel is resized), space is added to the final
(rightmost or bottommost) pane in the window.

.SH KEYWORDS
panedwindow, widget, geometry management
