'\"
'\" Generated from file './img-pcx.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 1995-2003 Jan Nijtmans <nijtmans@users.sourceforge.com>
'\"
'\" -*- tcl -*- doctools
'\" -*- tcl -*- doctools = format-header.inc
.so man.macros
.TH "img-pcx" n 1.3  "Img"
.BS
.SH "NAME"
img-pcx \- Img, Paintbrush Format (pcx)
.SH "SYNOPSIS"
package require \fBTk \fR
.sp
package require \fBimg::pcx  ?1.3?\fR
.sp
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?\fR
.sp
.BE
.SH "DESCRIPTION"
The package \fBimg::pcx\fR is a sub-package of
\fBImg\fR. It can be loaded as a part of the complete Img support,
via \fBpackage require Img\fR, or on its own, via
\fBpackage require img::pcx\fR.
.PP
Like all packages of \fBImg\fR it does \fInot\fR provide new
commands, but extends the existing \fBTk\fR command \fBimage\fR so
that it supports files containing raster images in the
Paintbrush Format (pcx). More specifically
\fBimg::pcx\fR extends \fBTk\fR's \fBphoto\fR
image type.
.PP
The name of the new format handler is \fBpcx\fR.
This handler provides new additional configuration options. See
section \fBPCX OPTIONS\fR for more detailed explanations.
'\" -*- tcl -*- doctools = format-middle.inc
.PP
All of the above means that in a call like
.TP
\fBimage\fR \fBcreate photo\fR ?\fIname\fR? ?\fIoptions\fR?\fR
.IP [1]
Image data in pcx format (options \fB-data\fR and \fB-file\fR) is
detected automatically.
.IP [2]
The format name \fBpcx\fR is recognized by the option \fB-format\fR.
In addition the value for the option is treated as list and may
contain any of the special options listed in section
\fBPCX OPTIONS\fR.
.SH "SUPPORTED PCX TYPES"
.nf
  1-bit pixels: Black and White.
  8-bit pixels: Grayscale or indexed.
 24-bit pixels: True-color (RGB, each channel 8 bit).

 List of currently supported features:

 Type   |     Read      |     Write     |
        | -file | -data | -file | -data |
 ----------------------------------------
  1-bit | Yes   | Yes   | No    | No    |
  8-bit | Yes   | Yes   | No    | No    |
 24-bit | Yes   | Yes   | Yes   | Yes   |

 All images types may be either uncompressed or run-length encoded.
.fi
.SH "PCX OPTIONS"
The handler provides the following options:
.TP
\fB-verbose\fR \fIbool\fR
This option is supported for reading and writing.
.sp
If set to \fBtrue\fR, additional information about the loaded/stored image
is printed to stdout. Default is \fBfalse\fR.
.TP
\fB-compression\fR \fItype\fR
This option is supported for writing only.
.sp
Set the compression mode to either \fBnone\fR or \fBrle\fR.
Default is \fBrle\fR.
'\" -*- tcl -*- doctools = format-footer.inc
.SH "SEE ALSO"
img-bmp, img-gif, img-ico, img-intro, img-jpeg, img-pcx, img-pixmap, img-png, img-ppm, img-ps, img-sgi, img-sun, img-tga, img-tiff, img-window, img-xbm, img-xpm
.SH "KEYWORDS"
image handling, pcx, tk
.SH "COPYRIGHT"
.nf
Copyright (c) 1995-2003 Jan Nijtmans <nijtmans@users.sourceforge.com>
.fi