.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.14
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "xpatcl n"
.TH xpatcl n "June 24, 2004" "version 2.1.6" "SAORD Documentation"
.SH "NAME"
\&\fBXPATcl: the XPA Interface to the Tcl/Tk Environment\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
Tcl/Tk programs can act as \s-1XPA\s0 clients and/or servers using the Tcl
interface to \s-1XPA\s0 that is contained in the libtclxpa.so shared object.
.PP
\&\fBServer Routines\fR
.PP
.Vb 11
\&  set xpa [xpanew class name help sproc sdata smode rproc rdata rmode]
\&  xpafree xpa
\&  set xpa [xpanew class name help iproc idata imode]
\&  set xpa [xpacmdnew class name]
\&  xpacmdadd xpa name help sproc sdata smode rproc rdata rmode
\&  xpacmddel xpa cmd
\&  set val [xparec xpa option]
\&    options: name, class, method, cmdfd, datafd, cmdchan, datachan
\&  xpasetbuf xpa buf len
\&  xpaerror xpa message
\&  xpamessage xpa message
.Ve
.PP
\&\fBClient Routines\fR
.PP
.Vb 11
\&  set xpa [xpaopen mode]
\&  xpaclose xpa
\&  set got [xpaget xpa template paramlist mode bufs lens names errs n]
\&  set got [xpaget xpa template paramlist mode chans names errs n]
\&  set got [xpaset xpa template paramlist mode buf len names errs n]
\&  set got [xpasetfd xpa template paramlist mode chan names errs n]
\&  set got [xpainfo xpa template paramlist mode names errs n]
\&  # NB: 2.1 calling sequence change
\&  # set got [xpaaccess template type] (2.0.5)
\&  set got [xpaaccess xpa template paramlist mode names errs n]
\&  set got [xpanslookup template type classes names methods]
.Ve
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
You can call \fIXPANew()\fR, \fIXPACmdNew()\fR, or \fIXPAInfoNew()\fR within a C
routine to add C\-based \s-1XPA\s0 server callbacks to a TCL/Tk program that
uses a Tcl/Tk event loop (either \fIvwait()\fR or the Tk event loop);
Such a program does not need or want to use the \s-1XPA\s0 event loop.
Therefore, in order to add \s-1XPA\s0 access points to the Tcl/Tk loop, the
following routine should be called beforehand:
.PP
.Vb 1
\&  int XPATclAddInput(XPA xpa);
.Ve
.PP
Normally, the xpa argument is \s-1NULL\s0, meaning that all current \s-1XPA\s0
access points are registered with the event loop.  However, if a
single \s-1XPA\s0 access point is to be added (i.e., after the event loop is
started) then the handle of that \s-1XPA\s0 access point can be passed to
this routine.
.PP
The significance of the \s-1XPA/TCL\s0 interface goes beyond the support for
using \s-1XPA\s0 inside C code. The interface allows you to write \s-1XPA\s0
servers and to make calls to the \s-1XPA\s0 client interface within the Tcl
environment using the Tcl language directly. The XPA/Tcl
interface can be loaded using the following package command:
.PP
.Vb 1
\&  package require tclxpa 2.0
.Ve
.PP
Alternatively, you can load the shared object (called libtclxpa.so ) directly:
.PP
.Vb 1
\&  load .../libtclxpa.so tclxpa
.Ve
.PP
Once the tclxpa package is loaded, you can use Tcl versions of \s-1XPA\s0
routines to define \s-1XPA\s0 servers or make client \s-1XPA\s0 calls.  The
interface for these routines is designed to match the Unix \s-1XPA\s0
interface as nearly as possible.  Please refer to
\&\s-1XPA\s0 Servers
and
\&\s-1XPA\s0 Clients
for general information about these routines.  
.PP
The file test.tcl in the \s-1XPA\s0 source directory gives examples for using the 
XPA/Tcl interface.
.PP
The following notes describe the minor differences between the interfaces.
.PP
\&\fBXPANew\fR
.PP
.Vb 1
\&  set xpa [xpanew class name help sproc sdata smode rproc rdata rmode]
.Ve
.PP
rproc and sproc routines are routines.  The calling sequence of the
rproc routine is identical to its C counterpart:
.PP
.Vb 1
\&  proc rec_cb { xpa client_data paramlist buf len } { ... }
.Ve
.PP
The sproc routine, however is slightly different from its C counterpart
because of the difficulty of passing data back from the callback to C:
.PP
.Vb 1
\&  proc sendcb { xpa client_data paramlist } { ... }
.Ve
.PP
Note that the C\-based server's char **buf and int *len arguments are
missing from the Tcl callback. This is because we did not know how to
fill buf with data and pass it back to the C routines for communication
with the client.  Instead, the Tcl server callback uses the following
routine to set buf and len:
.PP
.Vb 1
\&  xpasetbuf xpa buf len
.Ve
.PP
where:
.PP
.Vb 5
\&  arg           explanation
\&  ------        -----------
\&  xpa           the first argument of the server callback
\&  buf           the data to be returned to the client
\&  len           data length in bytes, (if absent, use length of the buf object)
.Ve
.PP
When this routine is called, a copy of buf is saved for transmission to
the client.
.PP
The fact that buf is duplicated means that \s-1TCL\s0 server writers might to
perform the I/O directly within the callback, rather than have \s-1XPA\s0 do it
automatically at the end of the routine.  To do this, set:
.PP
.Vb 1
\&  fillbuf=false
.Ve
.PP
in the xpanew smode and then perform I/O through the Tcl channel
obtained from:
.PP
.Vb 1
\&  set dchan [xparec $xpa datachan]
.Ve
.PP
where:
.PP
.Vb 5
\&  arg           explanation
\&  ------        -----------
\&  xpa           the first argument of the server callback
\&  datachan      literal string "datachan" that returns the data channel
\&  len           data length in bytes, (if absent, use length of the buf object)
.Ve
.PP
\&\s-1NB:\s0 datachan and cmdchan are not available under Windows. It is
necessary to use the \*(L"raw\*(R" equivalents: datafd and cmdfd.
.PP
The same considerations apply to the rproc for receive servers: a copy
of the incoming data is generated to pass to the receive callback. This
copy again can be avoided by using \*(L"fillbuf=false\*(R" in the rmode and then
reading the incoming data from datachan.
.PP
The send and receive callback routines can use the xpaerror and xpamessage
routines to send errors and messages back to the client.  If you also
want tcl itself to field an error condition, use the standard return call:
.PP
.Vb 1
\&  return ?-code c? ?-errorinfo i? ?-errorcode ec? string
.Ve
.PP
See the Tcl man page for more info.
.PP
\&\fBXPARec\fR
.PP
The Tcl xparec procedure supplies server routines with access to information 
that is available via macros in the C interface:
.PP
.Vb 1
\&  set val [xparec xpa <option>]
.Ve
.PP
where option is: name, class, method, cmdfd, datafd, cmdchan,
datachan.  Note that two additional identifiers, cmdchan and datachan,
have been added to to provide Tcl channels corresponding to datafd and
cmdfd.  (These latter might still be retrieved in Tcl and passed back
to a C routines.)  An additional option called \*(L"version\*(R" can be used to
determine the \s-1XPA\s0 version used to build the Tcl interface. Note that
the standard options require a valid \s-1XPA\s0 handle, but \*(L"version\*(R" does
not (since it simply reports the value of the \s-1XPA_VERSION\s0 definition
in the \s-1XPA\s0 source include file).
.PP
\&\s-1NB:\s0 datachan and cmdchan are not available under Windows. It is
necessary to use the \*(L"raw\*(R" equivalents: datafd and cmdfd.
.PP
.Vb 12
\&  macro         explanation
\&  ------        -----------
\&  class         class of this xpa
\&  name          name of this xpa
\&  method        method string (inet or local connect info)
\&  cmdchan       Tcl channel of command socket
\&  datachan      Tcl channel of data socket
\&  cmdfd         fd of command socket
\&  datafd        fd of data socket
\&  sendian       endian-ness of server ("little" or "big")
\&  cendian       endian-ness of client ("little" or "big"
\&  version       XPA version used to build this code
.Ve
.PP
Under Windows, the Tcl event handler cannot automatically sense when an
\&\s-1XPA\s0 socket is ready for \s-1IO\s0 (i.e. \fITcl_CreateFileHandler()\fR is not available
under Windows). The Windows Tcl event handler therefore must be awakened
occasionally for check for \s-1XPA\s0 events. This is done using the standard
\&\fITcl_SetMaxBlockTime()\fR call. The time parameter is defined in tclloop.c
and is currently set to 1000 microseconds (1/1000 of a second). 
.PP
The version option can be used to differentiate between source code versions.
It was created to support legacy Tcl code that needs to maintain the 2.0.5
calling sequence for xpaaccess. You can use a version test such as:
.PP
.Vb 5
\&  if [catch { xparec "" version } version] {
\&    puts "pre-2.1.0e"
\&  } else {
\&    puts [split $version .]
\&  }
.Ve
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See xpa(n) for a list of \s-1XPA\s0 help pages
