// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIR_AccessSubtypeDefinition.hh"
#include "IIR_Declaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_ProcedureDeclaration.hh"
#include "IIR_ConstantInterfaceDeclaration.hh"
#include "error_func.hh"
#include "symbol_table.hh"
#include "set.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


IIRScram_AccessTypeDefinition::IIRScram_AccessTypeDefinition(){
}

IIRScram_AccessTypeDefinition::~IIRScram_AccessTypeDefinition(){
}

void 
IIRScram_AccessTypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "access ";
  if ( get_designated_type()->_is_anonymous() == FALSE ){
    get_designated_type()->_get_declaration()->get_declarator()->_publish_vhdl(_vhdl_out);
  } else {
    get_designated_type()->_publish_vhdl_type_decl(_vhdl_out);
  }
}

const string
IIRScram_AccessTypeDefinition::_get_cc_kernel_type(){
  return "AccessType";
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_constructor_args( published_file & ){
  //I have nothing to do here
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_headers( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_AccessTypeDefinition::_publish_cc_headers" );
  _publish_cc_include( _cc_out, "tyvis/AccessType.hh" );
  get_designated_type()->_publish_cc_include( _cc_out );
}


void 
IIRScram_AccessTypeDefinition::_publish_cc_function_getpointer( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AccessTypeDefinition::_publish_cc_function_getpointer" );

  _cc_out << "virtual VHDLType* getPointer() const {" << NL()
	  << "  return val;" << NL()
	  << " }" << NL();
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_function_resetpointer( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AccessTypeDefinition::_publish_cc_function_resetpointer" );

  _cc_out << "virtual void resetPointer() {" << NL()
	  << "  val = NULL;" << NL()
	  << " }" << NL();
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_function_all( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AccessTypeDefinition::_publish_cc_function_all" );

  _cc_out << "VHDLType";
  _cc_out << "& all() {" << NL()
	  << "  return *val;" << NL()
	  << " }" << NL();
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_function_print( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AccessTypeDefinition::_publish_cc_function_print" );

  _cc_out << "virtual void print(ostream& os = cout) const {" << NL();
  _cc_out << "os << val" << "<< \" \" << NL();" << NL();
  _cc_out << "  val->print(os);" << NL();
  _cc_out << " }" << NL();
}

void 
IIRScram_AccessTypeDefinition::_add_decl_into_cgen_symbol_table(){
  ASSERT(get_designated_type() != NULL);
  if (get_designated_type() != this) {
    get_designated_type()->_add_decl_into_cgen_symbol_table();
  }
}


void 
IIRScram_AccessTypeDefinition::_publish_cc_function_setpointer( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_AccessTypeDefinition::_publish_cc_function_setpointer" );

  _cc_out << "virtual void setPointer(VHDLType* src) {" << NL();
  _cc_out << "if(src != NULL){" << NL();
  _cc_out << "  if(src->get_kind() == ACCESS_TYPE) {" << NL();
  _cc_out <<"     val = ((";
  _get_cc_type_name( );
  _cc_out << "*)src)->val;" << NL();;
  _cc_out << "   }" << NL(); 
  _cc_out << "   else {" << NL();
  _cc_out << "    val = (";
  get_designated_type()->_get_cc_type_name( );
  _cc_out <<" *)src;" << NL();
  _cc_out <<"   }" << NL();
  _cc_out << "  }" << NL();
  _cc_out << "  else {" << NL();
  _cc_out << "    val = NULL;" << NL();
  _cc_out <<"   }" << NL();
  _cc_out << " }" << NL();
  
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_lvalue( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_AccessTypeDefinition::_publish_cc" );
  _cc_out << _get_declaration()->_get_cc_type_name( );
}

void 
IIRScram_AccessTypeDefinition::_publish_cc_composite_init( published_file & ){
  //For access types there is no need fr any initialization in the
  // initState() function as they are initialized in the constructor itself.
}

void
IIRScram_AccessTypeDefinition::_publish_cc_constructor_args_type_info( published_file &_cc_out,
								       IIR *initialization ){
  if( get_designated_type()->_is_array_type() &&
      ( get_designated_type()->_is_anonymous() ||
	get_designated_type()->_is_unconstrained_array_type() ) &&
      initialization != NULL ){
    _cc_out << "," << NL();
    initialization->_publish_cc_lvalue( _cc_out );
  }
}

IIR_Boolean
IIRScram_AccessTypeDefinition::_is_scalar_type() {
  if((get_designated_type() != NULL) && (get_designated_type() != this)) {
    return get_designated_type()->_is_scalar_type();
  }
  else{
    return FALSE;
  }
}

IIR_Boolean
IIRScram_AccessTypeDefinition::_is_array_type() {
  if ((get_designated_type() != NULL) && (get_designated_type() != this)) {
    return get_designated_type()->_is_array_type();
  }
  else{
    return FALSE;
  }
}

IIR_Boolean
IIRScram_AccessTypeDefinition::_is_unconstrained_array_type() {
  if ((get_designated_type() != NULL) && (get_designated_type() != this)) {
    return get_designated_type()->_is_unconstrained_array_type();
  }
  else{
    return FALSE;
  }
}


IIR_Boolean
IIRScram_AccessTypeDefinition::_is_record_type() {
  if ((get_designated_type() != NULL) && (get_designated_type() != this)) {
    return get_designated_type()->_is_record_type();
  }
  else{
    return FALSE;
  }
}

IIR_Boolean 
IIRScram_AccessTypeDefinition::_designates_incomplete_type() {
  if(  get_designated_type() != NULL && 
       get_designated_type()->_is_incomplete_type_definition() == TRUE ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}

set<IIR_Declaration> *
IIRScram_AccessTypeDefinition::_find_declarations( IIR_Name *to_find ){
  if( get_designated_type() == NULL ){
    return NULL;
  }
  else{
    return get_designated_type()->_find_declarations( to_find );
  }
}

IIR_TypeDefinition *
IIRScram_AccessTypeDefinition::_get_element_subtype(){
  return get_designated_type()->_get_element_subtype();
}


void 
IIRScram_AccessTypeDefinition::_set_element_subtype( IIR_TypeDefinition *new_element_type ){
  ASSERT( get_designated_type() != NULL && get_designated_type()->_is_array_type() == TRUE );
  get_designated_type()->_set_element_subtype( new_element_type );
}

IIR_ScalarTypeDefinition *
IIRScram_AccessTypeDefinition::_get_index_subtype(){
  IIR_ScalarTypeDefinition *retval = NULL;

  if( get_designated_type() != NULL ){
    retval = get_designated_type()->_get_index_subtype();
  }

  return retval;
}

IIR_Int32
IIRScram_AccessTypeDefinition::_get_num_indexes(){
  ASSERT(get_designated_type() != NULL);
  return get_designated_type()->_get_num_indexes();
}


const string
IIRScram_AccessTypeDefinition::_get_cc_type_name(){
  return "AccessType";
}

void 
IIRScram_AccessTypeDefinition::_come_into_scope( symbol_table *sym_tab, 
						 IIR_TypeDeclaration *type_declaration ){
  
  sym_tab->get_in_scope_access_types()->add( (IIR_AccessTypeDefinition *)this );

  if( type_declaration->_get_implicit_declarations() == NULL ){
    IIR_TypeDefinition::_come_into_scope( sym_tab, type_declaration );
  
    char *name = "deallocate";
    IIR_ProcedureDeclaration *new_procedure_declaration = new IIR_ProcedureDeclaration();
    copy_location( this, new_procedure_declaration );
    new_procedure_declaration->set_declarator( IIR_Identifier::get( name, strlen(name ) ) );
    new_procedure_declaration->_set_is_implicit( TRUE );
    
    IIR_ConstantInterfaceDeclaration *new_interface_declaration;
    new_interface_declaration  = new IIR_ConstantInterfaceDeclaration();
    new_interface_declaration->_set_is_implicit( TRUE );
    copy_location( this, new_interface_declaration );
    
    name = "p";
    new_procedure_declaration->interface_declarations.append( new_interface_declaration );
    
    new_interface_declaration->set_declarator(  IIR_Identifier::get( name, strlen(name ) ) );
    new_interface_declaration->set_subtype( (IIR_AccessTypeDefinition *)this );
    new_interface_declaration->set_mode( IIR_INOUT_MODE );
    
    new_procedure_declaration->_add_declaration();
    
    type_declaration->_get_implicit_declarations()->add( new_procedure_declaration );    
  }
  else{
    sym_tab->add_declaration( type_declaration->_get_implicit_declarations() );    
  }
}

IIR_Boolean 
IIRScram_AccessTypeDefinition::is_element(){
  return get_designated_type()->is_element();
}

void 
IIRScram_AccessTypeDefinition::set_is_element( IIR_Boolean new_is_element ){
  get_designated_type()->set_is_element( new_is_element );
}


IIR *
IIRScram_AccessTypeDefinition::_clone(){
  IIR_AccessTypeDefinition *retval = new IIR_AccessTypeDefinition();
  _clone( retval );

  return retval;
}


void 
IIRScram_AccessTypeDefinition::_clone( IIR *copy_into ){
  ASSERT( copy_into->_is_iir_access_type_definition() == TRUE );
  IIR_AccessTypeDefinition *as_access_type = (IIR_AccessTypeDefinition *)copy_into;

  as_access_type->set_designated_type( get_designated_type() );

  IIR_TypeDefinition::_clone( copy_into );
}

void
IIRScram_AccessTypeDefinition::_publish_vhdl_subtype_decl(ostream &_vhdl_out){
  ASSERT(_get_type_mark() != NULL);
  ASSERT(_get_type_mark()->_get_declaration() != NULL);
  
  _get_type_mark()->_get_declaration()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_AccessTypeDefinition::_come_out_of_scope( symbol_table *sym_tab ){
  sym_tab->get_in_scope_access_types()->remove( (IIR_AccessTypeDefinition *)this );
}

IIR_TypeDefinition *
IIRScram_AccessTypeDefinition::_construct_new_subtype( IIR_Name *resolution_function,
						       IIR_ScalarTypeDefinition *new_constraint){
  IIR_AccessSubtypeDefinition *retval = new IIR_AccessSubtypeDefinition();
  IIR_TypeDefinition *new_designated_type;
  if( get_designated_type() != NULL && 
      get_designated_type()->_is_incomplete_type_definition() == FALSE ){
    new_designated_type = get_designated_type()->_construct_new_subtype( 0, new_constraint );
    retval->set_designated_subtype( new_designated_type );
  }
  else{
    ASSERT( new_constraint == NULL );
  }

  if( _is_subtype() == TRUE ){
    retval->set_base_type( get_base_type() );    
  }
  else{
    retval->set_base_type( this );
  }

  if( resolution_function != NULL ){
    retval->set_resolution_function( _resolve_resolution_function( resolution_function ) );
  }

  return retval;
}

IIR_AccessSubtypeDefinition *
IIRScram_AccessTypeDefinition::_construct_new_type( IIR_TypeDefinition *designated_type,
						    IIR_TypeDeclaration *type_decl ){
  IIR_AccessTypeDefinition *base_type = new IIR_AccessTypeDefinition();
  base_type->set_designated_type( designated_type );
  base_type->_set_declaration( type_decl );

  IIR_TypeDefinition *temp =  base_type->_construct_new_subtype( 0, 0 );
  ASSERT( temp->get_kind() == IIR_ACCESS_SUBTYPE_DEFINITION );
  IIR_AccessSubtypeDefinition *retval = (IIR_AccessSubtypeDefinition *)temp;
  retval->_set_declaration( type_decl );
  retval->set_designated_subtype( designated_type );

  return retval;
}


void 
IIRScram_AccessTypeDefinition::_set_resolution_function( IIR_FunctionDeclaration * ){
  ostringstream err;
  err << "Internal error - IIRScram_AccessTypeDefinition::_set_resolution_function was "
      << "called.  Resolution functions can't be associated with an access type and this "
      << "should have been caught earlier.";
  report_error( this, err.str() );
}

IIR_TypeDefinition *
IIRScram_AccessTypeDefinition::_index_constrain_array( IIR_ScalarTypeDefinition *constraint ){
  IIR_TypeDefinition *retval = this;
  ASSERT( get_designated_type() != NULL && get_designated_type()->_is_array_type() == true );
  get_designated_type()->_index_constrain_array( constraint );

  return retval;
}

visitor_return_type *
IIRScram_AccessTypeDefinition::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_AccessTypeDefinition(this, arg);
}
