
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Narayanan Thondugulam
//          Umesh Kumar V. Rajasekaran
//	    Magnus Danielson	cfmd@swipnet.se

//---------------------------------------------------------------------------

#include "IIRScram_ConfigurationDeclaration.hh"
#include "IIR_BlockConfiguration.hh"
#include "IIR_EntityDeclaration.hh"
#include "IIR_Identifier.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_ArchitectureStatementList.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"

IIRScram_ConfigurationDeclaration::~IIRScram_ConfigurationDeclaration() {}


void 
IIRScram_ConfigurationDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  context_items._publish_vhdl(_vhdl_out);

  _vhdl_out << " configuration ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " of ";
  get_entity()->get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is\n";
  configuration_declarative_part._publish_vhdl_decl(_vhdl_out);
  get_block_configuration()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " end configuration ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " ;\n";
}


IIRScram_Declaration::declaration_type 
IIRScram_ConfigurationDeclaration::_get_type(){
   return CONFIGURATION;
}

void
IIRScram_ConfigurationDeclaration::_publish_vhdl_binding_name(ostream &_vhdl_out){
  _vhdl_out << " configuration ";
  get_declarator()->_publish_vhdl(_vhdl_out);
}

void
IIRScram_ConfigurationDeclaration::_publish_vhdl_with_library_name(ostream &_vhdl_out){
  _vhdl_out << " configuration ";
  ASSERT(_get_declarative_region() != NULL);
  ASSERT(_get_declarative_region()->get_kind() == IIR_LIBRARY_DECLARATION);
  _get_declarative_region()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ".";
  get_declarator()->_publish_vhdl(_vhdl_out);
}


void
IIRScram_ConfigurationDeclaration::_publish_cc_elaborate(){
  _set_currently_publishing_unit(CONFIGURATION_DECLARATION);
  _set_current_entity_name( get_entity()->_get_declarator()->_convert_to_string() );
  _set_current_configuration_name( _get_declarator()->_convert_to_string() );
  _set_current_architecture_name( _get_configured_architecture()->_get_declarator()->_convert_to_string() );
  _publish_cc_headerfile();
  _publish_cc_ccfile();
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_headerfile() {
  const string filename = _get_cc_elaboration_class_name();
  //Publishing the .hh file
  published_header_file header_file( _get_library_directory(), 
				     filename,
				     this );
  IIRScram::_publish_cc_include( header_file, "tyvis/STDTypes.hh" );

  SCRAM_CC_REF( header_file, "IIRScram_ConfigurationDeclaration::_publish_cc_headerfile" );

  header_file << "// Header files needed for this architecture\n";
  _publish_cc_headers( header_file );
  header_file << "\n// Forward reference classes needed for this architecture\n";

  _publish_cc_class_includes( header_file );
  header_file << "\n// Elaboration Class for the this architecture\n";
  _publish_cc_class( header_file );
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_headers( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_headers" );

  get_entity()->_publish_cc_include_decls( _cc_out );
  get_block_configuration()->_publish_cc_headers( _cc_out );
  configuration_declarative_part._publish_cc_headers( _cc_out );
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_class_includes( published_file &_cc_out ) {
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_class( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_class" );

  _cc_out << "class " 
	  << _get_cc_elaboration_class_name() 
	  << " : public _savant_entity_elab {\n"
	  << "public:\n";

  //Publishing the constructor and destructor
  _cc_out << _get_cc_elaboration_class_name() << "();\n";

  IIR_EntityDeclaration* entitydecl = get_entity();
  if(entitydecl->generic_clause.num_elements() > 0) {
    _cc_out << _get_cc_elaboration_class_name() << "(\n";
    entitydecl->generic_clause._publish_generic_parameter_list( _cc_out );
    _cc_out << " );\n";
  }

  _cc_out << "~" << _get_cc_elaboration_class_name() << "();\n\n"
	  << "void instantiate(Hierarchy * hier);\n"
	  << "void createNetInfo();\n"
	  << "void connect(int, int, ...);\n"
	  << "void buildSignalTree();\n"
	  << "void partition() {}\n";

  get_entity()->generic_clause._publish_cc_elaborate( _cc_out );

  //Publishing the pointers to processes and objects used in this architecture
  _publish_cc_object_pointers( _cc_out );

  _cc_out << "};\n";
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_object_pointers( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_object_pointers" );

  _cc_out << _get_configured_architecture()->_get_cc_elaboration_class_name()
	  << "* configuredEntity;\n";
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_ccfile(){
  const string filename = _get_cc_elaboration_class_name();

  published_cc_file cc_file( _get_library_directory(), 
			     filename,
			     this );

  SCRAM_CC_REF( cc_file, "IIRScram_ConfigurationDeclaration::_publish_cc_ccfile" );

  _publish_cc_include_elab( cc_file );
  _publish_cc_headerfiles_for_cc( cc_file );
  cc_file << "extern VHDLKernel *proc_array[];\n";
  _publish_cc_constructor( cc_file );
  _publish_cc_destructor( cc_file );
  _publish_cc_instantiate( cc_file );
  _publish_cc_createNetInfo( cc_file );
  _publish_cc_connect( cc_file );
  _publish_cc_getboundentityinfo( cc_file );
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_constructor( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_constructor" );

  _publish_cc_constructor_with_no_arguments( _cc_out );
  if (get_entity()->generic_clause.num_elements() > 0) {
    _publish_cc_constructor_with_arguments( _cc_out );
  }
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_constructor_with_no_arguments( published_file &_cc_out ) {
  int numGenericClause = get_entity()->generic_clause.num_elements();

  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_constructor_with_no_arguments" );
  
  _cc_out << _get_cc_elaboration_class_name() << "::"
	  << _get_cc_elaboration_class_name() << "()";

  if( numGenericClause > 0 ){
    _cc_out << ":\n";
    get_entity()->generic_clause._publish_generic_init( _cc_out );
  }
  _cc_out << " {\n";
  _publish_cc_object_pointers_init( _cc_out );
  _cc_out << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_constructor_with_arguments( published_file &_cc_out ) {
  int numGenericClause = get_entity()->generic_clause.num_elements();

  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_constructor_with_arguments" );

  _cc_out << _get_cc_elaboration_class_name() << "::"
	  << _get_cc_elaboration_class_name() << "(\n";
  get_entity()->generic_clause._publish_generic_parameter_list( _cc_out );
  _cc_out << " )";

  if(numGenericClause > 0) {
    _cc_out << ":\n";
    get_entity()->generic_clause._publish_generic_init_by_arguments( _cc_out );
  }
  _cc_out << " {\n";
  _publish_cc_object_pointers_init( _cc_out );
  _cc_out << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_object_pointers_init( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_object_pointers_init" );

  _cc_out << "configuredEntity = new "
	  << _get_configured_architecture()->_get_cc_elaboration_class_name() << "();\n";
  get_block_configuration()->_publish_cc_object_pointers_init( _cc_out );
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_destructor( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_destructor" );

  _cc_out << _get_cc_elaboration_class_name()
	  << "::~"
	  << _get_cc_elaboration_class_name()
	  << "() {\n"
	  << "   delete configuredEntity;\n"
	  << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_instantiate( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_instantiate" );

  _cc_out << "void\n"
	  << _get_cc_elaboration_class_name()
	  << "::instantiate(Hierarchy * hier) {\n"
	  << "  if(configuredEntity != NULL) {\n"
	  << "    configuredEntity->instantiate(hier);\n"
	  << "  }\n"
	  << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_createNetInfo( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_createNetInfo" );

  _cc_out << "void\n"
	  << _get_cc_elaboration_class_name()
	  << "::createNetInfo() {\n"
	  << "  if(configuredEntity != NULL) {"
	  << "    configuredEntity->createNetInfo();\n"
	  << "  }\n"
	  << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_connect( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_connect" );

  _cc_out << "void" << NL()
	  << _get_cc_elaboration_class_name()
	  << OS("::connect(int inputsignals, int outputsignals, ...) {")
	  << "int noOfSignals = inputsignals + outputsignals;" << NL()
	  << "va_list ap;" << NL()
	  << "va_start(ap, outputsignals);" << NL()
	  << OS("for( int i=0; i <noOfSignals; i++ ){")
	  << "  addToFanOut( va_arg(ap, VHDLType*) );" << NL()
	  << CS("}")
	  << "va_end(ap);" << NL();
  
  //Pass on the output connection  inforamtion to its output signals
  IIR_EntityDeclaration* entitydecl = get_entity();
  IIR_InterfaceDeclaration* portelement = NULL;
  IIR_Mode mode;
  int index = 0;

  _cc_out << OS("if( inputsignals > 0 ){") << NL();

  portelement = entitydecl->port_clause.first();
  while( portelement != NULL ){
    mode = portelement->get_mode();
    if(mode == IIR_IN_MODE ) {
      _cc_out << "setSourceInfo( configuredEntity->";
      portelement->_publish_cc_elaborate( _cc_out ); 
      _cc_out << "," << NL()
	      << "*(fanOutInfo[";
      _cc_out << index << "]) );" << NL();
      index++;
    }
    portelement = entitydecl->port_clause.successor(portelement);
  }
  _cc_out << CS("}") << NL();

  _cc_out << OS("if( outputsignals > 0 ){");

  portelement = entitydecl->port_clause.first();
  for(; portelement != NULL; ) {
    mode = portelement->get_mode();
    if(mode == IIR_INOUT_MODE || mode == IIR_OUT_MODE) {
      _cc_out << "Add( configuredEntity->";
      portelement->_publish_cc_elaborate( _cc_out ); 
      _cc_out << "," << NL()
	      << "*( fanOutInfo["
	      << index << "] ));" << NL();
      
      if (mode != IIR_OUT_MODE){
	_cc_out << "setSourceInfo( ";
	_cc_out << "configuredEntity->";
	portelement->_publish_cc_elaborate( _cc_out ); 
	_cc_out << "," << NL() 
		<< "*(fanOutInfo["
		<< index << "]));" << NL();
      }
      index++;
    }
    portelement = entitydecl->port_clause.successor(portelement);
  }
  _cc_out << CS("}")
	  << "configuredEntity->connect(0,0);" << NL()
	  << CS("}");
}


void
IIRScram_ConfigurationDeclaration::_publish_cc_getboundentityinfo( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_getboundentityinfo" );

  _cc_out << "void\n"
	  << _get_cc_elaboration_class_name()
	  << "::buildSignalTree() {\n"
	  << "  if(configuredEntity != NULL) {\n"
	  << "    configuredEntity->buildSignalTree();\n"
	  << "  }\n"
	  << "}\n";
}

void
IIRScram_ConfigurationDeclaration::_publish_cc_binding_name( ostream& outstream ){
  //  SCRAM_CC_REF( _cc_out, "IIRScram_ConfigurationDeclaration::_publish_cc_binding_name" );
  outstream << "SCFG" << *_get_declarator() << "_" << *get_entity()->_get_declarator()
	    << "_" << *_get_configured_architecture()->_get_declarator();
}

void 
IIRScram_ConfigurationDeclaration::_publish_cc_include_decls_prefix( ostream &os ){
  os << *_get_declarator() << "Cfg";
}


IIR_ArchitectureDeclaration*
IIRScram_ConfigurationDeclaration::_get_configured_architecture() {
  IIR* tmp_node = get_block_configuration()->get_block_specification();
  ASSERT(tmp_node->get_kind() == IIR_ARCHITECTURE_DECLARATION);
  IIR_ArchitectureDeclaration* arch_ptr = ((IIR_ArchitectureDeclaration*)tmp_node);  
  return arch_ptr;
}

void 
IIRScram_ConfigurationDeclaration::_make_interface_visible( symbol_table *sym_tab ){
  // get_entity()->_make_interface_visible( sym_tab );
}

void 
IIRScram_ConfigurationDeclaration::_type_check(){
  IIR_ArchitectureStatementList empty_list;

  if( get_block_configuration() != NULL ){
    get_block_configuration()->_type_check_configuration_item( empty_list, this );
  }
  
  configuration_declarative_part._type_check_configuration_specifications( empty_list );
  configuration_declarative_part._type_check_attribute_specifications( empty_list );
}

visitor_return_type *IIRScram_ConfigurationDeclaration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ConfigurationDeclaration(this, arg);
};
