
#ifndef IIRSCRAM_DESIGNATORLIST_HH
#define IIRSCRAM_DESIGNATORLIST_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Malolan Chetlur     
//          Narayanan Thondugulam
//          Krishnan Subramani  

#include "IIRBase_DesignatorList.hh"

template <class type> class set;
class IIR_StatementList;
class IIR_Label;
class IIR_TextLiteral;
class IIR_AboveAttribute;

class IIRScram_DesignatorList : public IIRBase_DesignatorList {
public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);
  
  void _publish_vhdl(ostream &);
  void _publish_cc_elements( published_file &_cc_out );

  void _add_decl_into_cgen_symbol_table();
  void _get_list_of_input_signals( set<IIR> *list );
  void _add_signals_to_sensitivity_list(IIR_DesignatorList* sensitivity_list);

  void _type_check_as_instantiation_list( IIR *instantiated_unit, 
					  IIR_List &,
					  IIR *configuration );

  // This method walks the designator list, looking for a label for an
  // instantiate statement that instantiates "instantiated_unit".  When
  // finding one, it returns the label.
  IIR_Label *_process_instantiate_statement( IIR_Declaration *instantiated_unit,
					     IIR *statement );

  IIR_Boolean _is_component_in_the_list(IIR_TextLiteral* component_name);

  IIR_Boolean _is_above_attribute_found();
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);

protected:
  IIRScram_DesignatorList() {}
  virtual ~IIRScram_DesignatorList() = 0;
    
private:
  void _process_by_all_or_others( IIR_Declaration *instantiated_unit,
				  IIR_List &,
				  IIR_Boolean by_all,
				  IIR *configuration );

  void _process_explicit_list( IIR_Declaration *instantiated_unit, 
			       IIR_List &,
			       IIR *configuration );    
};
#endif
