#ifndef IIRSCRAM_NAME_HH
#define IIRSCRAM_NAME_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_Name.hh"
#include "savant.hh"

// template <class type> class set;
class IIR_Declaration;
class IIR_DesignatorList;
class IIR_TextLiteral;
class IIR_Name;
template <class type> class set;

class IIRScram_Name : public IIRBase_Name {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  virtual ~IIRScram_Name() = 0;

  IIR_Boolean _is_name();
  IIR_Boolean _is_iir_name(){ return TRUE; }

  IIR_Boolean _is_object(); 
  IIR_Boolean _is_signal();
  IIR_Boolean _is_variable();
  IIR_Boolean _is_array_type();
  IIR_Boolean _is_static_expression();
  IIR_Boolean _is_longest_static_prefix();
  IIR_Boolean _is_composite_resolved_signal();
  virtual IIR_Boolean _is_by_all(){ return FALSE; }

  virtual void _set_subtype( IIR_TypeDefinition * );

  void _publish_cc_addChild( published_file &_cc_out );
  void _publish_cc_binding_name( ostream &outstream );
  const string _get_cc_type_name();

  virtual ostream &_print( ostream & os );
  virtual set<IIR_Declaration> *_symbol_lookup();
  virtual set<IIR_Declaration> *_symbol_lookup( IIR_Declaration * );
  virtual set<IIR_Declaration> *_symbol_lookup( set<IIR_Declaration> * );
  virtual set<IIR_Declaration> *_symbol_lookup( IIR_Boolean (IIR::*constraint_function)() );

  IIR_TextLiteral *_get_string();

  virtual void _get_list_of_input_signals( set<IIR> *list );  
  void _build_sensitivity_list(IIR_DesignatorList* sensitivity_list);
  void _get_signal_source_info( set<IIR> *siginfo );

  IIR_SignalKind _get_signal_kind();

  set<IIR_TypeDefinition> *
  _get_rval_set(IIR_Boolean (IIR::*constraint_function)() = 0){ 
    return IIR::_get_rval_set( constraint_function );
  }

  set<IIR_TypeDefinition> *_get_rval_set( set<IIR_TypeDefinition> *search_in,
					  IIR_Boolean (IIR::*constraint_function)() = 0 );
  set<IIR_TypeDefinition> *_get_rval_set( set<IIR_Declaration> *search_in,
					  IIR_Boolean (IIR::*constraint_function)() = 0 );

  virtual IIR *_get_suffix() { return NULL; }

  virtual void _set_suffix(IIR *suffix);

  /** This method returns the prefix as an IIR_TextLiteral...  (this
      SHOULD always be possible...) */
  virtual IIR_TextLiteral *_get_prefix_string();

  /** Find the first prefix.  It should be a library.  Return it. */
  virtual IIR_LibraryDeclaration *_get_library_declaration(){ return 0; }

  /** This method overloads the generic virtual method
      IIRScram::_get_declarator() to provide access to the declarator associated
      with the IIR hierarchies derived from this node.  This method is
      overloaded by IIRScram_SimpleName::_get_declarator.  The declarator for
      this node is actually the declarator associated with its prefix.  Hence,
      the actual declarator return is the declarator associated with the preifx
      [obtained by a call to get_preifx()->_get_declarator()]

      @return A IIR_TextLiteral* that points to the mangled declarator
      associated with the IIR hierarchy derived from "this" node.  */
  virtual IIR_TextLiteral *_get_declarator();

  void _clone( IIR * );

  virtual void _build_lib( IIR_LibraryUnit * );

protected:
  IIRScram_Name() {}
    
private:
};
#endif
